Scriptname zadPlayerScript extends ReferenceAlias

zadBQ00 Property questScript Auto  
zadLibs Property libs Auto
Formlist Property SitBlockKeywords Auto


Event OnPlayerLoadGame()
	questScript.Maintenance()
EndEvent

Event OnSit(ObjectReference akFurniture)
	actor akActor = libs.PlayerRef
	int numKeywords = SitBlockKeywords.GetSize()
	int i = 0
	while (i < numKeywords)
		if akFurniture.HasKeyword((SitBlockKeywords.GetAt(i) as Keyword))
			libs.log(akFurniture + " contains blocked keyword " + SitBlockKeywords.GetAt(i) + ". Not OnSitting.")
			return
		EndIf
		i += 1
	endwhile

	if akActor.WornHasKeyword(questScript.zad_DeviousDevice)
		libs.Log("OnSit()")
		if akActor.WornHasKeyword(questScript.zad_DeviousPlug)
			if akActor.WornHasKeyword(questScript.zad_HasPumps) && Utility.RandomInt() <= libs.Config.BaseBumpPumpChance * 2
				libs.NotifyPlayer("You mistakenly sit down on one of the pumps dangling from your groin.")
				libs.NotifyPlayer("You immediately regret this as the plugs inflate painfully inside of you.")
				questScript.Libs.Moan(akActor)
				questScript.Libs.UpdateExposure(akActor, 1)
				return
			EndIf				
			libs.UpdateExposure(akActor, 0.15)
			libs.NotifyPlayer("You awkwardly sit down, doing your best to avoid disturbing the plugs inside of you.")

		Else
			libs.NotifyPlayer("The Chastity Belt you are wearing makes sitting down rather awkward.")
		EndIf
	EndIf
EndEvent

Event OnSpellCast(Form akSpell)
	Spell tmp = (akSpell as Spell)
	if tmp == none
		return
	EndIf
	actor akActor = libs.PlayerRef
	if akActor.WornHasKeyword(questScript.zad_DeviousDevice) && akActor.WornHasKeyword(questScript.zad_DeviousPlug) && akActor.HasMagicEffectWithKeyword(questScript.zad_EffectVibrateOnSpellCast)
		libs.Log("OnSpellCast()")
		int cost = tmp.GetEffectiveMagickaCost(akActor)
		int duration = (cost * 0.1) as Int
		int vibStrength = (cost / 50) as Int
		if vibStrength > 5
			vibStrength = 5
		EndIf
		if vibStrength < 1
			vibStrength = 1
		EndIf
		if duration <= 0
			duration = 1
		EndIf
		;libs.NotifyPlayer("The plugs respond to the magicka flowing through you, and begin to vibrate!")
		if libs.Config.HardcoreEffects && Utility.RandomInt() <= vibStrength * 15
			;libs.Log("Interrupting cast.")
			; libs.PlayerRef.InterruptCast()
			; libs.NotifyPlayer("Your concentration wanes, and the spell fizzles.")
		EndIf
		libs.VibrateEffect(akActor, vibStrength, duration, teaseOnly=questScript.ShouldEdgeActor(akActor))
	EndIf
EndEvent
