Scriptname zadLibs extends Quest
; Libraries
SexLabFramework property SexLab auto
slaUtilScr Property Aroused Auto
zadConfig Property Config Auto

; Aroused Vars
Faction Property slaLockedArousal Auto

; Keywords
Keyword Property zad_DeviousPlug Auto
Keyword Property zad_DeviousBelt Auto
Keyword Property zad_DeviousBra Auto
Keyword Property zad_DeviousCollar Auto
Keyword Property zad_DeviousArmCuffs Auto
Keyword Property zad_DeviousLegCuffs Auto

;Idles
Idle Property DDZazHornyA Auto
Idle Property DDZazHornyD Auto
Idle Property DDZazHornyE Auto
;Idle Property DDZazHornyDClimax Auto

; All standard devices, at this time. Shorthand for mods, and to avoid the hassle of re-adding these as properties for other scripts.
; If you're using a custom device, you'll need to use EquipDevice, rather than the shorthand DoEquipDevice.
Armor Property beltPaddedRendered Auto         ; Internal Device
Armor Property beltPadded Auto        	       ; Inventory Device
Armor Property beltIronRendered Auto         ; Internal Device
Armor Property beltIron Auto        	     ; Inventory Device
Armor Property plugIronRendered Auto         ; Internal Device
Armor Property plugIron Auto        	     ; Inventory Device
Armor Property plugPrimitiveRendered Auto         ; Internal Device
Armor Property plugPrimitive Auto        	  ; Inventory Device
Armor Property plugInflatableRendered Auto         ; Internal Device
Armor Property plugInflatable Auto        	   ; Inventory Device
Armor Property plugSoulgemRendered Auto         ; Internal Device
Armor Property plugSoulgem Auto        		; Inventory Device
Armor Property braPaddedRendered Auto         ; Internal Device
Armor Property braPadded Auto        	      ; Inventory Device
Armor Property cuffsPaddedArmsRendered Auto         ; Internal Device
Armor Property cuffsPaddedArms Auto        	    ; Inventory Device
Armor Property cuffsPaddedLegsRendered Auto         ; Internal Device
Armor Property cuffsPaddedLegs Auto        	    ; Inventory Device
Armor Property cuffsPaddedCollarRendered Auto         ; Internal Device
Armor Property cuffsPaddedCollar Auto        	      ; Inventory Device
Armor Property cuffsPaddedCompleteRendered Auto         ; Internal Device
Armor Property cuffsPaddedComplete Auto        		; Inventory Device
Armor Property collarPostureRendered Auto         ; Internal Device
Armor Property collarPosture Auto        	  ; Inventory Device

; Sound fx
Sound Property VibrateVeryStrongSound Auto
Sound Property VibrateStrongSound Auto
Sound Property VibrateStandardSound Auto
Sound Property VibrateWeakSound Auto
Sound Property VibrateVeryWeakSound Auto
Sound Property EdgedSound Auto
Sound Property OrgasmSound  Auto
Sound Property MoanSound Auto

; Internal Variables
Armor Property deviceRemovalToken Auto         ; Internal token for removal events
Bool Property DeviceMutex Auto ; Prevent oddities when swapping sets of items quickly.
Bool Property VibratingMutex Auto ; Prevent double-playing vibration events
Bool Property TerminateVibrate Auto ; Immediately terminate ongoing vibration effect.
Int Property CurrentVibLength Auto ; Useful for stacking vibration effects.

; Misc
Actor Property PlayerRef Auto


;===============================================================================
; Public Interface Functions
;===============================================================================
; There are two items for each type of item in this system: An inventory item, and a rendered item.
; The inventory item is the user-facing item that the user may interact with. The rendered item is
; the item that actually shows up on characters. The reason for this two item system is twofold:
; Firstly, this permits us to allow the user to interact with the item freely, without seeing the
; item unequip every time / without resorting to spells/powers. Secondly, the rendered item acts
;  as an surrogate-state of sorts that is useful for internal scripts.
; Each category of item managed by this system must have a unique keyword. This keyword must be 
; present on the rendered device. For instance, all belts provided by devious devices contain the
; keyword zad_DeviousBelt. If you add custom belts, you must use either my existing keywords, or
; add your own keyword for a different type of device.

; Shorthand for non-custom devices.
Function ManipulateDevice(actor akActor, armor device, bool equipOrUnequip, bool skipEvents = false)
	; w2b table
	Armor deviceRendered
	Keyword deviceKeyword
	if device == beltPadded
		deviceRendered = beltPaddedRendered
		deviceKeyword = zad_DeviousBelt
	ElseIf device == beltIron
		deviceRendered = beltIronRendered
		deviceKeyword = zad_DeviousBelt
	ElseIf device == plugIron
		deviceRendered = plugIronRendered
		deviceKeyword = zad_DeviousPlug
	ElseIf device == plugPrimitive
		deviceRendered = plugPrimitiveRendered
		deviceKeyword = zad_DeviousPlug
	ElseIf device == plugInflatable
		deviceRendered = plugInflatableRendered
		deviceKeyword = zad_DeviousPlug
	ElseIf device == plugSoulgem
		deviceRendered = plugSoulgemRendered
		deviceKeyword = zad_DeviousPlug
	ElseIf device == braPadded
		deviceRendered = braPaddedRendered
		deviceKeyword = zad_DeviousBra
	ElseIf device == cuffsPaddedArms
		deviceRendered = cuffsPaddedArmsRendered
		deviceKeyword = zad_DeviousArmCuffs
	ElseIf device == cuffsPaddedLegs
		deviceRendered = cuffsPaddedLegsRendered
		deviceKeyword = zad_deviousLegCuffs
	ElseIf device == cuffsPaddedCollar
		deviceRendered = cuffsPaddedCollarRendered
		deviceKeyword = zad_deviousCollar
	ElseIf device == cuffsPaddedComplete
		deviceRendered = cuffsPaddedCompleteRendered
		deviceKeyword = zad_DeviousArmCuffs
	ElseIf device == collarPosture
		deviceRendered = collarPostureRendered
		deviceKeyword = zad_DeviousCollar
	Else
		Error("ManipulateDevice did not recognize device type that it received as an argument.")
		return
	EndIf
	if equipOrUnequip
		EquipDevice(akActor, device, deviceRendered, deviceKeyword, skipEvents = skipEvents)
	else
		RemoveDevice(akActor, device, deviceRendered, deviceKeyword, skipEvents = skipEvents)
	EndIf
EndFunction


; Equip device on actor.
;;; Function EquipDevice(actor akActor, ; The actor that this should operate on.
;;;                      armor deviceInventory ; The inventory device (See above explanation)
;;;                      armor deviceRendered ; The rendered device (See above explanation)
;;;                      keyword zad_DeviousDevice ; The keyword for this class of objects (See above explanation)
;;;                      bool skipEvents ; Skip onequipped event for this call. Useful for swapping items of the same type (Switching plugs, belts, collars, etc)
;;;                      bool skipMutex ; Internal use parameter only. Used for speedily recovering from remove-all, and similar effects. Don't use this.
;;;                      )
Function EquipDevice(actor akActor, armor deviceInventory, armor deviceRendered, keyword zad_DeviousDevice, bool skipEvents=false, bool skipMutex=false)
	if !skipMutex
		Log("EquipDevice called for " + deviceInventory.GetName())
		AcquireAndSpinlock()
		Log("Acquired mutex, equipping " + deviceInventory.GetName())
	else
		;Log("Not waiting for mutex. Proceed.")
	EndIf
	ReEquipExistingDevice(akActor, zad_DeviousDevice)
	if WearingConflictingDevice(akActor, deviceRendered, zad_DeviousDevice)
		Log("EquipDevice() called for one device, while already wearing another:" + zad_DeviousDevice)
		if !skipMutex
			DeviceMutex = false
		EndIf
		return
	EndIf
	if akActor.GetItemCount(deviceInventory) <=0
		akActor.AddItem(deviceInventory, 1, true)
	EndIf
	; skse version calls OnEquipped events. Fucking papyrus, lol.
	; Ugly design due to not realizing limitation of papyrus. Might refactor this later.
	if skipEvents
		akActor.EquipItem(deviceInventory, false, true)
		akActor.EquipItem(deviceRendered, false, true)
		if !skipMutex
			DeviceMutex = false
		EndIf
	else
		akActor.EquipItemEx(deviceInventory, 0, false, true)
	Endif
EndFunction




; Remove device from actor.
Function RemoveDevice(actor akActor, armor deviceInventory, armor deviceRendered, keyword zad_DeviousDevice, bool destroyDevice=false, bool skipEvents=false)
	Log("RemoveDevice called for " + deviceInventory.GetName())
	AcquireAndSpinlock()
	Log("Acquired mutex, removing " + deviceInventory.GetName())
	; Work around more native papyrus limitations by using skse functions.
	; This does present me with an easy way to swap devices without calling events though, if I want to use it. Neat.
	if skipEvents
		akActor.RemoveItem(deviceRendered, 1, true)
		akActor.UnequipItemEx(deviceInventory, 0, false)
	Else
		akActor.AddItem(deviceRemovalToken, 1, true)
		akActor.UnequipItemEx(deviceInventory, 0, false)
		akActor.RemoveItem(deviceRendered, 1, true) 
	Endif
        CleanupDevices(akActor, zad_DeviousDevice)
        if destroyDevice
		akActor.RemoveItem(deviceInventory, 1, true)
        EndIf
	; DeviceMutex is unlocked in zadEquipScript
EndFunction

; Returns 0 if the actor is not wearing a device of this type, 1 if she is wearing
; that specific device, or 2 if she's wearing another device of the same type.
int Function IsWearingDevice(actor akActor, armor deviceRendered, keyword zad_DeviousDevice)
	if akActor == none || deviceRendered == none || zad_DeviousDevice == none
		Error("IsWearingDevice received none argument.")
		return -1
	EndIf
	if akActor.WornHasKeyword(zad_DeviousDevice)
		if akActor.GetItemCount(deviceRendered)==0
			return 2
		Endif
		return 1
	EndIf
	return 0
EndFunction


; This function is for mod consistency mostly
int Function ArousalThreshold(string index)
    ; Want to buy dict
    if index=="Content"
        return 0
    Elseif index=="Desire"
        return 25
    Elseif index=="Horny"
        return 50
    Elseif index=="Desperate"
        return 75
    Else
        Error("Error: ArousalThreshold passed invalid lookup string ("+index+")!")
        return -1
    Endif
EndFunction













;===============================================================================
; Internal Functions
;===============================================================================
Function StoreExposureRate(actor akActor)
	; Hack to workaround broken lock faction functionality. If future changes to Sexlab Aroused's
	; code break this, will just add my own faction. The reason I'm not using a property variable to store this, is 
	; that such information can easily get lost (Belt Duping bug).
	int original = akActor.GetFactionRank(slaLockedArousal)
	if original <= 0 ; 0 is on, -2 is off by default
		int exposureRate = Aroused.GetActorExposureAccumulationRate(akActor)
		if exposureRate == 0
			Warn("Exposure rate was originally 0. Changing to default.")
			exposureRate = 30
		Endif
		akActor.SetFactionRank(slaLockedArousal, exposureRate)
	else
		Warn("StoreExposureRate called for actor " + akActor.GetLeveledActorBase().GetName() +", but actor already has this information stored.")
	Endif
EndFunction


int Function GetOriginalRate(actor akActor)
	int original = akActor.GetFactionRank(slaLockedArousal)	
	if original <= 0
		Debug.Trace("[zad] Warning: GetOriginalRate() returning default.")
		return 30
	Endif
	return original
EndFunction


int Function GetModifiedRate(actor akActor)
	if akActor.WornHasKeyword(zad_DeviousPlug)
		return ((GetOriginalRate(akActor) * GetPlugRateMult()) as int)
	Elseif akActor.WornHasKeyword(zad_DeviousBelt)
		return ((GetOriginalRate(akActor) * GetBeltRateMult()) as int)
	Else
		Warn("GetModifiedRate() returning original rate: Actor is not belted.")
		return GetOriginalRate(akActor)
	Endif
EndFunction

bool function CheckConfigInit()
	if Config == none 
		Error("Config is not initialized. User didn't update properly?")
		return false
	EndIf
	return true
EndFunction

float function GetPlugRateMult()
	if CheckConfigInit()
		return Config.PlugRateMult
	else
		Error("GetPlugRateMult returning -1")
		return -1
	EndIf
EndFunction

float function GetBeltRateMult()
	if CheckConfigInit()
		return Config.BeltRateMult
	else
		Error("GetBeltRateMult returning -1")
		return -1
	EndIf
EndFunction

int Function GetUnlockThreshold()
	if CheckConfigInit()
		return Config.UnlockThreshold
	else
		Error("GetUnlockThreshold returning -1")
		return -1
	EndIf

EndFunction


int Function CheckDeviceEscape(int skillThreshold, string skillName)
    ; Returns -1 on success. Otherwise, returns chance.
    int playerSkill = PlayerRef.GetAV(skillName) As Int
    int chance = Utility.RandomInt() + playerSkill
    if chance > (skillThreshold + Aroused.GetActorExposure(PlayerRef)/5)
        return -1
    Endif
    return chance
EndFunction


Function Notify(string out, bool messageBox=false)
	if messageBox
		Debug.MessageBox(out)
	else
		Debug.Notification(out)
	EndIf
EndFunction


Function NotifyNPC(string out, bool messageBox=false)
	if Config.NpcMessages
		Notify(out, messageBox)
	else
		Log("NpcMessages==false: "+out)
	EndIf
EndFunction


Function NotifyPlayer(string out, bool messageBox=false)
	if Config.PlayerMessages
		Notify(out, messageBox)
	else
		Log("PlayerMessages==false: " + out)
	EndIf
EndFunction


Function NotifyActor(string out, Actor akActor, bool messageBox=false)
	if akActor == PlayerRef
		NotifyPlayer(out, messageBox)
	else
		NotifyNPC(out, messageBox)
	EndIf
EndFunction


Function Log(string in, int level=0)
	if !Config.LogMessages
		return
	EndIf
	string out = "[Zad]"
	if level>=2
		Debug.Trace("============================================================")
		Debug.Trace(out + " (((ERROR))): " + in)
		Debug.Trace("============================================================")
		return
	elseif level==1
		out = out + " ((WARNING)): " + in
	elseif level==0
		out = out + ": " + in
	Endif
	Debug.Trace(out)
EndFunction

;
; Function CallFunction(string functionName, string eventName="CallFunction")
; 	; Janky workaround for papyrus ugliness. This isn't used anywhere performance critical.
; 	RegisterForModEvent(eventName, functionName)
; 	SendModEvent(eventName, functionName, 1)
; 	UnregisterForAllModEvents()
; EndFunction
;

Function Warn(string in)
	Log(in,1)
EndFunction


Function Error(string in)
	Log(in,2)
	Debug.MessageBox("An error has ocurred with your installation of Devious Devices. Please check the log for more information. Error Text: "+in)
EndFunction


Function CleanupDevices(actor akActor, keyword zad_DeviousDevice, Form skip1=None, Form skip2=None)
	if (skip1 != none && akActor.GetItemCount(skip1)==1) || (skip2 != none && akActor.GetItemCount(skip2)==1)
		return
	EndIf
	if akActor.GetItemCount(zad_DeviousDevice) >= 1
		Log("CleanupDevices() is working")
		int i = akActor.GetNumItems()
		while i > 0
			i -= 1
			Form f = akActor.GetNthForm(i)
			if f && f != skip1 && f != skip2 && f.HasKeyword(zad_DeviousDevice)
				akActor.RemoveItem(f, akActor.GetItemCount(f), true)
			EndIf
		EndWhile
	EndIf
EndFunction


Function ReEquipExistingDevice(actor akActor, keyword zad_DeviousDevice)
	int i = akActor.GetNumItems()
	if akActor.GetItemCount(zad_DeviousDevice)>0 && !akActor.WornHasKeyword(zad_DeviousDevice)
		Log("ReEquipExistingDevice() is working")
		while i > 0
			i -= 1
			Form f = akActor.GetNthForm(i)
			if f && f.HasKeyword(zad_DeviousDevice)
				akActor.EquipItem(f, false, true)
			EndIf
		EndWhile
	Endif
EndFunction


bool Function WearingConflictingDevice(actor akActor, armor deviceRendered, keyword zad_DeviousDevice)
	if akActor == none
		Error("WearingConflictingDevice received none argument.")
	EndIf
	if akActor.GetItemCount(deviceRendered)==0 && akActor.WornHasKeyword(zad_DeviousDevice)
		return true
	Endif
	return false
EndFunction


; Wrapper function for smaller arousal increments
Function UpdateExposure(actor akRef, float val, bool skipMultiplier=false)
	If (akRef == None)
		Error("UpdateExposure passed none reference.")
		return
	EndIf

	float lastRank = Aroused.GetActorExposure(akRef) as float
	if skipMultiplier
		Aroused.SetActorExposure(akRef, (lastRank + val) as Int)
	Else
		float lastRate = Aroused.GetActorExposureAccumulationRate(akRef) as float
		int newRank = (lastRank + (val as float) * lastRate / 10.0) as int	
		Aroused.SetActorExposure(akRef, newRank)
	EndIf
EndFunction


;====================
; Camera Manipulation
;====================
bool[] Function StartThirdPersonAnimation(actor akActor, idle animation)
	; Manipulate camera
	bool[] ret = new bool[2]
	if akActor.IsWeaponDrawn()
		Log("Weapons drawn.")
		ret[1] = true
		akActor.SheatheWeapon()
	EndIf
	int cameraOld = Game.GetCameraState()
	if cameraOld == 10 || akActor.IsOnMount(); 10 On a horse
		akActor.Dismount()
		game.ForceThirdPerson()
	ElseIf cameraOld == 11; Bleeding out.
		Warn("Actor is bleeding out. Hmm.")
		return ret
	ElseIf cameraOld == 12 ; Dragon? Wtf?
		Warn("Actor is dragon? Not sure what happened here.")
		return ret
	ElseIf cameraOld == 8 || cameraOld == 9	;;; 8 / 9 are third person.
		;
	Else
		ret[0] = true
		game.ForceThirdPerson()
	EndIf
	; Freeze player controls
	if akActor == PlayerRef
		Game.DisablePlayerControls()
	EndIf
	akActor.PlayIdle(animation)
	return ret
EndFunction


Function PlayThirdPersonAnimation(actor akActor, idle animation, int duration)
	Log("PlayThirdPersonAnimation()")
	bool[] cameraState=StartThirdPersonAnimation(akActor, animation)
	Utility.Wait(duration)
	EndThirdPersonAnimation(akActor, cameraState)
EndFunction


Function EndThirdPersonAnimation(actor akActor, bool[] cameraState)
	Debug.SendAnimationEvent(akActor, "IdleForceDefaultState")
	if akActor == PlayerRef
		Game.EnablePlayerControls()
		if cameraState[0]
			game.ForceFirstPerson()
		EndIf
	EndIf
	if cameraState[1]
		akActor.SheatheWeapon()
		;akActor.DrawWeapon()
	EndIf
EndFunction


;;;
Function AcquireAndSpinlock()
	if DeviceMutex
		log("SpinLock() Started.")
		int timeout = 0
		while DeviceMutex
			Utility.Wait(0.1)
			if timeout >= 150
				Warn("SpinLock() timed out.")
				deviceMutex = false
			EndIf
			timeout += 1
		EndWhile
		log("SpinLock() Completed. Cycles:" + timeout)
	EndIf
	DeviceMutex = true ; Immediately reacquire lock
EndFunction


Function SendDeviceEvent(string eventName, string actorName, int isPlayer)
	Log("Sending device event "+eventName+"("+actorName+":"+isPlayer+")")
	SendModEvent(eventName, actorName, isPlayer)
EndFunction


;==================================================
; Effects
;==================================================
Function ActorOrgasm(actor akActor, int setArousalTo=-1)
	if setArousalTo < 0
		setArousalTo = Utility.RandomInt(0, 75)
	EndIf
	Game.ShakeCamera(akActor, 1, 5)
	int sID = OrgasmSound.Play(akActor)
	Sound.SetInstanceVolume(sid, Config.VolumeOrgasm)
	; vol adjust?
	Aroused.SetActorExposure(akActor, setArousalTo)
	PlayThirdPersonAnimation(akActor, DDZazHornyE, 25)
EndFunction


;;; wrapper for Sexlab Aroused integrated moan.
Function Moan(actor akActor, int arousal=-1, sslBaseVoice voice = none)
	if !voice
		voice = SexLab.PickVoice(akActor)
	EndIf
	if arousal == -1
		arousal = Aroused.GetActorExposure(akActor)
	EndIf
	if arousal >= ArousalThreshold("Desperate")
		voice.PlayHot(akActor)
	elseif arousal >= ArousalThreshold("Horny")
		voice.PlayMedium(akActor)
	else ;elseif arousal >= ArousalThreshold("Desire")
		voice.PlayMild(akActor)
	EndIf
EndFunction


Function PlaySceneAndWait(Scene toPlay, bool forceStart=false, int timeout=120, int increment=5)
	if forceStart
		toPlay.ForceStart()
	else
		toPlay.Start()
	EndIf
	int i = 0
	while toPlay.IsPlaying() && i < timeout
		i += increment
		Utility.Wait(increment)
	EndWhile
	if i >= timeout
		Warn("Scene timed out!")
	EndIf
EndFunction


Function EdgeActor(actor akActor)
	SendModEvent("DeviceEdgedActor", akActor.GetLeveledActorBase().GetName())
	int sID = EdgedSound.Play(akActor)
	Sound.SetInstanceVolume(sid, Config.VolumeEdged)
	if akActor == PlayerRef
		Game.ShakeCamera(akActor, 0.5, 3)
	EndIf
	PlayThirdPersonAnimation(akActor, DDZazHornyD, 15)
EndFunction


float Function GetMoanVolume(actor akActor, int exposure = -1)
	if exposure == -1
		exposure = Aroused.GetActorExposure(akActor)
	EndIf
	return (0.25 + (exposure * 0.005) as Int)
EndFunction


;;; Returns number of times actor came from this effect, -1 if it edged them, or -2 if an event was already ongoing.
; This function has suffered from feature creep pretty hard since it's inception, and is in need of refactoring. Still works, but very messy.
; Will split this up to a small library in the future.
int Function VibrateEffect(actor akActor, int vibStrength, int duration, bool teaseOnly=false, bool skipMutex = false, bool silent = false)
	If duration == 0
		duration = Utility.RandomInt(5,20)
	EndIf
	if !skipMutex
		CurrentVibLength += duration
		if VibratingMutex
			Log("VibrateMutex already set. Extending duration of existing event.")
			return -2
		EndIf
		VibratingMutex = true
	Endif
	int actorCame = 0
	Log("VibrateEffect("+vibStrength +" for "+duration+")")
	sound vibSoundSelect

	string msg = ""
	if vibStrength == 5
		msg = "The plugs within you begin to vibrate extremely powerfully!"
		vibSoundSelect = VibrateVeryStrongSound
	elseIf vibStrength == 4
		msg = "The plugs within you begin to vibrate strongly!"
		vibSoundSelect = VibrateStrongSound
	elseIf vibStrength == 3
		msg = "The plugs within you begin to vibrate!"
		vibSoundSelect = VibrateStandardSound
	elseIf vibStrength == 2
		msg = "The plugs within you begin to vibrate softly."
		vibSoundSelect = VibrateWeakSound
	elseIf vibStrength == 1
		msg = "The plugs within you begin to vibrate agonizingly softly."
		vibSoundSelect = VibrateVeryWeakSound
	else
		Error("Vibrator received invalid strength setting.")
		return -2
	EndIf
	if !silent
		NotifyPlayer(msg)
	Endif

	int vsID = vibSoundSelect.Play(PlayerRef)
	Sound.SetInstanceVolume(vsID, Config.VolumeVibrator)
	int msID = MoanSound.Play(PlayerRef)
	Sound.SetInstanceVolume(msID, GetMoanVolume(akActor))
	int timeVibrated = 0
	int vibAnimStarted = 0
	bool[] cameraState

	if Config.HardcoreEffects && Utility.RandomInt() <= (10*vibStrength)
		PlayThirdPersonAnimation(akActor, DDZazHornyA, 3)
	EndIf

	While ((timeVibrated < CurrentVibLength) || ((timeVibrated < duration) && skipMutex)) && !TerminateVibrate
		float combatModifier = 1
		if (akActor.GetCombatState() != 0)
			combatModifier = 0.5
		EndIf
		;;;;;;;;;;
		; Let the actor cum?
		;;;;;;;;;;
		if vibStrength >= 3 && aroused.GetActorExposure(akActor)>= 99
			int cumChance = (vibStrength * 2 * combatModifier) as Int
			Log("CumChance:"+cumChance+", vibStrength:"+vibStrength)
			if Utility.RandomInt() <= cumChance
				;;;;;;;;;;
				; Kill previous animation, if any.
				;;;;;;;;;;
				if vibAnimStarted != 0
					EndThirdPersonAnimation(akActor, cameraState)
					vibAnimStarted = 0
				EndIf
				actorCame += 1
				if teaseOnly
					Sound.StopInstance(vsID)
					Sound.StopInstance(msID)
					if !skipMutex
						CurrentVibLength = 0
						VibratingMutex = false
					Endif
					if !silent
						NotifyPlayer("The vibrations abruptly stop just short of bringing you to orgasm.")
						EdgeActor(akActor)
					Endif
					return -1
				EndIf
				if !silent
					NotifyPlayer("The plugs bring you to a thunderous climax.")
				EndIf
				ActorOrgasm(akActor)
			EndIf
		EndIf
		;;;;;;;;;;
		; Increase arousal, moan sound.
		;;;;;;;;;;
		if (timeVibrated % (6-vibStrength)) == 0
			UpdateExposure(akActor, 5 * combatModifier, skipMultiplier=true)
			Sound.SetInstanceVolume(msID, GetMoanVolume(akActor))
		EndIf
		;;;;;;;;;;
		; Play horny idle?
		;;;;;;;;;;
		if (Config.HardcoreEffects) && (vibAnimStarted == 0) && Utility.RandomInt() <= (3+(VibStrength * 2))
			cameraState=StartThirdPersonAnimation(akActor, DDZazHornyA)
			vibAnimStarted = timeVibrated + 1
		EndIf
		;;;;;;;;;;
		; Stop horny idle?
		;;;;;;;;;;
		if (vibAnimStarted != 0) && (timeVibrated - vibAnimStarted >= 6) ; Stop animation after 5 seconds.
			EndThirdPersonAnimation(akActor, cameraState)
			vibAnimStarted = 0
		EndIf
		;;;;;;;;;;
		; Shake camera effect.
		;;;;;;;;;;
		if akActor == PlayerRef
			Game.ShakeCamera(akActor, (0.05*vibStrength), 1)
		EndIf
		Utility.Wait(1)
		timeVibrated += 1
	EndWhile
	if TerminateVibrate
		TerminateVibrate = false
	EndIf
	;PlayerRef.ClearExpressionOverride()
	Sound.StopInstance(vsID)
	Sound.StopInstance(msID)
	;;;;;;;;;;
	; Make sure player isn't stuck in animation
	;;;;;;;;;;
	if  vibAnimStarted != 0
		EndThirdPersonAnimation(akActor, cameraState)
		vibAnimStarted = 0
	EndIf
	if !skipMutex
		CurrentVibLength = 0
		VibratingMutex = false
	Endif
	if !silent
		if Aroused.GetActorExposure(akActor) >= ArousalThreshold("Desperate")
			NotifyPlayer("Your pussy clenches around the plugs as they abruptly cease vibrating.")
		else
			NotifyPlayer("The plugs cease vibrating.")
		Endif
	Endif
	return actorCame
EndFunction


Function AttrDrain(actor akActor, string attr)
	float randomize = (Utility.RandomInt(1,75) as Float) / 100
	int drain = (akActor.GetAv(attr) * randomize) as Int
	Log(attr+"DrainEffect(): Draining "+drain + "("+randomize+" %)")
	akActor.DamageAv(attr, drain)
EndFunction


Function HealthDrainEffect(actor akActor)
	AttrDrain(akActor, "Health")
EndFunction


Function ManaDrainEffect(actor akActor)
	AttrDrain(akActor, "Magicka")
EndFunction


Function StaminaDrainEffect(actor akActor)
	AttrDrain(akActor, "Stamina")
EndFunction
