Scriptname zadConfig extends SKI_ConfigBase  

; The power of Emacs compels you.

; Libraries
zadLibs Property libs Auto
zadBeltedAnims Property beltedAnims  Auto  

; Perks
Perk Property zad_keyCraftingEasy Auto
Perk Property zad_keyCraftingHard Auto

; Config Variables
int Property UnlockThreshold Auto
int thresholdDefault = 185
float Property BeltRateMult Auto
float beltRateDefault = 1.5
float Property PlugRateMult Auto
float plugRateDefault = 3.0
int Property KeyCrafting Auto
int keyCraftingDefault = 1
bool Property NpcMessages Auto
bool npcMessagesDefault = true
bool Property PlayerMessages Auto
bool playerMessagesDefault = true
bool Property DestroyKey Auto
bool destroyKeyDefault = false
bool Property SkyRe Auto
bool skyreDefault = true
bool Property LogMessages Auto
bool logMessagesDefault = true

; Events and Effects
float Property EventInterval Auto
float eventIntervalDefault = 1.5
int Property EffectVibrateChance Auto
int effectVibrateChanceDefault = 25
int Property EffectHealthDrainChance Auto
int effectHealthDrainChanceDefault = 50
int Property EffectManaDrainChance Auto
int EffectManaDrainChanceDefault = 50
int Property EffectStaminaDrainChance Auto
int EffectStaminaDrainChanceDefault = 50
int Property BaseMessageChance Auto
int baseMessageChanceDefault = 10
int Property BaseHornyChance Auto
int baseHornyChanceDefault = 5
int Property BaseBumpPumpChance Auto
int baseBumpPumpChanceDefault = 17
bool Property HardcoreEffects Auto
bool hardcoreEffectsDefault = true

; Sounds
float Property VolumeOrgasm Auto
float volumeOrgasmDefault = 1.0
float Property VolumeEdged Auto
float volumeEdgedDefault = 1.0
float Property VolumeVibrator Auto
float volumeVibratorDefault = 1.0

; Quest Monitor Configuration
bool Property ForbiddenTome Auto
bool ForbiddenTomeDefault = true
bool Property SurreptitiousStreets Auto
bool SurreptitiousStreetsDefault = true
bool Property RadiantMaster Auto
bool RadiantMasterDefault = true

; Surreptitious Streets Config
int Property ssSleepChance Auto
int ssSleepChanceDefault = 100
int Property ssTrapChance Auto
int ssTrapChanceDefault = 100

; Radiant Master Configuration
float Property rmHeartbeatInterval Auto
float rmHeartbeatIntervalDefault = 2.0
float Property rmSummonHeartbeatInterval Auto
float rmSummonHeartbeatIntervalDefault = 0.25

; OID's
int thresholdOID
int beltRateOID
int plugRateOID
int keyCraftingOID
int animsRegisterOID
int playerMessagesOID
int npcMessagesOID
int destroyKeyOID
int skyreOID
int logMessagesOID
int eventIntervalOID
int effectVibrateChanceOID
int effectHealthDrainChanceOID
int effectManaDrainChanceOID
int effectStaminaDrainChanceOID
int baseMessageChanceOID
int baseHornyChanceOID
int baseBumpPumpChanceOID
int VolumeOrgasmOID
int VolumeEdgedOID
int VolumeVibratorOID
int ForbiddenTomeOID
int SurreptitiousStreetsOID
int RadiantMasterOID
int HardcoreEffectsOID
int ssSleepChanceOID
int ssTrapChanceOID
int rmHeartbeatIntervalOID
int rmSummonHeartbeatIntervalOID

string[] difficultyList

Function SetupDifficulties()
	difficultyList = new String[3]
	difficultyList[0] = "Easy"
	difficultyList[1] = "Hard"
	difficultyList[2] = "Disabled"
EndFunction

Function SetupPages()
	Pages = new string[5]
	Pages[0] = "General"
	Pages[1] = "Belt"
	Pages[2] = "Events and Effects"
	Pages[3] = "Sounds"
	Pages[4] = "Quests"
EndFunction


Event OnConfigInit()
	libs.Log("Building mcm menu.")
	SetupPages()
	SetupDifficulties()
EndEvent

int Function GetVersion()
	return 5 ; mcm menu version
EndFunction

Event OnVersionUpdate(int newVersion)
	libs.Log("OnVersionUpdate("+newVersion+"/"+CurrentVersion+")")
	if newVersion != CurrentVersion
		SetupPages()
		SetupDifficulties()
		if KeyCrafting == keyCraftingDefault && !libs.PlayerRef.HasPerk(zad_keyCraftingEasy) && !libs.PlayerRef.HasPerk(zad_keyCraftingHard)
			libs.PlayerRef.AddPerk(zad_keyCraftingHard)
		EndIf
	EndIf
EndEvent

Event OnPageReset(string page)
	Libs.Log("OnPageReset("+page+")")
	if (page == "")
		LoadCustomContent("DeviousIntegrationTitle.dds", 186, 33)
		return
	else
		UnloadCustomContent()
	EndIf
	If page == "General"
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0) ; Can be removed because it starts at 0 anyway
		if libs.PlayerRef.WornHasKeyword(libs.zad_DeviousBelt)
			AddHeaderOption("Device Escape Options are unavailable")
			AddHeaderOption(" while wearing a belt.")
		else
			AddHeaderOption("Device Escape Options")
			thresholdOID = AddSliderOption("Unlock Threshold", UnlockThreshold)
			keyCraftingOID = AddMenuOption("Key Creation Difficulty", difficultyList[KeyCrafting])
			destroyKeyOID = AddToggleOption("Destroy Key", DestroyKey)
			skyreOID = AddToggleOption("Using SkyRe", SkyRe)
		EndIf
		AddHeaderOption("Message Visibility Settings")
		npcMessagesOID = AddToggleOption("Show NPC Messages", NpcMessages)
		playerMessagesOID = AddToggleOption("Show Player Messages", PlayerMessages)
		AddHeaderOption("Device Animation Options")
		animsRegisterOID = AddTextOption("Reregister Animations", "Not Done")
		AddHeaderOption("Debug")
		logMessagesOID = AddToggleOption("Enable Debug Logging", LogMessages)
	ElseIf page == "Belt"
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0) ; Can be removed because it starts at 0 anyway
		AddHeaderOption("Belt Arousal Options")
		beltRateOID = AddSliderOption("Arousal rate belt multiplier", beltRateMult, "{1}")
		plugRateOID = AddSliderOption("Arousal rate plugged multiplier", plugRateMult, "{1}")
	ElseIf page == "Events and Effects"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("Global Events/Effects Configuration")
		eventIntervalOID = AddSliderOption("Polling Interval", EventInterval, "{2}")
		HardcoreEffectsOID = AddToggleOption("Enable Hardcore Effects", HardcoreEffects)
		AddHeaderOption("Polled Events Configuration")
		baseMessageChanceOID = AddSliderOption("Base Message Event Chance", BaseMessageChance, "{1}")
		baseHornyChanceOID = AddSliderOption("Base Horny-Animation Event Chance", BaseHornyChance, "{1}")
		baseBumpPumpChanceOID = AddSliderOption("Base Bump-Pumps Event Chance", BaseBumpPumpChance, "{1}")
		AddHeaderOption("Polled Effects Configuration")
		effectVibrateChanceOID = AddSliderOption("Vibration Chance", EffectVibrateChance, "{1}")
		effectHealthDrainChanceOID = AddSliderOption("Health Drain Chance", EffectHealthDrainChance, "{1}")
		effectManaDrainChanceOID = AddSliderOption("Mana Drain Chance", EffectManaDrainChance, "{1}")
		effectStaminaDrainChanceOID = AddSliderOption("Stamina Drain Chance", EffectStaminaDrainChance, "{1}")
	ElseIf page == "Sounds"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("Audio Configuration")
		VolumeOrgasmOID = AddSliderOption("Orgasm Volume", VolumeOrgasm, "{3}")
		VolumeEdgedOID = AddSliderOption("Edged Volume", VolumeEdged, "{3}")
		VolumeVibratorOID = AddSliderOption("Vibrator Volume ", VolumeVibrator, "{3}")
	ElseIf page == "Quests"
		SetCursorFillMode(TOP_TO_BOTTOM)
		AddHeaderOption("Quest Toggles for QuestMonitor")
		ForbiddenTomeOID = AddToggleOption("Forbidden Tome", ForbiddenTome)
		; SurreptitiousStreetsOID = AddToggleOption("Surreptitious Streets", SurreptitiousStreets)
		; RadiantMasterOID = AddToggleOption("Radiant Master", RadiantMaster)
		; AddHeaderOption("Surreptitious Streets Configuration")
		; ssSleepChanceOID = AddSliderOption("Sleep Capture Chance", ssSleepChance, "{1}")
		; ssTrapChanceOID = AddSliderOption("Trap Spawn Chance", ssTrapChance, "{1}")
		; AddHeaderOption("Radiant Master Configuration")
		; rmHeartbeatIntervalOID = AddSliderOption("Heartbeat Interval", rmHeartbeatInterval, "{3}")
		; rmSummonHeartbeatIntervalOID = AddSliderOption("Summon Heartbeat Interval", rmSummonHeartbeatInterval, "{3}")
	Endif
EndEvent


Event OnOptionMenuOpen(int option)
	if option == keyCraftingOID
		SetMenuDialogOptions(difficultyList)
		SetMenuDialogStartIndex(KeyCrafting)
		SetMenuDialogDefaultIndex(keyCraftingDefault)
	EndIf
EndEvent

Function CheckRemovePerk(Perk perkName)
	if libs.PlayerRef.HasPerk(perkName)
		libs.PlayerRef.RemovePerk(perkName)
	EndIf	
EndFunction

Function UpdateCraftingPerks(int index)
	if index == 0
		CheckRemovePerk(zad_keyCraftingHard)
		libs.PlayerRef.AddPerk(zad_keyCraftingEasy)
	elseif index == 1
		CheckRemovePerk(zad_keyCraftingEasy)
		libs.PlayerRef.AddPerk(zad_keyCraftingHard)
	Else
		CheckRemovePerk(zad_keyCraftingEasy)
		CheckRemovePerk(zad_keyCraftingHard)
	EndIf
EndFunction

Event OnOptionMenuAccept(int option, int index)
	if option == keyCraftingOID
		UpdateCraftingPerks(index)
		KeyCrafting = index
		SetMenuOptionValue(keyCraftingOID, difficultyList[KeyCrafting])
	EndIf
EndEvent

Event OnOptionSliderOpen(int option)
	;Libs.Log("OnOptionSliderOpen("+option+")")
	if option == thresholdOID
		SetSliderDialogStartValue(UnlockThreshold)
		SetSliderDialogDefaultValue(thresholdDefault)
		SetSliderDialogRange(1,350)
		SetSliderDialogInterval(1)
	elseif option == beltRateOID
		SetSliderDialogStartValue(BeltRateMult)
		SetSliderDialogDefaultValue(beltRateDefault)
		SetSliderDialogRange(1,5)
		SetSliderDialogInterval(0.1)	
	elseif option == plugRateOID
		SetSliderDialogStartValue(PlugRateMult)
		SetSliderDialogDefaultValue(plugRateDefault)
		SetSliderDialogRange(1,5)
		SetSliderDialogInterval(0.1)
	elseif option == eventIntervalOID
		SetSliderDialogStartValue(EventInterval)
		SetSliderDialogDefaultValue(eventIntervalDefault)
		SetSliderDialogRange(0.5, 12)
		SetSliderDialogInterval(0.05)
	elseIf option == effectVibrateChanceOID
		SetSliderDialogStartValue(EffectVibrateChance)
		SetSliderDialogDefaultValue(effectVibrateChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == effectHealthDrainChanceOID
		SetSliderDialogStartValue(EffectHealthDrainChance)
		SetSliderDialogDefaultValue(effectHealthDrainChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == effectManaDrainChanceOID
		SetSliderDialogStartValue(EffectManaDrainChance)
		SetSliderDialogDefaultValue(effectManaDrainChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == effectStaminaDrainChanceOID
		SetSliderDialogStartValue(EffectStaminaDrainChance)
		SetSliderDialogDefaultValue(effectStaminaDrainChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == baseMessageChanceOID
		SetSliderDialogStartValue(BaseMessageChance)
		SetSliderDialogDefaultValue(baseMessageChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == baseHornyChanceOID
		SetSliderDialogStartValue(BaseHornyChance)
		SetSliderDialogDefaultValue(baseHornyChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == baseBumpPumpChanceOID
		SetSliderDialogStartValue(BaseBumpPumpChance)
		SetSliderDialogDefaultValue(baseBumpPumpChanceDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
	elseIf option == VolumeOrgasmOID
		SetSliderDialogStartValue(VolumeOrgasm)
		SetSliderDialogDefaultValue(VolumeOrgasmDefault)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)
	elseIf option == VolumeEdgedOID
		SetSliderDialogStartValue(VolumeEdged)
		SetSliderDialogDefaultValue(VolumeEdgedDefault)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)
	elseIf option == VolumeVibratorOID
		SetSliderDialogStartValue(VolumeVibrator)
		SetSliderDialogDefaultValue(VolumeVibratorDefault)
		SetSliderDialogRange(0, 1)
		SetSliderDialogInterval(0.01)
	elseIf option == ssSleepChanceOID
		SetSliderDialogStartValue(ssSleepChance)
		SetSliderDialogDefaultValue(ssSleepChanceDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
	elseIf option == ssTrapChanceOID
		SetSliderDialogStartValue(ssTrapChance)
		SetSliderDialogDefaultValue(ssTrapChanceDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
	elseIf option == rmHeartbeatIntervalOID
		SetSliderDialogStartValue(rmHeartbeatInterval)
		SetSliderDialogDefaultValue(rmHeartbeatIntervalDefault)
		SetSliderDialogRange(0.5, 24)
		SetSliderDialogInterval(0.01)
	elseIf option == rmSummonHeartbeatIntervalOID
		SetSliderDialogStartValue(rmSummonHeartbeatInterval)
		SetSliderDialogDefaultValue(rmSummonHeartbeatIntervalDefault)
		SetSliderDialogRange(0.125, 12)
		SetSliderDialogInterval(0.01)
	Endif
EndEvent

Event OnOptionSelect(int option)
	;Libs.Log("OnOptionSelect("+option+")")	
	if option == animsRegisterOID
		beltedAnims.LoadAnimations()
		SetTextOptionValue(animsRegisterOID, "Done.")
	elseif option == npcMessagesOID
		NpcMessages = !NpcMessages
		SetToggleOptionValue(npcMessagesOID, NpcMessages)
	elseif option == playerMessagesOID
		PlayerMessages = !PlayerMessages
		SetToggleOptionValue(playerMessagesOID, PlayerMessages)
	elseif option == destroyKeyOID
		DestroyKey = !DestroyKey
		SetToggleOptionValue(destroyKeyOID, DestroyKey)
	elseif option == skyreOID
		SkyRe = !SkyRe
		SetToggleOptionValue(skyreOID, SkyRe)
	elseif option == logMessagesOID
		 LogMessages = !LogMessages
		SetToggleOptionValue(logMessagesOID, LogMessages)
	elseif option == HardcoreEffectsOID
		 HardcoreEffects = !HardcoreEffects
		SetToggleOptionValue(HardcoreEffectsOID, HardcoreEffects)
	elseif option == ForbiddenTomeOID
		 ForbiddenTome = !ForbiddenTome
		SetToggleOptionValue(ForbiddenTomeOID, ForbiddenTome)
	elseif option == SurreptitiousStreetsOID
		 SurreptitiousStreets = !SurreptitiousStreets
		SetToggleOptionValue(SurreptitiousStreetsOID, SurreptitiousStreets)
	elseif option == RadiantMaster
		 RadiantMaster = !RadiantMaster
		SetToggleOptionValue(RadiantMasterOID, RadiantMaster)
	EndIf
EndEvent

Event OnOptionDefault(int option)
	;Libs.Log("OnOptionDefault("+option+")")	
	if (option == thresholdOID)
		UnlockThreshold = thresholdDefault
		SetSliderOptionValue(thresholdOID, thresholdDefault, "{0}")
	elseIf (option == beltRateOID)
		BeltRateMult = beltRateDefault
		SetSliderOptionValue(beltRateOID, beltRateDefault, "{1}")
	elseIf (option == plugRateOID)
		PlugRateMult = plugRateDefault
		SetSliderOptionValue(plugRateOID, plugRateDefault, "{1}")
	elseIf (option == keyCraftingOID)
		UpdateCraftingPerks(keyCraftingDefault)
		KeyCrafting = keyCraftingDefault
		SetMenuOptionValue(keyCraftingOID, difficultyList[KeyCrafting])
	elseIf (option == npcMessagesOID)
		NpcMessages = npcMessagesDefault
		SetToggleOptionValue(npcMessagesOID, npcMessagesDefault)
	elseIf (option == playerMessagesOID)
		PlayerMessages = playerMessagesDefault
		SetToggleOptionValue(playerMessagesOID, playerMessagesDefault)
	elseIf (option == destroyKeyOID)
		DestroyKey = destroyKeyDefault
		SetToggleOptionValue(destroyKeyOID, destroyKeyDefault)
	elseIf (option == skyreOID)
		SkyRe = skyreDefault
		SetToggleOptionValue(skyreOID, skyreDefault)
	elseIf (option == logMessagesOID)
		LogMessages = logMessagesOID
		SetToggleOptionValue(logMessagesOID, LogMessages)
	elseIf (option == eventIntervalOID)
		EventInterval = eventIntervalDefault
		SetToggleOptionValue(eventIntervalOID, eventIntervalDefault)
	elseIf (option == effectVibrateChanceOID)
		EffectVibrateChance = effectVibrateChanceDefault
		SetSliderOptionValue(effectVibrateChanceOID, effectVibrateChanceDefault, "{1}")
	elseIf (option == effectHealthDrainChanceOID)
		EffectHealthDrainChance = effectHealthDrainChanceDefault
		SetSliderOptionValue(effectHealthDrainChanceOID, effectHealthDrainChanceDefault, "{1}")
	elseIf (option == effectManaDrainChanceOID)
		EffectManaDrainChance = effectManaDrainChanceDefault
		SetSliderOptionValue(effectManaDrainChanceOID, effectManaDrainChanceDefault, "{1}")
	elseIf (option == effectStaminaDrainChanceOID)
		EffectStaminaDrainChance = effectStaminaDrainChanceDefault
		SetSliderOptionValue(effectStaminaDrainChanceOID, effectStaminaDrainChanceDefault, "{1}")
	elseIf (option == baseMessageChanceOID)
		BaseMessageChance = baseMessageChanceDefault
		SetSliderOptionValue(baseMessageChanceOID, baseMessageChanceDefault, "{1}")
	elseIf (option == baseHornyChanceOID)
		BaseHornyChance = baseHornyChanceDefault
		SetSliderOptionValue(baseHornyChanceOID, baseHornyChanceDefault, "{1}")
	elseIf (option == baseBumpPumpChanceOID)
		BaseBumpPumpChance = BaseBumpPumpChanceDefault
		SetSliderOptionValue(baseBumpPumpChanceOID, BaseBumpPumpChanceDefault, "{1}")
	elseIf (option == VolumeOrgasmOID)
		VolumeOrgasm = VolumeOrgasmDefault
		SetSliderOptionValue(VolumeOrgasmOID, VolumeOrgasmDefault, "{3}")
	elseIf (option == VolumeEdgedOID)
		VolumeEdged = VolumeEdgedDefault
		SetSliderOptionValue(VolumeEdgedOID, VolumeEdgedDefault, "{3}")
	elseIf (option == VolumeVibrator)
		VolumeVibrator = VolumeVibratorDefault
		SetSliderOptionValue(VolumeVibratorOID, VolumeVibratorDefault, "{3}")
	elseif option == ForbiddenTomeOID
		ForbiddenTome = ForbiddenTomeDefault
		SetToggleOptionValue(ForbiddenTomeOID, ForbiddenTome)
	elseif option == SurreptitiousStreetsOID
		SurreptitiousStreets = SurreptitiousStreetsDefault
		SetToggleOptionValue(SurreptitiousStreetsOID, SurreptitiousStreets)
	elseif option == RadiantMasterOID
		RadiantMaster = RadiantMasterDefault
		SetToggleOptionValue(RadiantMasterOID, RadiantMaster)
	elseIf (option == HardcoreEffectsOID)
		HardcoreEffects = HardcoreEffectsDefault
		SetToggleOptionValue(HardcoreEffectsOID, HardcoreEffectsDefault)
	elseIf (option == ssSleepChanceOID)
		ssSleepChance = ssSleepChanceDefault
		SetSliderOptionValue(ssSleepChanceOID, ssSleepChanceDefault, "{1}")
	elseIf (option == ssTrapChanceOID)
		ssTrapChanceDefault = ssTrapChanceDefault
		SetSliderOptionValue(ssTrapChanceOID, ssTrapChanceDefault, "{1}")
	elseIf (option == rmHeartbeatIntervalOID)
		rmHeartbeatInterval = rmHeartbeatIntervalDefault
		SetSliderOptionValue(rmHeartbeatIntervalOID, rmHeartbeatIntervalDefault, "{3}")
	elseIf (option == rmSummonHeartbeatIntervalOID)
		rmSummonHeartbeatInterval = rmSummonHeartbeatIntervalDefault
		SetSliderOptionValue(rmSummonHeartbeatIntervalOID, rmSummonHeartbeatIntervalDefault, "{3}")
	endIf
EndEvent

Event OnOptionHighlight(int option)
	;Libs.Log("OnOptionHighlight("+option+")")			
	if (option == thresholdOID)
		SetInfoText("Base escape difficulty threshold. Higher is harder, lower is easier.\nDefault: "+thresholdDefault)
	elseIf (option == beltRateOID)
		SetInfoText("Arousal exposure multiplier while belted.\nDefault: "+beltRateDefault)
	elseIf (option == plugRateOID)
		SetInfoText("Arousal exposure multiplier while belted/plugged.\nDefault: "+plugRateDefault)
	elseIf (option == keyCraftingOID)
		SetInfoText("Key crafting difficulty.\nEasy: 1 iron ingot.Hard: 1 ebony ingot + 1 flawless diamond.")
	elseIf (option == animsRegisterOID)
		SetInfoText("Reregister animations provided by this mod.")
	elseIf (option == npcMessagesOID)
		SetInfoText("Enable/disable device related messages for NPC's.\nDefault:"+npcMessagesDefault)
	elseIf (option == playerMessagesOID)
		SetInfoText("Enable/disable device related messages for the player. Note: Messages crucial to device functionality (Such as the menu) will display regardless of this setting. The creator of this mod recommends that you leave this option enabled, unless you really loathe his writing.\nDefault:"+playerMessagesDefault+".")
	elseIf (option == destroyKeyOID)
		SetInfoText("Enable/disable consuming the key upon device removal.\nDefault:"+destroyKeyDefault)
	elseIf (option == skyreOID)
		SetInfoText("Enable/disable SkyRe support. If enabled, this option will use the player's Pickpocket skill instead of their lockpick skill for escape attempts (Lockpick is Wayfaring in SkyRe, and Pickpocket is Fingersmithing).\nDefault:"+skyreDefault)
	elseIf (option == logMessagesOID)
		SetInfoText("Toggles display of debug messages in Papyrus.0.log. You can disable this if everything is working correctly.")
	elseIf (option == eventIntervalOID)
		SetInfoText("Configure how frequently device events are polled, measured in game hours. The lower this is, the more frequent all periodic events / effects are.\nDefault: " + eventIntervalDefault)
	elseIf (option == effectVibrateChanceOID)
		SetInfoText("Controls the probability of a Vibration effect being started via event polling.\nDefault:"+EffectVibrateChanceDefault)
	elseIf (option == effectHealthDrainChanceOID)
		SetInfoText("Controls the probability of a Health Drain effect being started via event polling.\nDefault:"+EffectHealthDrainChanceDefault)
	elseIf (option == effectManaDrainChanceOID)
		SetInfoText("Controls the probability of a Mana Drain effect being started via event polling.\nDefault:"+EffectManaDrainChanceDefault)
	elseIf (option == effectStaminaDrainChanceOID)
		SetInfoText("Controls the probability of a Stamina effect being started via event polling.\nDefault:"+effectStaminaDrainChanceDefault)
	elseIf (option == baseMessageChanceOID)
		SetInfoText("Controls the base probability of a Message Event being started via event polling. This chance will vary for some messages: This is merely the base chance.\nDefault:"+baseMessageChanceDefault)
	elseIf (option == baseHornyChanceOID)
		SetInfoText("Controls the base probability of a Horny-Animation Event being started via event polling. The chance for this event is highly influenced / increased by player arousal.\nDefault:"+baseHornyChanceDefault)
	elseIf (option == baseBumpPumpChanceOID)
		SetInfoText("Controls the base probability of a Bump-Pump Event being started via event polling, or via sitting/jumping. The chance for this event varies depending on what caused it.\nDefault:"+baseBumpPumpChanceDefault)
	elseIf (option == VolumeOrgasmOID)
		SetInfoText("Controls the volume of an an actor's moans during an orgasm.\nDefault:" + volumeOrgasmDefault)
	elseIf (option == VolumeEdgedOID)
		SetInfoText("Controls the volume of an actor's moans after being edged.\nDefault:" + volumeEdgedDefault)
	elseIf (option == VolumeVibrator)
		SetInfoText("Controls the volume of a vibrator. Note, that the stronger vibrators are inherently louder than the weaker ones. If you set this too low, you may not be able to hear the weaker ones.\nDefault:" + volumeVibratorDefault)
	elseIf (option == ForbiddenTomeOID)
		SetInfoText("Enable/disable the triggers to start the Forbidden Tome quest. Hint: This quest is started in the Arcanaeum.\nDefault:"+ForbiddenTomeDefault)
	elseIf (option == SurreptitiousStreetsOID)
		SetInfoText("Enable/disable the 'Catch All' triggers that start the radiant master quests. Hint: Booty-trapped containers, sleep encounters, etc.\nDefault:"+SurreptitiousStreetsDefault)
	elseIf (option == RadiantMasterOID)
		SetInfoText("Enable/disable the 'Radiant Master' quest. This is a Surreptitious Streets quest. If there are no elligible quests enabled, Surreptitious Streets will do nothing.\nDefault:"+RadiantMaster)
	elseIf (option == HardcoreEffectsOID)
		SetInfoText("Enable/disable the more detrimental effects that some items (Such as restraints) apply.\nDefault:"+HardcoreEffectsDefault)
	elseIf (option == ssSleepChanceOID)
		SetInfoText("Configure the probability of a sleep capture event occuring while sleeping in an unsafe area.\nDefault:"+ssSleepChanceDefault)
	elseIf (option == ssTrapChanceOID)
		SetInfoText("Configure the probability of a trapped container spawning in an elligible location.\nDefault:"+ssTrapChanceDefault)
	elseIf (option == rmHeartbeatIntervalOID)
		SetInfoText("Configure how frequently master is polled / status is checked.\nDefault:"+rmHeartbeatIntervalDefault)
	elseIf (option == rmSummonHeartbeatIntervalOID)
		SetInfoText("Configure the frequency of summon reminders.\nDefault:"+rmSummonHeartbeatIntervalDefault)
	endIf
EndEvent


Event OnOptionSliderAccept(int option, float value)
	;Libs.Log("OnOptionSliderAccept("+option+"/"+value+")")	
	if (option == thresholdOID)
		UnlockThreshold = value as int
		SetSliderOptionValue(option, value, "{0}")
	elseIf (option == beltRateOID)
		BeltRateMult = value
		SetSliderOptionValue(option, value, "{1}")
	elseIf (option == plugRateOID)
		PlugRateMult = value
		SetSliderOptionValue(option, value, "{1}")
	elseIf (option == eventIntervalOID)
		EventInterval = value
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == effectVibrateChanceOID
		effectVibrateChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == effectHealthDrainChanceOID
		effectHealthDrainChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == effectManaDrainChanceOID
		effectManaDrainChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == effectStaminaDrainChanceOID
		effectStaminaDrainChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == baseMessageChanceOID
		baseMessageChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == baseHornyChanceOID
		baseHornyChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == baseBumpPumpChanceOID
		BaseBumpPumpChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == VolumeOrgasmOID
		VolumeOrgasm = (value as Float)
		SetSliderOptionValue(option, value, "{3}")
	elseIf option == VolumeVibratorOID
		VolumeVibrator = (value as Float)
		SetSliderOptionValue(option, value, "{3}")
	elseIf option == VolumeEdgedOID
		VolumeEdged = (value as Float)
		SetSliderOptionValue(option, value, "{3}")
	elseIf option == ssSleepChanceOID
		ssSleepChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == ssTrapChanceOID
		ssTrapChance = (value as Int)
		SetSliderOptionValue(option, value, "{1}")
	elseIf option == rmHeartbeatIntervalOID
		rmHeartbeatInterval = (value as Float)
		SetSliderOptionValue(option, value, "{3}")
	elseIf option == rmSummonHeartbeatIntervalOID
		rmSummonHeartbeatInterval = (value as Float)
		SetSliderOptionValue(option, value, "{3}")
	endIf

EndEvent
