Scriptname zbfUtil Hidden

; Returns the zbf script which holds all global data. See GetMain() for more info.
zbfBondageShell Function GetBS() Global
	Return zbfUtil.GetMain()
EndFunction

; Returns the zbf script which holds all global data. See GetMain() for more info.
zbfBondageShell Function GetShell() Global
	Return zbfUtil.GetMain()
EndFunction

; Returns the zbf script which holds all global data.
;
; Example:
; zbfUtil.GetMain().RetainAi()
; Makes the player ai driven. Is reference counted, so several instances can request ai control without interfering with each other.
zbfBondageShell Function GetMain() Global
	zbfBondageShell zbf
	
	zbf = Game.GetFormFromFile(0x020137E6, "ZaZAnimationPack.esm") as zbfBondageShell
	If zbf == None
		zbf = Game.GetFormFromFile(0x020137E6, "ZaZAnimationPack.esp") as zbfBondageShell
	EndIf
	
	Return zbf
EndFunction

zbfAnim Function GetAnim() Global
	zbfAnim zbf = Game.GetFormFromFile(0x0200c245, "ZaZAnimationPack.esm") as zbfAnim
	If zbf == None
		zbf = Game.GetFormFromFile(0x0200c245, "ZaZAnimationPack.esp") as zbfAnim
	EndIf
	Return zbf
EndFunction

; Puts on an armor item on the actor. The item itself is duplicated onto the character, so it's not removed from it's original container.
; 
; akActor - Actor to wear the item
; akArmor - Armor to place on the actor. Duplicates the item, original is not removed from it's container.
; abForced - Prevents removal by the character.
;
; Example:
; zbfUtil.WearItem(PlayerRef, WristBindings, abForced = True)
; Forces the player to wear WristBindings, and they can't be removed through the normal inventory screen.
Function WearItem(Actor akActor, Form akItem, Bool abForced = False) Global
	akActor.AddItem(akItem, aiCount = 1, abSilent = True)
	akActor.EquipItem(akItem, abPreventRemoval = abForced, abSilent = True)
EndFunction

; Unequips an item on the actor. Opposite of WearItem. The item, or a similar item, is destroyed in the process.
;
; akActor - Actor to unequip the armor.
; akArmor - Armor type to unequip. The item is not placed in the characters actors inventory.
; 
; Example:
; zbfUtil.UnwearItem(PlayerRef, WristBindings)
; Frees the player from wrist bindings. The bindings are not retained in the inventory.
Function UnWearItem(Actor akActor, Form akItem, Bool abForced = False) Global
	akActor.UnequipItem(akItem, abPreventEquip = abForced, abSilent = True)
	akActor.RemoveItem(akItem, aiCount = 1, abSilent = True)
EndFunction

; Conditionally wears an item
;
; Wears the item if
; a) Item is not already worn
; b) abCond evaluates to True

Function WearItemCond(Actor akActor, Form akItem, Bool abForced = False, Bool abCond = True) Global
	If (akActor.IsEquipped(akItem) == False) && (abCond == True)
		akActor.AddItem(akItem, aiCount = 1, abSilent = True)
		akActor.EquipItem(akItem, abPreventRemoval = abForced, abSilent = True)
	EndIf
EndFunction

; Conditionally unwears an item
;
; Unwears the item if
; a) Item is worn
; b) abCond evaluates to True
Function UnWearItemCond(Actor akActor, Form akItem, Bool abForced = False, Bool abCond = True) Global
	If (akActor.IsEquipped(akItem) == True) && (abCond == True)
		akActor.UnequipItem(akItem, abPreventEquip = abForced, abSilent = True)
		akActor.RemoveItem(akItem, aiCount = 1, abSilent = True)
	EndIf
EndFunction

; Returns the current version of Zaz Animation Pack.
;
; Returns the mod version number multiplied by 100.
; Version V005 would return 500. Small updates to 500 would return as 510, 520, etc.
Int Function GetVersion() Global
	Return 540
EndFunction

; Returns the current version of Zaz Animation Pack as a human readable string.
; 
; Eg. version V005.1 would return "5.10"
String Function GetVersionStr() Global
	Return "5.40"
EndFunction

; Places akObjA behind akObjB, according to akObjB's facing
;
; Works well to use with the pillory animations.
; This function is identical to MoveToFront with a negative distance and different default distance.
Function MoveToBehind(ObjectReference akObjB, ObjectReference akObjA, Float afDistance = 45.0) Global
	akObjA.MoveTo(akObjB, -afDistance * Math.Sin(akObjB.GetAngleZ()), -afDistance * Math.Cos(akObjB.GetAngleZ()), 0.0)
EndFunction

; Places object A in front of object B at the specified distance.
;
; This function is identical to MoveToBehind with a negative distance and different default distance.
Function MoveToFront(ObjectReference akObjB, ObjectReference akObjA, Float afDistance = 120.0) Global
	akObjA.MoveTo(akObjB, afDistance * Math.Sin(akObjB.GetAngleZ()), afDistance * Math.Cos(akObjB.GetAngleZ()), 0.0)
EndFunction

; Convenience function to lock ai
Function RetainAi() Global
	GetMain().RetainAi()
EndFunction

; Convenience function to release ai
Function ReleaseAi() Global
	GetMain().ReleaseAi()
EndFunction

; Actor scale is composed of two parts, B (base from CK) and S (console scale from console or papyrus)
; D (display scale) = B * S
; 
; Sets an actor display scale to a specified value.
; 
; Returns the previous scale factor (S) to make restoration easy. (Use SetScale from console or papyrus.)
Float Function SetActorDisplayScale(Actor akActor, Float afScale) Global
	; Identities:
	; 
	; D = S * B
	; D' = S' * B'
	; B = B'
	; S' = 1.0
	; 
	Float D = akActor.GetScale()
	akActor.SetScale(1.0)
	Float Dprim = akActor.GetScale()
	; B = B' = D' / S' = D'
	
	akActor.SetScale(afScale / Dprim)
	Return D / Dprim ; S = D / B = D / D'
EndFunction
