Scriptname zbfSexLab extends Quest  

; Framework
SexLabFramework Property SexLab Auto Hidden

; Individual animations
zbfSexLab_Defaults Property Defaults Auto

sslBaseAnimation[] Property Anims Auto

; Retrieves a specific animation by name, writing it into akTarget.
;
; Returns True if successful.
Bool Function GetAnimation(String asName, sslBaseAnimation akTarget)
	Defaults.GetAnimation(asName, akTarget)
EndFunction

; Dynamic linking method.
Function LinkDependency()
	If SexLab == None
		SexLab = Game.GetFormFromFile(0x01000D62, "SexLab.esm") as SexLabFramework
		If SexLab != None
			Defaults.SetSlots(SexLab.AnimSlots)
		EndIf
	EndIf
EndFunction

; Returns true if dynamic linking succeeded.
Bool Function HasSexLab()
	Return SexLab != None
EndFunction

; Returns registered SexLab version
Int Function GetVersion()
	If SexLab != None
		Quest config = Game.GetFormFromFile(0x0103E3FA, "SexLab.esm") as Quest
		Return (config As sslConfigMenu).GetVersion()
	EndIf
	
	Return 0
EndFunction

Bool Function IsFullyRegistered()
	If SexLab == None
		Return False
	EndIf

	Return Defaults.IsRegistered(SexLab)
EndFunction

Function RegisterForSexLab()
	GoToState("Registering")
	Debug.Trace("zbf Registering SexLab animations.")
	
	RegisterForSingleUpdate(5.0)
	
	; Retrieve SexLab integration
	Debug.TraceConditional("zbfSexLab: SexLab connection was not set up. Registration will do nothing.", SexLab == None)
	If SexLab != None
		Defaults.LoadAnimations()
	EndIf

	Debug.Trace("zbf Done!")
	GoToState("Idle")
EndFunction

Event OnUpdate()
EndEvent

Auto State Idle
EndState

State Registering
	Function RegisterForSexLab()
		Debug.Trace("zbf Multiple calls to register before finishing.")
	EndFunction

	Event OnUpdate()
		Debug.MessageBox("SexLab stuck in infinite loop.\nThere is nothing Zaz animation pack can do to fix the problem except to detect it. Your game is now broken and you _MUST_ load a save since before you tried to register new animations.")
	EndEvent
EndState
