Scriptname zbfEffectBondage extends activemagiceffect  

zbfBondageShell Property zbf Auto

Actor kTarget
;Int iEffectId

Bool bApplyMouth
Bool bApplyMovement
Bool bApplySilence
Bool bApplyPlayerControls

Bool Property bAllowBoundIdle = False Auto
Bool Property bAllowGeneral = False Auto
Keyword Property kEffectRefresh Auto

; Register a new update on this script if either
; 1. Gags, hoods, leg bindings etc are active.
; 2. Wrist animation is supposed to play and the item is flagged with refresh
Function RegisterForAnotherUpdate()
	Float fRegisterFrequency = 0
	
	If bAllowGeneral
		; Select from global
		fRegisterFrequency = zbf.GetUpdateInterval()
	EndIf
	
	If bAllowBoundIdle
		If kTarget.WornHasKeyword(kEffectRefresh)
			fRegisterFrequency = zbf.GetUpdateInterval()
		EndIf
	EndIf
	
	If fRegisterFrequency >= 0.1
		;Debug.Trace("zbf Register " + fRegisterFrequency)
		RegisterForSingleUpdate(fRegisterFrequency)
	EndIf
EndFunction

Function ApplyEffects(Actor akTarget)
	If bAllowGeneral
		zbf.ApplyAllModifiers(kTarget, bApplyMouth, bApplyMovement, bApplySilence, bApplyPlayerControls)
	EndIf

	If bAllowBoundIdle
		zbf.ApplyHandsModifier(kTarget)
	EndIf
EndFunction

Auto State Default
	Event OnUpdate()
		ApplyEffects(kTarget)
		RegisterForAnotherUpdate()
	EndEvent

	Event OnEffectStart(Actor akTarget, Actor akCaster)
		;iEffectId = Utility.RandomInt(0, 1000)
		;Debug.Trace("zbf Effect start: " + iEffectId)
		kTarget = akTarget
		bApplyMouth = zbf.HasExpressionModifier(akTarget)
		bApplyMovement = zbf.HasMovementModifier(akTarget)
		bApplySilence = zbf.HasSilenceEffect(akTarget)
		bApplyPlayerControls = zbf.HasPlayerControls(akTarget)

		ApplyEffects(kTarget)
		RegisterForAnotherUpdate()
	EndEvent

	Event OnEffectFinish(Actor akTarget, Actor akCaster)
		;Debug.Trace("zbf Effect finish: " + iEffectId)
		ApplyEffects(kTarget)

		; UpdateEvent is unregistered automatically when script terminates.
	EndEvent
EndState
