Scriptname zbfConfig extends zbfConfigBase

zbfSexLab Property SexLab Auto
zbfAnim Property Anim Auto
zbfBondageShell Property Main Auto

; Global variable properties
GlobalVariable Property zbfSettingUpdateInterval Auto
GlobalVariable Property zbfSettingDisableEffects Auto
GlobalVariable Property zbfSettingSpeedMult Auto
GlobalVariable Property zbfSettingBlindStrength Auto
GlobalVariable Property zbfSettingBlindPulseStrength Auto

; Global variable setting indices
Int oidUpdateInterval
Int oidDisableEffects
Int oidSpeedMult
Int oidBlindStrength
Int oidBlindPulseStrength

; Loose buttons and other misc controls
Int oidRegisterSexLab
Int oidRestart

; Convenience properties
Bool Property bDisableEffects
	Bool Function Get()
		Return zbfSettingDisableEffects.GetValueInt() != 0
	EndFunction
EndProperty
Float Property fUpdateInterval
	Float Function Get()
		Return zbfSettingUpdateInterval.GetValue()
	EndFunction
EndProperty
Float Property fSpeedMult
	Float Function Get()
		Return zbfSettingSpeedMult.GetValue()
	EndFunction
EndProperty
Bool Property bHasSexLab
	Bool Function Get()
		Return SexLab.HasSexLab()
	EndFunction
EndProperty
Float Property fBlindStrength
	Float Function Get()
		Return zbfSettingBlindStrength.GetValue()
	EndFunction
EndProperty
Float Property fBlindPulseStrength
	Float Function Get()
		Return zbfSettingBlindPulseStrength.GetValue()
	EndFunction
EndProperty

;
; Version handling
;
Int Function GetVersion()
	Return zbfUtil.GetVersion()
EndFunction

String Function GetVersionStr()
	Return zbfUtil.GetVersionStr()
EndFunction

Event OnVersionUpdate(Int aiVersion)
	If CurrentVersion > 0
		Debug.Notification("Zaz Animation Pack updating to version " + zbfUtil.GetVersionStr())
	EndIf

	Debug.Trace("Zaz Animation Pack: Update")
	Debug.Trace("Zaz Animation Pack: Previous " + CurrentVersion)
	Debug.Trace("Zaz Animation Pack: Current " + aiVersion)
	Debug.Trace("Zaz Animation Pack: Script version " + GetVersion())

	SetDefaults(CurrentVersion)
EndEvent

Function SetDefaults(Int aiPrevVersion)
	If aiPrevVersion < 500
		zbfSettingUpdateInterval.SetValue(0.5)
		zbfSettingDisableEffects.SetValueInt(0)
		zbfSettingSpeedMult.SetValueInt(70)
		zbfSettingBlindStrength.SetValueInt(50)
		zbfSettingBlindPulseStrength.SetValueInt(50)
	EndIf
EndFunction

;
; Settings parameters
;
Float Function GetFloat(Int aiOption)
	If aiOption == oidUpdateInterval
		Return fUpdateInterval
	ElseIf aiOption == oidDisableEffects
		Return bDisableEffects As Float
	ElseIf aiOption == oidSpeedMult
		Return fSpeedMult
	ElseIf aiOption == oidBlindStrength
		Return fBlindStrength
	ElseIf aiOption == oidBlindPulseStrength
		Return fBlindPulseStrength
	EndIf

	Debug.Trace("zbfConfig: Unknown configuration option requested")
EndFunction

Function SetFloat(Int aiOption, Float afValue)
	Bool abValue = (afValue != 0)
	Int aiValue = (afValue As Int)
	
	If aiOption == oidUpdateInterval
		zbfSettingUpdateInterval.SetValue(afValue)
	ElseIf aiOption == oidDisableEffects
		zbfSettingDisableEffects.SetValue(afValue)
	ElseIf aiOption == oidSpeedMult
		zbfSettingSpeedMult.SetValue(afValue)
	ElseIf aiOption == oidBlindStrength
		zbfSettingBlindStrength.SetValue(afValue)
	ElseIf aiOption == oidBlindPulseStrength
		zbfSettingBlindPulseStrength.SetValue(afValue)
	EndIf
EndFunction

;
; MCM event overrides
;
Event OnPageReset(String asPage)
	If GetVersion() != CurrentVersion
		Debug.MessageBox("Upgrade error!\nReported: " + CurrentVersion + "\nExpected: " + GetVersion())
	EndIf
	Parent.OnPageReset(asPage)
	
	; Link SexLab
	SexLab.LinkDependency()
	
	If asPage == ""
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0)

		; Left side
		AddHeaderOption("General")
		oidDisableEffects = MyAddToggleOption("Disable all", bDisableEffects, False, "Disables most scripted effects from this mod.")
		AddEmptyOption()

		AddHeaderOption("SexLab integration")
		oidRegisterSexLab = -1

		If bHasSexLab
			Int iVersion = SexLab.GetVersion()
			MyAddTextOption("SexLab Version", iVersion, "SexLab version")
			If iVersion >= 1200
				If SexLab.IsFullyRegistered()
					MyAddTextOption("SexLab animations", "Registered", "", aiFlags = OPTION_FLAG_DISABLED)
				Else
					oidRegisterSexLab = MyAddTextOption("SexLab animations", "Register", "Attempts to register SexLab animations.")
				EndIf
			Else
				MyAddTextOption("SexLab animations", "Too old", "SexLab too old to register animations.")
			EndIf
		Else
			MyAddTextOption("SexLab", "Not found", "SexLab module status indication.")
		EndIf
		AddEmptyOption()

		AddHeaderOption("Cleaning")
		oidRestart = MyAddTextOption("Clean and restart", "Restart", "Restart the module and restore settings to default.")
		AddEmptyOption()

		SetCursorPosition(1)

		; Right side
		AddHeaderOption("Update interval")
		oidUpdateInterval = MyAddSliderOption("Update interval", fUpdateInterval, 0.1, 5.0, 0.5, 0.1, "{1}s", "Effect update interval when items automatically refresh themselves.\nDefault is 0.5")
		AddEmptyOption()

		AddHeaderOption("Movement speed")
		oidSpeedMult = MyAddSliderOption("Shackled movement speed", fSpeedMult, 10.0, 100.0, 70.0, 1.0, "{1}%", "Forced movement speed when shackled. Default is 70.")
		AddEmptyOption()
		
		AddHeaderOption("Blindness")
		oidBlindStrength = MyAddSliderOption("Blindness strength", fBlindStrength, 0.0, 100.0, 50.0, 10.0, "{1}%", "Amount of blindness to apply in percent.")
		oidBlindPulseStrength = MyAddSliderOption("Blindness pulse", fBlindPulseStrength, 0.0, 100.0, 50.0, 10.0, "{1}%", "Amount of blindness pulse to apply (in percent).")
		AddEmptyOption()
	EndIf
EndEvent

Function RestartQuest(String asName, Quest akQuest)
	;Debug.Trace("Stop ... " + asName)
	akQuest.Stop()
	Utility.Wait(0.2)
	;Debug.Trace("Start ... " + asName)
	akQuest.Start()
EndFunction

Event OnOptionSelect(Int aiOption)
	If aiOption == oidRegisterSexLab
		SetOptionFlags(oidRegisterSexLab, a_flags = OPTION_FLAG_DISABLED, a_noUpdate = False)
		SexLab.RegisterForSexLab()
		SetTextOptionValue(oidRegisterSexLab, "Done")
	ElseIf aiOption == oidRestart
		RestartQuest("SexLab", SexLab)
		RestartQuest("Anim", Anim)
		RestartQuest("Main", Main)
		RestartQuest("Self", Self)
	Else
		Parent.OnOptionSelect(aiOption)
	EndIf
EndEvent
