Scriptname zbfAnim extends Quest


;
; Single actor poses
;
; Each index in the array represents a different pose, chain configuration and so on. They are
; not arranged in a progressive manner.
; 

Idle Property ForceReset Auto ; Forces animation Reset
Idle Property HandsFree Auto ; Unbinds actor hands

; Binds actor hands. Feet are free to move as normal.
;
; 0  Hands bound behind
; 1  Hands and elbows bound
; 2  Box tied
Idle[] Property HandsBound Auto

; Bondage poses
Idle[] Property BondagePose01 Auto ; ZazApc001-ZazApc020
Idle[] Property BondagePose02 Auto ; ZazApc050-ZazApc058

; Pillory poses
;
;  0-3  Gibbet (cage)
;  4-7  Gibbet wall (cage)
;  8-9  Pillory
; 10-15 Restraint post
; 16-21 Restraint post wall
;  22   wooden frame
;  23   wooden horse
;  24   xcross
Idle[] Property PilloryPoses Auto

; Medieval torture poses
;
; 0-4  Torture pole
;  5   Rack
;  6   Rack (upside down)
; 7-8  Crux
; 9-11 Wheel
Idle[] Property Medieval Auto

; Hogtie poses
Idle[] Property Hogtie Auto ; ZazAPCAO051-ZazAPCAO055

; Chains from floor and ceiling
;
; 	0 	hanging
; 	1 	hanging, legs spread
; 	2 	hanging high, legs spread
; 	3 	hanging high, weights on legs
; 	4 	standing strappado
; 	5 	hanging xcross position
; 	6 	standing with hands together
; 	7  	hanging upside down
; 	8 	hanging, arms and legs up
; 9-10 	on the ground, spread
; 11-13	chained to the ground, standing
;  14	hanging, no weights
Idle[] Property Chains Auto ; ZazAPCAO301-ZazAPCAO315


;
; Single actor animation sequences
;
; Each index is a different animation. They are arranged in a progressive manner and are
; representations of similar looking animations going from low to high.
; 

; Furo animation sequence.
; 
; Stages represent progressing the furo trap.
Idle[] Property Furo Auto ; ZazAPFSA001-ZazAPFSA008

; Pillory animations
; 
; Each stage is a different kind of struggle animation
Idle[] Property PillorySolo Auto ; ZazAPPillSolo01-ZazAPPillSolo05

;
; Dual actor anims sequences
;
; Each index belongs either to actor A or actor B. Odd indices are actor B and even actor A. Thus
; each stage in the animation has two indices; one for actor A and one for actor B.
; 
; There are accessor functions to make it easier to pick idles, GetIdleA and GetIdleB. See below for
; more details.
; 
; Enter/exit sequence always have two stages. First stage is enter, second stage is exit.
;
; Some sequences have only a single stage.
; 

; Pillory sex animation sequences
; 
; Stages
; 0 - Enter
; 1 - Hip 01
; 2 - Hip 02
; 3 - Hip 03
; 4 - Hand 01
; 5 - Hand 02
; 6 - Hold 01
; 7 - Hold 02
; 8 - Spank
; 9 - Climax
; 10 - Exit
; 
Idle[] Property PillorySex Auto

; Pillory sex animation where both characters are bound
; 
; Stages
; 0 - Enter
; 1 - Lick
; 2 - Sex 01
; 3 - Sex 02
; 4 - Sex 03
; 5 - Climax
; 6 - Exit
;
Idle[] Property PilloryBound Auto

; Torment from actor A
;
; Stage - Effect
; 0 - Butt rub
; 1 - Pussy rub
; 2 - Butt lick
; 3 - Spank 1
; 4 - Spank 2
; 5 - Candle drip
; 6 - Pussy broom
; 7 - Butt broom
Idle[] Property PilloryTorment Auto

;
; Access functions for making things easier
;
;

; Returns the number of stages in an animation sequence
; 
Int Function GetStageCount(Idle[] akAnimSequence)
	Return akAnimSequence.Length / 2 ; Rounding down, because sequence of odd length is invalid
EndFunction

; Returns an idle for actor A from the animation sequence and with a given stage index.
; 
Idle Function GetIdleA(Idle[] akAnimSequence, Int aiStageIndex)
	Int index = GetIndex(aiStageIndex, 0)
	Debug.TraceConditional("zbfAnim Bad index when accessing animation list.", index >= akAnimSequence.Length)
	Return akAnimSequence[index]
EndFunction

; Returns an idle for actor B from the animation sequence and with a given stage index.
; 
Idle Function GetIdleB(Idle[] akAnimSequence, Int aiStageIndex)
	Int index = GetIndex(aiStageIndex, 1)
	Debug.TraceConditional("zbfAnim Bad index when accessing animation list.", index >= akAnimSequence.Length)
	Return akAnimSequence[index]
EndFunction

; Returns the index in an animation sequence given a stage index and an actor index.
; 
; Actor indices are
; 0 - Actor A
; 1 - Actor B
; 
Int Function GetIndex(Int aiStageIndex, Int aiActorIndex)
	Return aiStageIndex * 2 + aiActorIndex
EndFunction
