scriptname sslMatchMakerMagicEffect extends ActiveMagicEffect  

; Our script doing the heavy lifting
sslMatchMaker property MatchMaker auto

; Spell effect has started
event OnEffectStart(actor target, actor caster)
	; Attempt to register the targeted actor into our Slots array on the other script.
	MatchMaker.RegisterActor(target)
endEvent

; Spell effect has expired
event OnEffectFinish(actor target, actor caster)
	; Check if the affected actor is slotted, and if so start the animation.
	if MatchMaker.IsSlotted(target)
		; The actor is indeed slotted, call TriggerSex() to start them animating.
		MatchMaker.TriggerSex()
	endIf
endEvent