ScriptName ProCMotherhood extends Quest

; The reference actors
Actor Property PlayerRef Auto
ActorBase Property BoyBase1 Auto
ActorBase Property GirlBase1 Auto


; Internal reference indexes
Actor[] Children
Actor[] Fathers


; The most recent child indexes
Int ChildIndex = -1
Int FatherIndex = -1


Event OnInit()
	Children = New Actor[128]
	Fathers = New Actor[128]
EndEvent


Function GiveBirth(Int NumberOfChildren, Actor Father, ActorBase SpecialChildBase = None)
	
	; The birth events. This is temporary.
	Debug.MessageBox("Uh oh! Your waters just broke, better get ready to give birth!")
	Utility.WaitGameTime(0.1*Utility.RandomFloat(0.5, 1))
	

	Debug.MessageBox("You are about to give birth!")
	; "Applies birth spell and events, etc."
	PlayerRef.UnequipAll()
	PlayerRef.SetUnconscious()
	
	While NumberOfChildren > 0
		
		Utility.Wait(10)
		
		NumberOfChildren -= 1
		
		Int gender = Utility.RandomInt(0,1)
		
		ChildIndex += 1
		FatherIndex += 1
		
		If ChildIndex < 128 && ChildIndex >= 0
			
			If gender == 0
				SpawnChild(0, Father, SpecialChildBase)
			Else
				SpawnChild(1, Father, SpecialChildBase)
			EndIf
			
		EndIf
		
	EndWhile	
	
	PlayerRef.SetUnconscious(False)
	
EndFunction


Function SpawnChild(Int gender, Actor Father, ActorBase SpecialChildBase = None)
	
	ActorBase ChildBase
	Actor Child
	String sg
	
	If SpecialChildBase == None
		If gender == 0
			ChildBase = BoyBase1
			sg = "boy"
		Else
			ChildBase = GirlBase1
			sg = "girl"
		EndIf
	Else
		ChildBase = SpecialChildBase
		sg = "child!"
	EndIf
	
	ChildBase = InheritLooks(ChildBase)
	Child = PlayerRef.PlaceActorAtMe(ChildBase)
	Child.QueueNiNodeUpdate()
	
	Children[ChildIndex] = Child
	Fathers[FatherIndex] = Father
	
	Debug.MessageBox("You gave birth to a healthy " + sg + "!")
	
EndFunction


ActorBase Function InheritLooks(ActorBase ChildBase)
	
	ActorBase PlayerBaseRef = PlayerRef.GetLeveledActorBase()
	
	Int PlayerNosePreset = PlayerBaseRef.GetFacePreset(0)
	Int PlayerEyesPreset = PlayerBaseRef.GetFacePreset(2)
	Int PlayerMouthPreset = PlayerBaseRef.GetFacePreset(3)
	ColorForm PlayerHairColor = PlayerBaseRef.GetHairColor()
	
	; SHOULD IMPORT MCM AND ADD RACIAL MODIFIERS TO FATHER/MOTHER FACIAL INHERITANCE
	
	ChildBase.SetFacePreset(PlayerNosePreset, 0)
	ChildBase.SetFacePreset(PlayerEyesPreset, 2)
	ChildBase.SetFacePreset(PlayerMouthPreset, 3)
	ChildBase.SetHairColor(PlayerHairColor)
	
	Return ChildBase
	
EndFunction
