Scriptname ProCMagicEffectWashOutSperm extends activemagiceffect  

; The MCM configuration settings and the procreation system is imported
ProCConfigMCM Property config Auto
ProCEvaluator Property Procreation  Auto  


Event OnEffectStart(actor target, actor caster)
	
	If Procreation.TimeOfLastReceivedSpermAtLastWashOutAttempt < Procreation.TimeOfLastReceivedSperm
		
		Procreation.TimeOfLastReceivedSpermAtLastWashOutAttempt = Procreation.TimeOfLastReceivedSperm
		Float CurrentTime = Utility.GetCurrentGameTime()
		
		caster.UnequipAll()
		
		Int i = Procreation.PotentialFathers.Length
		While i >= 1
			i -= 1
			If Procreation.PotentialFathers[i] != None
				
				; Checks if the sperm is received within the set time period
				If CurrentTime < Procreation.TimeOfSpermReception[i] + config.WashOutMaxAge / 24
					; Random roll
					Int Random = Utility.RandomInt(1,100)
					If Random <= config.ChanceToWashOut
						Procreation.RemoveSperm(i)
					EndIf
					
				EndIf
				
				
			EndIf
		EndWhile
		
		Debug.Notification("You wash out the sperm as thoroughly as you can.")
		
	Else
		
		Debug.Notification("There's no sperm to wash out.")
		
	EndIf
	
EndEvent
