Scriptname ProCEvaluator extends Quest

; Player actor property
Actor Property PlayerRef Auto

; The SexLab framework is imported
SexLabFramework Property SexLab Auto
Bool IsSexLabHookRegistered = False

; The MCM configuration settings are imported
ProCConfigMCM Property config Auto

; The Motherhood quest is imported
ProCMotherhood Property Motherhood  Auto  

; Acquire sperm spell. Only for debugging.
Spell Property AcquireSpermSpell Auto

; Wash Out Sperm spell added.
Spell Property WashOutSpermSpell  Auto
Float Property TimeOfLastReceivedSpermAtLastWashOutAttempt = -1.0 Auto Hidden; ... I just couldn't come up with a shorter name for it.

; Constant spell effects (abilities) for PMS, pregnancy, etc.
Spell Property ProCAbilityPMS Auto
Spell Property ProCAbilityMenstrualCramps Auto
Spell Property ProCAbilityPregnancy1 Auto
Spell Property ProCAbilityPregnancy2 Auto
Spell Property ProCAbilityPregnancy3 Auto
Spell Property ProCAbilityPostBirthWeakness Auto

; General information about the mod
Bool isInitialized = False ; Don't touch this.

; Phase and update related variables
Int CurrentPhase = 30 ; The current phase of menstruation OR pregnancy.
Int DaysRemainingOfCurrentPhase = 0 ; The remaining time of the current phase of menstruation OR pregnancy.
Int LastUpdateDay = 0 ; Used to manage the time when the next update is registered for.

; Sperm acquisition and conception related variables
Actor[] Property PotentialFathers Auto Hidden ; Array of actors the player has acquired sperm from. Max number of actors should be configurable.
Int[] Property TimeToSpermDeath Auto Hidden ; Array of integers denoting the number of days till a particular person is removed from the PotentialFarthers list. The indexes of this array and PotentialFarthers should match.
Float[] Property TimeOfSpermReception Auto Hidden ; Records the time at which the sperm was received
Int CurrentFatherArrayIndex = 0 ; Internal variable. Necessary because nested arrays is not a standard feature. *sigh*
Float Property TimeOfLastReceivedSperm = -1.0 Auto Hidden

; Belly size variables
Bool OriginalScaleVarsSet = False
Float OriginalWeight
Float OriginalNodeScaleBelly
Float OriginalNodeScaleLBreast
Float OriginalNodeScaleRBreast

; Pregnancy related variables
Actor Father = None
Bool GiveBirth = False
Bool StartPregnancyForReal = False
Int NumberOfBabies = 1
Int PregnancyDelay = -1
Int PregnancyTotalDelay
Bool PregnancyMessageSent = False
Int Trimester1Duration
Int Trimester2Duration
Int Trimester3Duration


;--------------------------------------------------
; Initializing event and function
;--------------------------------------------------

; Calls the initialize function when the quest is loaded
Event OnInit()
	Initialize()
	
	; Sperm acquisition arrays are set up.
	PotentialFathers = New Actor[10]
	TimeToSpermDeath = New Int[10]
	TimeOfSpermReception = New Float[10]
	
EndEvent

; Sets the phase to menstruation when the mod is first loaded, if the player is female.
Function Initialize()
	
	; Gives the Wash Out Sperm Spell to the player.
	If Game.GetPlayer().HasSpell(WashOutSpermSpell) == False
		Game.GetPlayer().AddSpell(WashOutSpermSpell)
	EndIf
	
	; Makes sure the SexLab event is registered
	If IsSexLabHookRegistered == False
		RegisterForModEvent("OrgasmStart", "SexLabAcquireSpermProcreation")
	EndIf
	
	; Makes sure nodes are scaled properly after loading a save.
	SetPregnantNodes()
	
	; Only run once. Makes sure the update event is registered.
	If isInitialized == False
		UpdateMenstruationPhase()
		RegisterNextUpdate()
		isInitialized = True
	EndIf
	
EndFunction





;--------------------------------------------------
; The Update event is run once a day and is the main "controller", that is, this is where phases are changed, conceiving happens, etc.
;--------------------------------------------------

Event OnUpdateGameTime()
	
	
	; Gives the Acquire Sperm spell to the player. Only for debugging. Should be removed once SexLab is integrated.
	;If Game.GetPlayer().HasSpell(AcquireSpermSpell) == False
	;	Game.GetPlayer().AddSpell(AcquireSpermSpell)
	;EndIf
	
	; Gives the Wash Out Sperm Spell to the player.
	If Game.GetPlayer().HasSpell(WashOutSpermSpell) == False
		Game.GetPlayer().AddSpell(WashOutSpermSpell)
	EndIf
	
	; Makes sure the SexLab event is registered
	If IsSexLabHookRegistered == False
		RegisterForModEvent("OrgasmStart", "SexLabAcquireSpermProcreation")
	EndIf
	
	If PlayerRef.GetActorBase().GetSex() == 1
		
		DaysRemainingOfCurrentPhase -= 1
		
		If config.IsPregnant == False
			Conceive()
		EndIf
		
		If GiveBirth == True
			Float BirthDelay = CalcBirthDelay()
			Utility.WaitGameTime(BirthDelay)
			GiveBirth()
		EndIf
		
		; Removes sperm older than the set limit
		RemoveOldSperm()
		
		If config.IsPregnant == False
			; If the player didn't conceive, update menstruation phase
			UpdateMenstruationPhase()
			MenstruationEvents()
		ElseIf config.IsPregnant == True
			; If the player is pregnant, update the pregnancy phase
			UpdatePregnancyPhase()
			PregnancyEvents()
		EndIf
		
		UpdateBelly(PlayerRef)
		
	EndIf
	
	RegisterNextUpdate()
	
EndEvent

Event SexLabAcquireSpermProcreation(string hookName, string argString, float argNum, form sender)
	
	; Hooks the animation and actors from the SexLab framework
    sslBaseAnimation animation = SexLab.HookAnimation(argString)
	actor[] actors = SexLab.HookActors(argString)
	Int PlayerIndex = actors.Find(PlayerRef) ; Gets the player index from the actor list
	Int NumberOfActors = actors.Length
	
	; Checks if more than one actor is involved, if the player is involved, and if the sex is vaginal
	If NumberOfActors > 1 && PlayerIndex >= 0 && animation.HasTag("Vaginal")
		
		; Gets the index of the first listed male actor in the animation - later this should perhaps be animation specific for animations with 3 or more actors, to make sure the one doing the vaginal penetration is the one whose sperm is delivered.
		Int i = NumberOfActors
		Int MaleIndex = -1
		While i > 0
			i -= 1
			If actors[i].GetActorBase().GetSex() == 0
				MaleIndex = i
				i = 0
			EndIf
		EndWhile
		
		; Checks if a male actor was found, and passes him on to the "AcquireSperm" function (if the player is female)
		If MaleIndex >= 0 && PlayerRef.GetActorBase().GetSex() == 1
			Debug.Notification(actors[MaleIndex].GetActorBase().GetName() + " is cuming inside you!")
			AcquireSpermFrom(actors[MaleIndex])
		EndIf
		
	EndIf
	
EndEvent





; This function registers the next update event. It registers one event at a random time every day.
; To make sure that sleeping/waiting doesn't "push" the cycle, the update time is calculated based on the time remaining of the day.
; The exact time of day the update happens on is random. But it does happen once every day.
Function RegisterNextUpdate()
	
	Int CurrentDay = Math.Floor(Utility.GetCurrentGameTime())
	Float RemainingTime = GetRemainingTimeOfDay()
	Float DelayTime
	
	; Checks if the last update happened yesterday. This is necessary because the player might wait/sleep from before an update has happened, and untill the next day. This would then "skip" a day, without this check.
	If (CurrentDay - LastUpdateDay) > 0
		; If the update has not happened today, it is set to happen at a random time on hour from now untill the end of the day.
		DelayTime = Utility.RandomFloat(1.0, (RemainingTime - 1.0))
		
	Else
		; If the update has already been called today, a random time tomorrow is set.
		DelayTime = Utility.RandomFloat((RemainingTime + 1.0), (RemainingTime + 22.0))
		
	EndIf
	
	; The time of this update is remembered
	LastUpdateDay = CurrentDay
	
	RegisterForSingleUpdateGameTime(DelayTime)
	;RegisterForSingleUpdateGameTime(1) ; TEMPORARY
	
EndFunction


; Calculates the time to delay when about to give birth.
Float Function CalcBirthDelay()
	
	Float Time = GetRemainingTimeOfDay()
	
	Return Utility.RandomFloat(GetRemainingTimeOfDay()*0.05, GetRemainingTimeOfDay() - 1)
	
EndFunction


; Returns the remaning hours of the day
Float Function GetRemainingTimeOfDay()

	Float Time = Utility.GetCurrentGameTime()
	Time = Time - Math.Floor(Time)
	Time = 1 - Time
	Time = Time*24
	
	Return Time
	
EndFunction


; Hides all quest objectives
Function HideAllObjectives()

		SetObjectiveDisplayed(0, abDisplayed = False)
		SetObjectiveDisplayed(10, abDisplayed = False)
		SetObjectiveDisplayed(20, abDisplayed = False)
		SetObjectiveDisplayed(30, abDisplayed = False)
		SetObjectiveDisplayed(40, abDisplayed = False)
		SetObjectiveDisplayed(50, abDisplayed = False)
		SetObjectiveDisplayed(60, abDisplayed = False)
		
EndFunction



;--------------------------------------------------
; Pregnancy related functions
;--------------------------------------------------

; The general pregnancy update function. Manages what happens when.
Function UpdatePregnancyPhase()
	
	If DaysRemainingOfCurrentPhase < 1 && StartPregnancyForReal == True
		
		; Checks which phase has ended, and sets new variables - or gives birth if 3rd trimester has ended
		If CurrentPhase == 0  || CurrentPhase == 10  || CurrentPhase == 20  || CurrentPhase == 30
			
			; Applying 1st trimester
			
			CurrentPhase = 40
			DaysRemainingOfCurrentPhase = Trimester1Duration
			RemoveAllAbilities(PlayerRef)
			PlayerRef.AddSpell(ProCAbilityPregnancy1)
			
		ElseIf CurrentPhase == 40
			
			; Applying 2nd trimester
			
			CurrentPhase = 50
			DaysRemainingOfCurrentPhase = Trimester2Duration
			RemoveAllAbilities(PlayerRef)
			PlayerRef.AddSpell(ProCAbilityPregnancy2)
			
		ElseIf CurrentPhase == 50
			
			; Applying 3rd trimester
			
			CurrentPhase = 60
			DaysRemainingOfCurrentPhase = Trimester3Duration
			RemoveAllAbilities(PlayerRef)
			PlayerRef.AddSpell(ProCAbilityPregnancy3)
			
		ElseIf CurrentPhase == 60
			
			; Preparing to give birth
			
			GiveBirth = True
			RemoveAllAbilities(PlayerRef)
			
		EndIf
		
		
		If GiveBirth == False
			; Cleans up the spell effects and objectives
			HideAllObjectives()
			SetStage(CurrentPhase)
			If config.EnableMessages == True
				SetObjectiveDisplayed(CurrentPhase, abForce = True)
			EndIf
		EndIf
		
	EndIf
	
EndFunction


; Events that may happen during pregnancy (spell effects, miscarriage, etc.)
Function PregnancyEvents()
	
	If PregnancyDelay >= 0
		PregnancyDelay -= 1
		DaysRemainingOfCurrentPhase += 1
		
		; IRREGULARITY POSSIBLE - random miscarriage (low chance)
		
		
		If PregnancyDelay > 0
			UpdateMenstruationPhase()
			SendPregnancyMessage()
		ElseIf PregnancyDelay == 0
			StartPregnancyForReal = True
			DaysRemainingOfCurrentPhase = 0
			PregnancyDelay = -1
			
			; Updates the pregnancy phase
			UpdatePregnancyPhase()
			
		EndIf
		
	ElseIf CurrentPhase == 40
		; More events during 1st trimester. Cast spells, check for miscarriage, etc.
		
	ElseIf CurrentPhase == 50
		; More events during 2nd trimester. Cast spells, check for miscarriage, etc.
		
	ElseIf CurrentPhase == 60
		; More events during 3rd trimester. Cast spells, check for miscarriage, etc.
		
	EndIf
	
EndFunction


; Function that helps "hiding" the pregnancy initially. A message is sent after some time.
Function SendPregnancyMessage()
	
	If PregnancyMessageSent == False && (PregnancyTotalDelay-PregnancyDelay > config.LutealDuration * Math.Floor(Utility.RandomFloat((config.RelativeMesntruationPhaseVariance/100)+1, ((config.RelativeMesntruationPhaseVariance/100)+1)*2)))
		PregnancyMessageSent = True
		If config.EnableMessages == True
			If NumberOfBabies == 2
				Debug.MessageBox("Congratulations! You are pregnant with twins! The lucky guy is " + Father.GetActorBase().GetName() + ".")
			ElseIf NumberOfBabies == 3
				Debug.MessageBox("Congratulations! You are pregnant with triplets! The lucky guy is " + Father.GetActorBase().GetName() + ".")
			Else
				Debug.MessageBox("Congratulations! You are pregnant! The lucky guy is " + Father.GetActorBase().GetName() + ".")
			EndIf
		Else
			Debug.MessageBox("You notice a slight bulge in your belly. You might be pregnant.")
		EndIf
	EndIf
		
EndFunction


; Function that changes either the weight or the scale of the skeleton nodes, depending on the players settings and the current state (e.g. pregnant or not)
Function UpdateBelly(Actor character)
	
	; Weight scaling
	If config.VisualScalingType == 1
		
		If config.IsPregnant == True
		
			Float CurrentWeight = character.GetActorBase().GetWeight()
			Float NewWeight = CurrentWeight + CalcPregSizeIncrement(NumberOfBabies)
			UpdateBellyWeight(character, CurrentWeight, NewWeight)
		
		Else
			
			Float CurrentWeight = character.GetActorBase().GetWeight()
			Float NewWeight = 0.0
			UpdateBellyWeight(character, CurrentWeight, NewWeight)
			
		EndIf
		
	ElseIf config.VisualScalingType == 2
		
		SetPregnantNodes()
		
	EndIf
	
	
EndFunction


Function ResetScale(Int NOB, Float PercentageOfFullScale = 100.0)
	
	Float NOBScaleFactor
	
	; If number of babies is 1
	If NOB == 1
		NOBScaleFactor = config.NormalPregMaxSize
		
	; If number of babies is 3
	ElseIf NOB == 3
		NOBScaleFactor = config.TripletsPregMaxSize
		
	; If number of babies is 2 (or something else, which shouldn't happen)
	Else 
		NOBScaleFactor = config.TwinsPregMaxSize
		
	EndIf
	
	Float MaxScaleMultiplier = (NOBScaleFactor / 100.0) * (PercentageOfFullScale / 100.0)
	
	Float CurrentBellyScale = NetImmerse.GetNodeScale(PlayerRef, "NPC Belly", False)
	Float CurrentLBreastScale = NetImmerse.GetNodeScale(PlayerRef, "NPC L Breast", False)
	Float CurrentRBreastScale = NetImmerse.GetNodeScale(PlayerRef, "NPC R Breast", False)
	
	Float BellyScaleSurplus = config.MaxScaleBelly * MaxScaleMultiplier
	Float LBreastScaleSurplus = config.MaxScaleBreasts * MaxScaleMultiplier
	Float RBreastScaleSurplus = config.MaxScaleBreasts * MaxScaleMultiplier
	
	Float NewBellyScale = CurrentBellyScale - BellyScaleSurplus
	Float NewLBreastScale = CurrentLBreastScale - LBreastScaleSurplus
	Float NewRBreastScale = CurrentRBreastScale - RBreastScaleSurplus
	
	UpdateNodes(PlayerRef, NewBellyScale, NewLBreastScale, NewRBreastScale)
	
EndFunction


; Function that changes the weight of the actor specified (used to manage the belly size during pregnancy).
Function UpdateBellyWeight(Actor character, Float CurrentWeight, Float NewWeight)

	If NewWeight > 100.0
		NewWeight = 100.0
	ElseIf NewWeight < 0.0
		NewWeight = 0.0
	EndIf
	
	Float NeckDelta = (CurrentWeight / 100) - (NewWeight / 100) 
	character.GetActorBase().SetWeight(NewWeight)
	character.UpdateWeight(NeckDelta)
	
EndFunction


; Function that changes the skeleton node scales (used to manage the belly size during pregnancy).
Function UpdateNodes(Actor character, Float NewBellyScale, Float NewLBreastsScale, Float NewRBreastsScale)
	
	If NewBellyScale > config.MaxScaleBelly
		NewBellyScale = config.MaxScaleBelly
	ElseIf NewBellyScale < 1.0
		NewBellyScale = 1.0
	EndIf
	
	If NewLBreastsScale > config.MaxScaleBreasts
		NewLBreastsScale = config.MaxScaleBreasts
	ElseIf NewLBreastsScale < 1.0
		NewLBreastsScale = 1.0
	EndIf
	
	If NewRBreastsScale > config.MaxScaleBreasts
		NewRBreastsScale = config.MaxScaleBreasts
	ElseIf NewRBreastsScale < 1.0
		NewRBreastsScale = 1.0
	EndIf
	
	NetImmerse.SetNodeScale(character, "NPC Belly", NewBellyScale, False)
	NetImmerse.SetNodeScale(character, "NPC Belly", NewBellyScale, true)
	NetImmerse.SetNodeScale(character, "NPC L Breast", NewLBreastsScale, False)
	NetImmerse.SetNodeScale(character, "NPC L Breast", NewLBreastsScale, true)
	NetImmerse.SetNodeScale(character, "NPC R Breast", NewRBreastsScale, False)
	NetImmerse.SetNodeScale(character, "NPC R Breast", NewRBreastsScale, true)
	
EndFunction



Function SetPregnantNodes()
	
	If config.IsPregnant && config.VisualScalingType == 2
		
		Int PregnantDaysElapsed = GetDaysElapsedOfPregnancy()
		Float ScaleIncrement = CalcPregSizeIncrement(NumberOfBabies) / 100.0
		
		Float NewBellyScale = (config.MaxScaleBelly - 1) * ScaleIncrement * PregnantDaysElapsed + 1
		Float NewLBreastScale = (config.MaxScaleBreasts - 1) * ScaleIncrement * PregnantDaysElapsed + 1
		Float NewRBreastScale = (config.MaxScaleBreasts - 1) * ScaleIncrement * PregnantDaysElapsed + 1
		
		UpdateNodes(PlayerRef, NewBellyScale, NewLBreastScale, NewRBreastScale)
		
	EndIf
	
EndFunction



Int Function GetDaysElapsedOfPregnancy()
	
	Int PregnantDaysElapsed
	
	If StartPregnancyForReal == False
		
		PregnantDaysElapsed = PregnancyTotalDelay - PregnancyDelay
		
	ElseIf CurrentPhase == 40
		
		PregnantDaysElapsed = PregnancyTotalDelay + Trimester1Duration - DaysRemainingOfCurrentPhase
		
	ElseIf CurrentPhase == 50
		
		PregnantDaysElapsed = PregnancyTotalDelay + Trimester1Duration + Trimester2Duration - DaysRemainingOfCurrentPhase
		
	ElseIf CurrentPhase == 60
		
		PregnantDaysElapsed = PregnancyTotalDelay + Trimester1Duration + Trimester2Duration + Trimester3Duration - DaysRemainingOfCurrentPhase
		
	EndIf
	
	Return PregnantDaysElapsed
	
EndFunction


; Calculates how much to increase belly size during each update when pregnant. - Should perhaps not be linear. Not gonna worry for the moment.
Float Function CalcPregSizeIncrement(Int NOB)
	
	Int NumberOfUpdates = Trimester1Duration+Trimester2Duration+Trimester3Duration+PregnancyTotalDelay
	Float MaxWeight
	
	; If number of babies is 1
	If NOB == 1
		MaxWeight = config.NormalPregMaxSize
		
	; If number of babies is 3
	ElseIf NOB == 3
		MaxWeight = config.TripletsPregMaxSize
		
	; If number of babies is 2 (or something else, which shouldn't happen)
	Else 
		MaxWeight = config.TwinsPregMaxSize
		
	EndIf
	
	; Returns the weight increment per update
	Return (MaxWeight/NumberOfUpdates)
	
EndFunction




; Temporary function to make the cycle complete.
Function GiveBirth()
	
	Int NOB = NumberOfBabies
	
	Motherhood.GiveBirth(NumberOfBabies, Father)
	
	; Cleanup
	config.IsPregnant = False
	StartPregnancyForReal = False
	GiveBirth = False
	PregnancyMessageSent = False
	Father = None
	CurrentPhase = 30
	ResetScale(NOB, 100.0)
	RemoveAllAbilities(PlayerRef)
	
	; The delay untill normal menstruation resumes is calculated.
	DaysRemainingOfCurrentPhase = DurationIrregularity(Math.Ceiling(config.LutealDuration/2.00), config.PostBirthNormalizationVariance, 100, 1)
	
EndFunction




;--------------------------------------------------
; Functions related to conceiving
;--------------------------------------------------

; Run once a day, but only when ovulating. If any sperm is present, it checks if the sperm fertilizes an egg (and calls PickFather).
Function Conceive(Actor SpecialFather = None, Int NOB = -1)
	If CurrentPhase == 20 && SpermExists()
		
		Actor PotentialFather
		
		If SpecialFather == None
			PotentialFather = PickFather()
		Else
			PotentialFather = SpecialFather
		EndIf
		
		Race MotherRace = PlayerRef.GetRace()
		Int ModdedChanceToConceive = config.ChanceToConceive
		Int random = Utility.RandomInt(0, 100)
		
		
		If config.EnableRaceMultipliers == True
			Race FatherRace = PotentialFather.GetRace()
			
			Int i_m = config.GetRaceIndex(MotherRace)
			Int i_f = config.GetRaceIndex(FatherRace)
			
			; Include the inert race multiplier for conception
			ModdedChanceToConceive = Math.Ceiling(config.MotherRaceConceiveMultiplier[i_f]*ModdedChanceToConceive)
			
			; Includes a race bonus, if both the mother and PotentialFather races are of the same race
			If i_m == i_f
				
				ModdedChanceToConceive = Math.Ceiling(config.SameRaceConceiveMultiplier[i_f]*ModdedChanceToConceive)
				
			; Includes a race bonus, if both the mother and PotentialFather races are human or elven
			ElseIf i_m == 2 || i_m == 3 || i_m == 4 || i_m == 5 || i_m == 6 || i_m == 7 || i_m == 8 || i_m == 9 || i_m == 12 || i_m == 13 || i_m == 16 || i_m == 17 || i_m == 18 || i_m == 19
				If i_f == 2 || i_f == 3 || i_f == 4 || i_f == 5 || i_f == 6 || i_f == 7 || i_f == 8 || i_f == 9 || i_f == 12 || i_f == 13 || i_f == 16 || i_f == 17 || i_f == 18 || i_f == 19
					ModdedChanceToConceive = Math.Ceiling(config.SameRaceConceiveMultiplier[i_f]*ModdedChanceToConceive)
				EndIf
			EndIf
			
		EndIf
		
		
		; Checks if the player conceived
		If random <= ModdedChanceToConceive
			
			config.IsPregnant = True
			Father = PotentialFather
			
			; The duration of the pregnancy is calculated.
			PregnancyDelay = DurationIrregularity(config.LutealDuration+config.MenstruationDuration, config.RelativePregnancyDelayVariance, config.IrregularityChance, 1)
			PregnancyTotalDelay = PregnancyDelay
			Trimester1Duration = DurationIrregularity(config.Trimester1BaseDuration, config.RelativePregnancyPhaseVariance, config.IrregularityChance)
			Trimester2Duration = DurationIrregularity(config.Trimester2BaseDuration, config.RelativePregnancyPhaseVariance, config.IrregularityChance)
			Trimester3Duration = DurationIrregularity(config.Trimester3BaseDuration, config.RelativePregnancyPhaseVariance, config.IrregularityChance)
			
			; The number of babies is calculated.
			If NOB < 1
				NumberOfBabies = CalcNumberOfBabies(MotherRace)
			EndIf
			
		Else
			Father = None
		EndIf
	EndIf
EndFunction


; Determines whether one, two or three eggs are fertilized
Int Function CalcNumberOfBabies(Race MotherRace)
	
	Int random = Utility.RandomInt(0, 100)
	Int TempTwinsThreshold = config.TwinsThreshold
	Int TempTripletsThreshold = config.TripletsThreshold
	
	
	If config.EnableRaceMultipliers == True
		Int i = config.GetRaceIndex(MotherRace)
		TempTwinsThreshold = config.TwinsRaceThresholds[i]
		TempTripletsThreshold = config.TripletsRaceThresholds[i]
	EndIf
	
	If random < TempTwinsThreshold
		Return 1
	ElseIf random < TempTripletsThreshold
		Return 2
	Else
		Return 3
	EndIf
	
EndFunction


; Semi-random selection from PotentialFathers array.
; Weighing could be based on (should be configurable):
	; Race - some races produce more semen (e.g. orcs would probably produce more than high elves).
Actor Function PickFather()
	
	; Rolls for each potential father and picks the highest roll (appllies racial modifier FatherRaceSpermMultiplier)
	Int highest_index = 0
	Int highest = 0
	Int random
	Int i = PotentialFathers.Length
	While i > 0
		i -= 1
		
		If PotentialFathers[i] != None
			
			random = Utility.RandomInt()
		
			If config.EnableRaceMultipliers == True
				Race PotentialFatherRace = PotentialFathers[i].GetActorBase().GetRace()
				Race MotherRace = PlayerRef.GetActorBase().GetRace()
				
				Int i_m = config.GetRaceIndex(MotherRace)
				Int i_f = config.GetRaceIndex(PotentialFatherRace)
				
				; Includes an inheret sperm bonus, depending on the race.
				random = Math.Ceiling(config.FatherRaceSpermMultiplier[i_f] * random)
				
				; Includes a race bonus, if both the mother and PotentialFather races are of the same race
				If i_m == i_f
					
					random = Math.Ceiling(config.SameRaceConceiveMultiplier[i_f]*random)
					
				; Includes a race bonus, if both the mother and PotentialFather races are human or elven
				ElseIf i_m == 2 || i_m == 3 || i_m == 4 || i_m == 5 || i_m == 6 || i_m == 7 || i_m == 8 || i_m == 9 || i_m == 12 || i_m == 13 || i_m == 16 || i_m == 17 || i_m == 18 || i_m == 19
					If i_f == 2 || i_f == 3 || i_f == 4 || i_f == 5 || i_f == 6 || i_f == 7 || i_f == 8 || i_f == 9 || i_f == 12 || i_f == 13 || i_f == 16 || i_f == 17 || i_f == 18 || i_f == 19
						random = Math.Ceiling(config.SameRaceConceiveMultiplier[i_f]*random)
					EndIf
				EndIf
				
			EndIf
			
			If random > highest
				highest_index = i
				highest = random
			EndIf
			
		EndIf
	EndWhile
	
	Return PotentialFathers[highest_index]
	
EndFunction

; Function called by spell or SSL event to acquire sperm. Adds to the PotentialFathers array and TimeToSpermDeath array.
Function AcquireSpermFrom(Actor PotentialFather)
	
	; Checks if the PotentialFather is male
	If PotentialFather.GetActorBase().GetSex() == 0
		
		Race PotentialFatherRace = PotentialFather.GetActorBase().GetRace()
		Int i = config.GetRaceIndex(PotentialFatherRace)
		
		If i >= 0
			
			PotentialFathers[CurrentFatherArrayIndex] = PotentialFather
			
			If config.EnableRaceMultipliers == True
				TimeToSpermDeath[CurrentFatherArrayIndex] = Math.Ceiling(config.SpermDurationByRace[i] * config.SpermDuration)
			Else
				TimeToSpermDeath[CurrentFatherArrayIndex] = config.SpermDuration
			EndIf
			
			; Irregularity about the survival time of sperm
			TimeToSpermDeath[CurrentFatherArrayIndex] = DurationIrregularity(TimeToSpermDeath[CurrentFatherArrayIndex], config.RelativeSpermDurationVariance, config.IrregularityChance)
			TimeOfSpermReception[CurrentFatherArrayIndex] = Utility.GetCurrentGameTime()
			TimeOfLastReceivedSperm = Utility.GetCurrentGameTime()
			
			CurrentFatherArrayIndex += 1
			If CurrentFatherArrayIndex > 9
				CurrentFatherArrayIndex = 0
			EndIf
			
		EndIf
		
	EndIf
	
EndFunction

; Function called once per day. It removes any sperm older than a specific number of days (e.g. 4. Should be configurable).
Function RemoveOldSperm()
	
	Int i = PotentialFathers.Length
	While i >= 1
		i -= 1
		If TimeToSpermDeath[i] > 0
			TimeToSpermDeath[i] = TimeToSpermDeath[i] - 1
		EndIf
		
		If TimeToSpermDeath[i] < 1
			RemoveSperm(i)
		ElseIf config.EnableMessages == True
			Debug.Notification("You have sperm from " + PotentialFathers[i].GetActorBase().GetName() + " inside you. (Days left: " + TimeToSpermDeath[i] + ")")
		EndIf
		
	EndWhile
	
EndFunction

; Removes sperm and potential father from the selected index.
Function RemoveSperm(Int Index)
	TimeToSpermDeath[Index] = -1
	TimeOfSpermReception[Index] = -1.0
	PotentialFathers[Index] = None
EndFunction

; Checks if the player has any live sperm. Returns true/false.
Bool Function SpermExists()
	Int i = PotentialFathers.Length
	While i >= 1
		i -= 1
		If PotentialFathers[i] != None
			Return True
		EndIf
	EndWhile
EndFunction



;--------------------------------------------------
; Functions related to the menstrual cycle
;--------------------------------------------------

; This function is called by the Update event, and advances the menstrual cycle to the next phase.
Function UpdateMenstruationPhase()
	
	If DaysRemainingOfCurrentPhase < 1
		If CurrentPhase == 0
			CurrentPhase = 10
			DaysRemainingOfCurrentPhase = DurationIrregularity(config.FollicularDuration, config.RelativeMesntruationPhaseVariance, config.IrregularityChance)
		ElseIf CurrentPhase == 10
			CurrentPhase = 20
			DaysRemainingOfCurrentPhase = DurationIrregularity(config.OvulationDuration, config.RelativeMesntruationPhaseVariance, config.IrregularityChance)
		ElseIf CurrentPhase == 20
			CurrentPhase = 30
			DaysRemainingOfCurrentPhase = DurationIrregularity(config.LutealDuration, config.RelativeMesntruationPhaseVariance, config.IrregularityChance)
		ElseIf CurrentPhase == 30
			CurrentPhase = 0
			DaysRemainingOfCurrentPhase = DurationIrregularity(config.MenstruationDuration, config.RelativeMesntruationPhaseVariance, config.IrregularityChance)
		EndIf
		
		; Cleans up spell effects and objectives
		RemoveAllAbilities(PlayerRef)
		HideAllObjectives()
		SetStage(CurrentPhase)
		
		If config.EnableMessages == True
			Debug.Notification("Days remaining of current menstruation phase: " + DaysRemainingOfCurrentPhase)
		EndIf
		
		If config.EnableMessages == True || CurrentPhase == 0
			SetObjectiveDisplayed(CurrentPhase, abForce = True)
		EndIf
	
	EndIf
	
EndFunction


; Events during the different phases should be triggered here.
Function MenstruationEvents()

	If CurrentPhase == 0
		; Events during menstruation
		
		; Add chance of menstrual cramps
		If config.IsPregnant == False && Utility.RandomInt(1, 100) <= config.ChanceOfMenstrualCramps
			PlayerRef.AddSpell(ProcAbilityMenstrualCramps)
		EndIf
		
	ElseIf CurrentPhase == 10
		; Events during the follicular phase
		
		
	ElseIf CurrentPhase == 20
		; Events during ovulation
		
		
	ElseIf CurrentPhase == 30
		; Events during the luteal phase
		
		; Chance to apply PMS
		If config.IsPregnant == False && Utility.RandomInt(1, 100) <= config.ChanceOfPMS
			PlayerRef.AddSpell(ProCAbilityPMS)
		EndIf
		
	EndIf
	
EndFunction


;--------------------------------------------------
; Functions related to magic effects
;--------------------------------------------------

; This function removes all magic effects related to this mod.
Function RemoveAllAbilities(Actor person)
	
	; ----- Menstruation effects -----
	person.RemoveSpell(ProCAbilityPMS)
	person.RemoveSpell(ProcAbilityMenstrualCramps)
	
	; ----- Pregnancy effects -----
	person.RemoveSpell(ProCAbilityPregnancy1)
	person.RemoveSpell(ProCAbilityPregnancy2)
	person.RemoveSpell(ProCAbilityPregnancy3)
	
	; ----- Birth effects -----
	person.RemoveSpell(ProCAbilityPostBirthWeakness)
	
EndFunction




;--------------------------------------------------
; Functions related to Irregularities (e. g. menstruation happening slightly later or earlier than expected)
;--------------------------------------------------

Int Function DurationIrregularity(Int BaseDuration, Int MaxVariance, Int Chance, Int IncreaseOrDecrease = 0)
	
	Int random = Utility.RandomInt()
	Int Variance
	Int result
	
	MaxVariance = CalcMaxVariance(BaseDuration, MaxVariance)
	
	If random <= Chance
		
		Float VarianceMultiplier
		
		If IncreaseOrDecrease > 0
			VarianceMultiplier = Utility.RandomFloat(0, 1.0)
		ElseIf IncreaseOrDecrease < 0
			VarianceMultiplier = Utility.RandomFloat(-1.0, 0)
		Else
			VarianceMultiplier = Utility.RandomFloat(-1.0, 1.0)
		EndIf
		
		If VarianceMultiplier < 0.0
			Variance = Math.Floor(VarianceMultiplier*MaxVariance)
		Else
			Variance = Math.Ceiling(VarianceMultiplier*MaxVariance)
		EndIf
		
		result = BaseDuration+Variance
		
	Else
		result = BaseDuration
	EndIf
	
	If result < 1
		result = 1
	EndIf
	
	Return result
	
EndFunction


Int Function CalcMaxVariance(Int BaseDuration, Int MaxRelativeVariance)
	
	Int result = Math.Ceiling(BaseDuration*(MaxRelativeVariance/100.0))
	result = Math.Abs(result) as Int
	
	Return result
	
EndFunction
