ScriptName ProCConfigMCM extends SKI_ConfigBase

; ----- Internal MCM settings -----
Bool Property IsPregnant = False Auto


; ----- General settings -----
Bool Property EnableMessages = False Auto Hidden
Bool EnableMessagesDefault = False
String EnableMessagesText = "LOW"
Int OIDEnableMessages
String EnableMessagesDescription = "When set to LOW only 3 types of messages are sent: when someone is cuming in you, when you are menstruating and when you might be pregnant. These messages are always sent because, realistically, a woman knows for sure when these things are happening. If set to HIGH a lot of information about what the mod is doing will be sent. LOW is recommended for immersion."


; ----- Menstrual Cycle settings -----
Int Property ChanceOfPMS = 35 Auto Hidden
Int ChanceOfPMSDefault = 35
Int OIDChanceOfPMS
String ChanceOfPMSDescription = "Adjust the chance to apply the Pre-Menstrual Syndrom spell prior to menstruation."

Int Property ChanceOfMenstrualCramps = 35 Auto Hidden
Int ChanceOfMenstrualCrampsDefault = 35
Int OIDChanceOfMenstrualCramps
String ChanceOfMenstrualCrampsDescription = "The chance to apply the Menstrual Pains and Cramps spell during menstruation."


; ----- Contraception -----
Int Property ChanceToWashOut = 50 Auto Hidden
Int ChanceToWashOutDefault = 50
Int OIDChanceToWashOut
String ChanceToWashOutDescription = "The chance of successfully washing out sperm."

Float Property WashOutMaxAge = 4.0 Auto Hidden
Float WashOutMaxAgeDefault = 4.0
Int OIDWashOutMaxAge
String WashOutMaxAgeDescription = "Only sperm that was received within this number of hours can be washed out."


; ----- Pregnancy settings -----
Int Property ChanceToConceive = 35 Auto Hidden
Int ChanceToConceiveDefault = 35
Int OIDChanceToConceive
String ChanceToConceiveDescription = "The base chance to conceive if ovulating when sperm is present."

Int Property TwinsThreshold = 80 Auto Hidden
Int TwinsThresholdDefault = 80 ; SHOULD BE LINKED WITH TRIPLETSTHRESHOLD
Int OIDTwinsThreshold
String TwinsThresholdDescription = "When you conceive, a roll from 0 to 100 is made. If the roll is greater than this value you will have twins."

Int Property TripletsThreshold = 95 Auto Hidden
Int TripletsThresholdDefault = 95 ; SHOULD BE LINKED WITH TWINSTHRESHOLD
Int OIDTripletsThreshold
String TripletsThresholdDescription = "When you conceive, a roll from 0 to 100 is made. If the roll is greater than this value you will have triplets."

Int Property NormalPregMaxSize = 85 Auto Hidden
Int NormalPregMaxSizeDefault = 85 ; PREGSIZES DEFAULTS SHOULD BE LINKED
Int OIDNormalPregMaxSize
String NormalPregMaxSizeDescription = "Your weight is managed when pregnant. If you are pregnant with 1 child this is the highest weight your character will be set to at the end of pregnancy."

Int Property TwinsPregMaxSize = 92 Auto Hidden
Int TwinsPregMaxSizeDefault = 92 ; PREGSIZES DEFAULTS SHOULD BE LINKED
Int OIDTwinsPregMaxSize
String TwinsPregMaxSizeDescription = "Your weight is managed when pregnant. If you are pregnant with 2 children this is the highest weight your character will be set to at the end of pregnancy."

Int Property TripletsPregMaxSize = 100 Auto Hidden
Int TripletsPregMaxSizeDefault = 100 ; PREGSIZES DEFAULTS SHOULD BE LINKED
Int OIDTripletsPregMaxSize
String TripletsPregMaxSizeDescription = "Your weight is managed when pregnant. If you are pregnant with 3 children this is the highest weight your character will be set to at the end of pregnancy."


; ----- Belly size settings -----
Int Property VisualScalingType = 2 Auto Hidden ; 2 = Skeleton node scaling; 1 = Weight scaling; 0 = No scaling.
Int VisualScalingTypeDefault = 2
String VisualScalingTypeText = "Skeleton"
Int OIDVisualScalingType
String VisualScalingTypeDescription = "Set the method that should be used to change your characters appearance when pregnant. The methods available are: scaling the skeleton nodes, scaling the weight or no change at all. Note that you still need to set up your skeleton and meshes properly, or neither the skeleton nor weight scaling will work."

Float Property MaxScaleBelly = 6.0 Auto Hidden
Float MaxScaleBellyDefault = 6.0
Int OIDMaxScaleBelly
String MaxScaleBellyDescription = "Adjust the max belly scale. Note that the twin/triplets modifiers are still applied. (This setting is only applicable if you're using skeleton node scaling.)"

Float Property MaxScaleBreasts = 1.5 Auto Hidden
Float MaxScaleBreastsDefault = 1.5
Int OIDMaxScaleBreasts
String MaxScaleBreastsDescription = "Adjust the max breast scale. (This setting is only applicable if you're using skeleton node scaling.)"


; ----- Duration settings -----
Int Property SpermDuration = 4 Auto Hidden
Int SpermDurationDefault = 4
Int OIDSpermDuration
String SpermDurationDescription = "Change the duration that sperm survives in the womb. It is modified by race and irregularity settings, if those are enabled."

Int Property MenstruationDuration = 4 Auto Hidden
Int MenstruationDurationDefault = 4
Int OIDMenstruationDuration
String MenstruationDurationDescription = "Change the duration of the menstruation phase of the menstrual cycle. This does not change the duration of the other phases."

Int Property FollicularDuration = 4 Auto Hidden
Int FollicularDurationDefault = 4
Int OIDFollicularDuration
String FollicularDurationDescription = "Change the duration of the follicular phase."

Int Property OvulationDuration = 4 Auto Hidden
Int OvulationDurationDefault = 4
Int OIDOvulationDuration
String OvulationDurationDescription = "Change the duration of the ovulation phase."

Int Property LutealDuration = 4 Auto Hidden
Int LutealDurationDefault = 4
Int OIDLutealDuration
String LutealDurationDescription = "Change the duration of the luteal phase."

Int Property Trimester1BaseDuration = 24 Auto Hidden
Int Trimester1BaseDurationDefault = 24
Int OIDTrimester1BaseDuration
String Trimester1BaseDurationDescription = "Change the duration of the 1st trimester of pregnancy."

Int Property Trimester2BaseDuration = 36 Auto Hidden
Int Trimester2BaseDurationDefault = 36
Int OIDTrimester2BaseDuration
String Trimester2BaseDurationDescription = "Change the duration of the 2nd trimester of pregnancy."

Int Property Trimester3BaseDuration = 24 Auto Hidden
Int Trimester3BaseDurationDefault = 24
Int OIDTrimester3BaseDuration
String Trimester3BaseDurationDescription = "Change the duration of the 3rd trimester of pregnancy."


; ----- Racial Modifiers -----
Bool Property EnableRaceMultipliers = True Auto Hidden
Bool EnableRaceMultipliersDefault = True
Int OIDEnableRaceMultipliers
String EnableRaceMultipliersDescription = "If checked, race will play a significant role in deciding whether you conceive or not. Orcs will produce more sperm (which increases the chance to become pregnant) and elven sperm survives much longer than other race's. You are also more likely to become pregnant if you have sex with your own race - this is especially true for Khajiits and Argonians. The race modifiers stack with all other settings, so those are still important."


; ----- Irregularities -----
Int Property IrregularityChance = 10 Auto Hidden ; The chance that an irregularity will occur. 0 = completely regular. 100 = completely irregular.
Int IrregularityChanceDefault = 10
Int OIDIrregularityChance
String IrregularityChanceDescription = "If this is greater than 0% the duration of various things will occasionally vary. This setting only sets the chance that an irregularity will occur, not how severe the irregularity might be."

Int Property RelativeMesntruationPhaseVariance = 10 Auto Hidden ; The maximum relative variance. If the menstrual phase duration is 10, and the max variance is 20, can the duration vary from 8 to 12 days.
Int RelativeMesntruationPhaseVarianceDefault = 10
Int OIDRelativeMesntruationPhaseVariance
String RelativeMesntruationPhaseVarianceDescription = "This setting determines the severity that the a menstrual phase's duration may vary. If it is greater than 0%, the minimum variation is atleast one day."

Int Property RelativePregnancyPhaseVariance = 5 Auto Hidden ; The maximum relative variance of the pregnancy phase durations.
Int RelativePregnancyPhaseVarianceDefault = 5
Int OIDRelativePregnancyPhaseVariance
String RelativePregnancyPhaseVarianceDescription = "Change how severely an irregularity affects the duration of the pregnancy phases. If it is greater than 0%, the minimum variation is atleast one day."

Int Property RelativePregnancyDelayVariance = 50 Auto Hidden ; The maximum relative variance of the delay from conception to actual pregnancy start.
Int RelativePregnancyDelayVarianceDefault = 50
Int OIDRelativePregnancyDelayVariance
String RelativePregnancyDelayVarianceDescription = "This sets the delay variance from conception untill pregnancy starts. With no irregularity, the delay will be such that you will miss your next period. This setting might randomly increase that delay (but not reduce it)."

Int Property PostBirthNormalizationVariance = 200 Auto Hidden ; The maximum relative variance of the time from birth untill normal menstruation is resumed.
Int PostBirthNormalizationVarianceDefault = 200
Int OIDPostBirthNormalizationVariance
String PostBirthNormalizationVarianceDescription = "This sets how much the delay from birth untill normal menstruation is resumed may vary. It will atleast be the duration of the luteal and the menstruation phases combined."

Int Property RelativeSpermDurationVariance = 50  Auto Hidden ; The maximum relative variance of the duration sperm survives in the womb.
Int RelativeSpermDurationVarianceDefault = 50
Int OIDRelativeSpermDurationVariance
String RelativeSpermDurationVarianceDescription = "The duration that sperm survives in the womb may vary by this much."




; ----- Race multiplier arrays -----

Bool IsRaceIndexSet = False
Race[] Property RaceIndex Auto Hidden; Race index
Float[] Property SameRaceConceiveMultiplier Auto Hidden ; Increases the chance of conception by the specified amount, if the mother and potential father are the same sex.
Float[] Property FatherRaceSpermMultiplier Auto Hidden ; Multiplicative chance of race becoming father. Indexes should match with RaceIndex array.
Float[] Property MotherRaceConceiveMultiplier Auto Hidden ; Multiplicative chance of becoming pregnant, depending on the race of the mother.
Float[] Property SpermDurationByRace Auto Hidden ; Adjusts the duration of sperm based on races.
Int[] Property TwinsRaceThresholds Auto Hidden ; Adjusts chance of getting twins or triplets.
Int[] Property TripletsRaceThresholds Auto Hidden ; Adjusts chance of getting twins or triplets.


; Sets up the race index array itself. This is used to link the other arrays to specific races. (If multidimension arrays were possible, this bullshit wouldn't be necessary.)
Function SetRaceIndex()
	
	RaceIndex = New Race[20]
	RaceIndex[0] = Race.GetRace("ArgonianRace")
	RaceIndex[1] = Race.GetRace("ArgonianRaceVampire")
	RaceIndex[2] = Race.GetRace("BretonRace")
	RaceIndex[3] = Race.GetRace("BretonRaceVampire")
	RaceIndex[4] = Race.GetRace("DarkElfRace")
	RaceIndex[5] = Race.GetRace("DarkElfRaceVampire")
	RaceIndex[6] = Race.GetRace("HighElfRace")
	RaceIndex[7] = Race.GetRace("HighElfRaceVampire")
	RaceIndex[8] = Race.GetRace("ImperialRace")
	RaceIndex[9] = Race.GetRace("ImperialRaceVampire")
	RaceIndex[10] = Race.GetRace("KhajiitRace")
	RaceIndex[11] = Race.GetRace("KhajiitRaceVampire")
	RaceIndex[12] = Race.GetRace("NordRace")
	RaceIndex[13] = Race.GetRace("NordRaceVampire")
	RaceIndex[14] = Race.GetRace("OrcRace")
	RaceIndex[15] = Race.GetRace("OrcRaceVampire")
	RaceIndex[16] = Race.GetRace("RedguardRace")
	RaceIndex[17] = Race.GetRace("RedguardRaceVampire")
	RaceIndex[18] = Race.GetRace("WoodElfRace")
	RaceIndex[19] = Race.GetRace("WoodElfRaceVampire")
	
EndFunction


; Sets the rates at which the chance of the father being a particular race, if multiple sperm is present.
; A random roll is made for each sperm (in the PickFather function). The roll is multiplied by the corrosponding number in this list. The highest roll (after modification) is the father.
Function SetFatherSpermMultipliers()
	
	FatherRaceSpermMultiplier = New Float[20]
	FatherRaceSpermMultiplier[0] = 0.5 ; Argonian
	FatherRaceSpermMultiplier[1] = 0.5 ; ArgonianVampire
	FatherRaceSpermMultiplier[2] = 1.0 ; BretonRace
	FatherRaceSpermMultiplier[3] = 1.0 ; BretonRaceVampire
	FatherRaceSpermMultiplier[4] = 0.9 ; DarkElfRace
	FatherRaceSpermMultiplier[5] = 0.9 ; DarkElfRaceVampire
	FatherRaceSpermMultiplier[6] = 0.9 ; HighElfRace
	FatherRaceSpermMultiplier[7] = 0.9 ; HighElfRaceVampire
	FatherRaceSpermMultiplier[8] = 1.0 ; ImperialRace
	FatherRaceSpermMultiplier[9] = 1.0 ; ImperialRaceVampire
	FatherRaceSpermMultiplier[10] = 0.5 ; KhajiitRace
	FatherRaceSpermMultiplier[11] = 0.5 ; KhajiitRaceVampire
	FatherRaceSpermMultiplier[12] = 1.05 ; NordRace
	FatherRaceSpermMultiplier[13] = 1.05 ; NordRaceVampire
	FatherRaceSpermMultiplier[14] = 1.2 ; OrcRace
	FatherRaceSpermMultiplier[15] = 1.2 ; OrcRaceVampire
	FatherRaceSpermMultiplier[16] = 1.0 ; RedguardRace
	FatherRaceSpermMultiplier[17] = 1.0 ; RedguardRaceVampire
	FatherRaceSpermMultiplier[18] = 0.9 ; WoodElfRace
	FatherRaceSpermMultiplier[19] = 0.9 ; WoodElfRaceVampire
	
EndFunction


; Multiplier to the chance to conceive, based on race (might make completely seperate pregnancy systems for different races later, e.g. Khajiits and Argonians... far down the line).
Function SetChanceToConceiveMultipliers()
	
	MotherRaceConceiveMultiplier = New Float[20]
	MotherRaceConceiveMultiplier[0] = 0.25 ; Argonian
	MotherRaceConceiveMultiplier[1] = 0.25 ; ArgonianVampire
	MotherRaceConceiveMultiplier[2] = 1.0 ; BretonRace
	MotherRaceConceiveMultiplier[3] = 1.0 ; BretonRaceVampire
	MotherRaceConceiveMultiplier[4] = 1.1 ; DarkElfRace
	MotherRaceConceiveMultiplier[5] = 1.1 ; DarkElfRaceVampire
	MotherRaceConceiveMultiplier[6] = 1.1 ; HighElfRace
	MotherRaceConceiveMultiplier[7] = 1.1 ; HighElfRaceVampire
	MotherRaceConceiveMultiplier[8] = 1.0 ; ImperialRace
	MotherRaceConceiveMultiplier[9] = 1.0 ; ImperialRaceVampire
	MotherRaceConceiveMultiplier[10] = 0.25 ; KhajiitRace
	MotherRaceConceiveMultiplier[11] = 0.25 ; KhajiitRaceVampire
	MotherRaceConceiveMultiplier[12] = 1.0 ; NordRace
	MotherRaceConceiveMultiplier[13] = 1.0 ; NordRaceVampire
	MotherRaceConceiveMultiplier[14] = 0.8 ; OrcRace
	MotherRaceConceiveMultiplier[15] = 0.8 ; OrcRaceVampire
	MotherRaceConceiveMultiplier[16] = 1.0 ; RedguardRace
	MotherRaceConceiveMultiplier[17] = 1.0 ; RedguardRaceVampire
	MotherRaceConceiveMultiplier[18] = 1.1 ; WoodElfRace
	MotherRaceConceiveMultiplier[19] = 1.1 ; WoodElfRaceVampire
	
EndFunction

; Multiplier to the chance to conceive, if the mother and father races are naturally able to have children.
Function SetSameRaceConceiveMultiplier()
	
	SameRaceConceiveMultiplier = New Float[20]
	SameRaceConceiveMultiplier[0] = 4.0 ; Argonian
	SameRaceConceiveMultiplier[1] = 4.0 ; ArgonianVampire
	SameRaceConceiveMultiplier[2] = 1.2 ; BretonRace
	SameRaceConceiveMultiplier[3] = 1.2 ; BretonRaceVampire
	SameRaceConceiveMultiplier[4] = 1.2 ; DarkElfRace
	SameRaceConceiveMultiplier[5] = 1.2 ; DarkElfRaceVampire
	SameRaceConceiveMultiplier[6] = 1.2 ; HighElfRace
	SameRaceConceiveMultiplier[7] = 1.2 ; HighElfRaceVampire
	SameRaceConceiveMultiplier[8] = 1.2 ; ImperialRace
	SameRaceConceiveMultiplier[9] = 1.2 ; ImperialRaceVampire
	SameRaceConceiveMultiplier[10] = 4.0 ; KhajiitRace
	SameRaceConceiveMultiplier[11] = 4.0 ; KhajiitRaceVampire
	SameRaceConceiveMultiplier[12] = 1.2 ; NordRace
	SameRaceConceiveMultiplier[13] = 1.2 ; NordRaceVampire
	SameRaceConceiveMultiplier[14] = 1.6 ; OrcRace
	SameRaceConceiveMultiplier[15] = 1.6 ; OrcRaceVampire
	SameRaceConceiveMultiplier[16] = 1.2 ; RedguardRace
	SameRaceConceiveMultiplier[17] = 1.2 ; RedguardRaceVampire
	SameRaceConceiveMultiplier[18] = 1.2 ; WoodElfRace
	SameRaceConceiveMultiplier[19] = 1.2 ; WoodElfRaceVampire
	
EndFunction

; Sets the survival duration of sperm based on race.
Function SetSpermDurationByRace()
	
	SpermDurationByRace = New Float[20]
	SpermDurationByRace[0] = 0.5 ; Argonian
	SpermDurationByRace[1] = 0.5 ; ArgonianVampire
	SpermDurationByRace[2] = 1.0 ; BretonRace
	SpermDurationByRace[3] = 1.0 ; BretonRaceVampire
	SpermDurationByRace[4] = 4.0 ; DarkElfRace
	SpermDurationByRace[5] = 4.0 ; DarkElfRaceVampire
	SpermDurationByRace[6] = 4.0 ; HighElfRace
	SpermDurationByRace[7] = 4.0 ; HighElfRaceVampire
	SpermDurationByRace[8] = 1.0 ; ImperialRace
	SpermDurationByRace[9] = 1.0 ; ImperialRaceVampire
	SpermDurationByRace[10] = 0.5 ; KhajiitRace
	SpermDurationByRace[11] = 0.5 ; KhajiitRaceVampire
	SpermDurationByRace[12] = 1.0 ; NordRace
	SpermDurationByRace[13] = 1.0 ; NordRaceVampire
	SpermDurationByRace[14] = 1.25 ; OrcRace
	SpermDurationByRace[15] = 1.25 ; OrcRaceVampire
	SpermDurationByRace[16] = 1.0 ; RedguardRace
	SpermDurationByRace[17] = 1.0 ; RedguardRaceVampire
	SpermDurationByRace[18] = 4.0 ; WoodElfRace
	SpermDurationByRace[19] = 4.0 ; WoodElfRaceVampire
	
EndFunction

; Sets the twins and triplets thresholds
Function SetTwinsRaceThresholds()
	
	TwinsRaceThresholds = New Int[20]
	TwinsRaceThresholds[0] = 5 ; Argonian
	TwinsRaceThresholds[1] = 5 ; ArgonianVampire
	TwinsRaceThresholds[2] = 80 ; BretonRace
	TwinsRaceThresholds[3] = 80 ; BretonRaceVampire
	TwinsRaceThresholds[4] = 95 ; DarkElfRace
	TwinsRaceThresholds[5] = 95 ; DarkElfRaceVampire
	TwinsRaceThresholds[6] = 95 ; HighElfRace
	TwinsRaceThresholds[7] = 95 ; HighElfRaceVampire
	TwinsRaceThresholds[8] = 80 ; ImperialRace
	TwinsRaceThresholds[9] = 80 ; ImperialRaceVampire
	TwinsRaceThresholds[10] = 5 ; KhajiitRace
	TwinsRaceThresholds[11] = 5 ; KhajiitRaceVampire
	TwinsRaceThresholds[12] = 80 ; NordRace
	TwinsRaceThresholds[13] = 80 ; NordRaceVampire
	TwinsRaceThresholds[14] = 65 ; OrcRace
	TwinsRaceThresholds[15] = 65 ; OrcRaceVampire
	TwinsRaceThresholds[16] = 80 ; RedguardRace
	TwinsRaceThresholds[17] = 80 ; RedguardRaceVampire
	TwinsRaceThresholds[18] = 95 ; WoodElfRace
	TwinsRaceThresholds[19] = 95 ; WoodElfRaceVampire
	
EndFunction

; Sets the twins and triplets thresholds
Function SetTripletsRaceThresholds()
	
	TripletsRaceThresholds = New Int[20]
	TripletsRaceThresholds[0] = 50 ; Argonian
	TripletsRaceThresholds[1] = 50 ; ArgonianVampire
	TripletsRaceThresholds[2] = 95 ; BretonRace
	TripletsRaceThresholds[3] = 95 ; BretonRaceVampire
	TripletsRaceThresholds[4] = 99 ; DarkElfRace
	TripletsRaceThresholds[5] = 99 ; DarkElfRaceVampire
	TripletsRaceThresholds[6] = 99 ; HighElfRace
	TripletsRaceThresholds[7] = 99 ; HighElfRaceVampire
	TripletsRaceThresholds[8] = 95 ; ImperialRace
	TripletsRaceThresholds[9] = 95 ; ImperialRaceVampire
	TripletsRaceThresholds[10] = 50 ; KhajiitRace
	TripletsRaceThresholds[11] = 50 ; KhajiitRaceVampire
	TripletsRaceThresholds[12] = 95 ; NordRace
	TripletsRaceThresholds[13] = 95 ; NordRaceVampire
	TripletsRaceThresholds[14] = 85 ; OrcRace
	TripletsRaceThresholds[15] = 85 ; OrcRaceVampire
	TripletsRaceThresholds[16] = 95 ; RedguardRace
	TripletsRaceThresholds[17] = 95 ; RedguardRaceVampire
	TripletsRaceThresholds[18] = 99 ; WoodElfRace
	TripletsRaceThresholds[19] = 99 ; WoodElfRaceVampire
	
EndFunction

; Contains all default settings.
Function SetRaceIndexes() 
	
	IsRaceIndexSet = True
	SetSameRaceConceiveMultiplier()
	SetRaceIndex()
	SetFatherSpermMultipliers()
	SetChanceToConceiveMultipliers()
	SetTwinsRaceThresholds()
	SetTripletsRaceThresholds()
	SetSpermDurationByRace()
	
EndFunction


; Matches a specific race to the index, and returns the index - can be used to access properties in other tables from a known race
Int Function GetRaceIndex(Race IndexRace)
	
	Int i = RaceIndex.Length
	While i > 0
		i -= 1
		If IndexRace == RaceIndex[i]
			Return i
		EndIf
	EndWhile
	
	Return 8 ; Returns the imperial race index, if the race didn't match any others
	
EndFunction




Event OnConfigInit()
	
	; Sets all the race modifer arrays
	SetRaceIndexes()
	
	Pages = new string[5]
	Pages[0] = "General Settings"
	Pages[1] = "Menstrual Cycle & Conception"
	Pages[2] = "Pregnancy"
	Pages[3] = "Racial Modifiers"
	Pages[4] = "Irregularities"
EndEvent

Event OnPageReset(string page)
	{Called when a new page is selected, including the initial empty page}
	
	If page == "General Settings"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("Messages")
		OIDEnableMessages = AddTextOption("Information level", EnableMessagesText)
		
		
	ElseIf page == "Menstrual Cycle & Conception"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("The menstrual cycle")
		OIDMenstruationDuration = AddSliderOption("Menstruation duration", MenstruationDuration, "{0} days")
		OIDFollicularDuration = AddSliderOption("Follicular phase duration", FollicularDuration, "{0} days")
		OIDOvulationDuration = AddSliderOption("Ovulation duration", OvulationDuration, "{0} days")
		OIDLutealDuration = AddSliderOption("Luteal phase duration", LutealDuration, "{0} days")
		
		AddHeaderOption("Menstruation spells")
		AddTextOption("The roll to apply these spells is made once per day", "", OPTION_FLAG_DISABLED)
		AddTextOption("during the appropriate phase. Take that into", "", OPTION_FLAG_DISABLED)
		AddTextOption("account when adjusting the chances.", "", OPTION_FLAG_DISABLED)
		OIDChanceOfPMS = AddSliderOption("Chance to get PMS", ChanceOfPMS, "{0}%")
		OIDChanceOfMenstrualCramps = AddSliderOption("Chance to get menstrual cramps", ChanceOfMenstrualCramps, "{0}%")
		
		
		SetCursorPosition(1)
		
		AddHeaderOption("Conception and sperm")
		AddTextOption("The roll to conceive is made once per day when", "", OPTION_FLAG_DISABLED)
		AddTextOption("ovulating. Take that into account when adjusting", "", OPTION_FLAG_DISABLED)
		AddTextOption("the chance.", "", OPTION_FLAG_DISABLED)
		OIDChanceToConceive = AddSliderOption("Chance to conceive", ChanceToConceive, "{0}%")
		OIDSpermDuration = AddSliderOption("Sperm duration", SpermDuration, "{0} days")
		
		AddHeaderOption("Wash Out Sperm (spell)")
		OIDChanceToWashOut = AddSliderOption("Success rate", ChanceToWashOut, "{0}%")
		OIDWashOutMaxAge = AddSliderOption("Max age", WashOutMaxAge, "{2} hours")
		
		
	ElseIf page == "Pregnancy"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
			
		; Checks if pregnant to disable/enable certain options
		If IsPregnant == True
			
			AddHeaderOption("You might be pregnant")
			AddTextOption("The pregnancy options are locked because", "", OPTION_FLAG_DISABLED)
			AddTextOption("you might be pregnant.", "", OPTION_FLAG_DISABLED)
		
		Else
		
			SetCursorPosition(0)
			
			AddHeaderOption("Pregnancy duration")
			OIDTrimester1BaseDuration = AddSliderOption("Duration of the 1st trimester", Trimester1BaseDuration, "{0} days")
			OIDTrimester2BaseDuration = AddSliderOption("Duration of the 2nd trimester", Trimester2BaseDuration, "{0} days")
			OIDTrimester3BaseDuration = AddSliderOption("Duration of the 3rd trimester", Trimester3BaseDuration, "{0} days")
			
			AddHeaderOption("Chance to get twins or triplets")
			OIDTwinsThreshold = AddSliderOption("Twins threshold", TwinsThreshold, "{0}")
			OIDTripletsThreshold = AddSliderOption("Triplets threshold", TripletsThreshold, "{0}")
			
			
			SetCursorPosition(1)
			
			AddHeaderOption("Visual scaling method")
			OIDVisualScalingType = AddTextOption("Visual scaling type", VisualScalingTypeText)
			
			AddHeaderOption("Node scaling")
			OIDMaxScaleBelly = AddSliderOption("Belly max scale", MaxScaleBelly, "{1}")
			OIDMaxScaleBreasts = AddSliderOption("Breasts max scale", MaxScaleBreasts, "{2}")
			
			AddHeaderOption("Belly size during pregnancy")
			OIDNormalPregMaxSize = AddSliderOption("Normal belly size", NormalPregMaxSize, "{0}%")
			OIDTwinsPregMaxSize = AddSliderOption("Twins belly size", TwinsPregMaxSize, "{0}%")
			OIDTripletsPregMaxSize = AddSliderOption("Triplets belly size", TripletsPregMaxSize, "{0}%")
		
		EndIf
		
		
		
	ElseIf page == "Racial Modifiers"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("Racial multipliers")
		OIDEnableRaceMultipliers = AddToggleOption("Enable racial multipliers", EnableRaceMultipliers)
		
		
		
	ElseIf page == "Irregularities"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("The base irregularity chance")
		OIDIrregularityChance = AddSliderOption("The chance of an irregularity", IrregularityChance, "{0}%")
		
		SetCursorPosition(1)
		
		AddHeaderOption("The maximum severity of the irregularities")
		OIDRelativeMesntruationPhaseVariance = AddSliderOption("Menstruation phase variance", RelativeMesntruationPhaseVariance, "{0}%")
		OIDRelativeSpermDurationVariance = AddSliderOption("Sperm duration variance", RelativeSpermDurationVariance, "{0}%")
		OIDRelativePregnancyPhaseVariance = AddSliderOption("Pregnancy phase variance", RelativePregnancyPhaseVariance, "{0}%")
		OIDRelativePregnancyDelayVariance = AddSliderOption("Pregnancy delay variance", RelativePregnancyDelayVariance, "{0}%")
		OIDPostBirthNormalizationVariance = AddSliderOption("Post-birth normalization variance", PostBirthNormalizationVariance, "{0}%")
		
	Else
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("Welcome to Procreation")
		AddTextOption("Female reproduction 101:", "", OPTION_FLAG_DISABLED)
		AddTextOption("A womans menstrual cycle consists of 4 phases:", "", OPTION_FLAG_DISABLED)
		AddTextOption("  - menstruation", "", OPTION_FLAG_DISABLED)
		AddTextOption("  - the follicular phase", "", OPTION_FLAG_DISABLED)
		AddTextOption("  - ovulation", "", OPTION_FLAG_DISABLED)
		AddTextOption("  - the luteal phase.", "", OPTION_FLAG_DISABLED)
		AddTextOption("Women are only fertile when ovulating.", "", OPTION_FLAG_DISABLED)
		AddTextOption("This is important to remember, if you want to", "", OPTION_FLAG_DISABLED)
		AddTextOption("become pregnant - or avoid it!", "", OPTION_FLAG_DISABLED)
		
		
		SetCursorPosition(1)
		AddHeaderOption("Other notes:")
		AddTextOption("When you become pregnant the pregnancy settings", "", OPTION_FLAG_DISABLED)
		AddTextOption("will be locked untill you are no longer pregnant.", "", OPTION_FLAG_DISABLED)
		
	EndIf
	
EndEvent




Event OnOptionSliderAccept(int option, float floatValue)
	
	int value = floatValue as int
	
	; Menstrual Cycle settings
	
	If option == OIDChanceOfPMS
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		ChanceOfPMS = value
		
	ElseIf option == OIDChanceOfMenstrualCramps
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		ChanceOfMenstrualCramps = value
		
		
	; Contraception settings
	
	ElseIf option == OIDChanceToWashOut
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		ChanceToWashOut = value
		
	ElseIf option == OIDWashOutMaxAge
		
		SetSliderOptionValue(option, floatValue, "{2} hours")
		WashOutMaxAge = floatValue
		
		
		
	; Pregnancy settings
	
	ElseIf option == OIDChanceToConceive
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		ChanceToConceive = value
		
	ElseIf option == OIDTwinsThreshold
		
		SetSliderOptionValue(option, floatValue, "{0}")
		TwinsThreshold = value
		
	ElseIf option == OIDTripletsThreshold
		
		SetSliderOptionValue(option, floatValue, "{0}")
		TripletsThreshold = value
		
	ElseIf option == OIDNormalPregMaxSize
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		NormalPregMaxSize = value
		
	ElseIf option == OIDTwinsPregMaxSize
		
		SetSliderOptionValue(option, floatValue,"{0}%")
		TwinsPregMaxSize = value
		
	ElseIf option == OIDTripletsPregMaxSize
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		TripletsPregMaxSize = value
		
		
	; Belly size settings
	
	ElseIf option == OIDMaxScaleBelly
		
		SetSliderOptionValue(option, floatValue,"{1}")
		MaxScaleBelly = value
		
	ElseIf option == OIDMaxScaleBreasts
		
		SetSliderOptionValue(option, floatValue, "{1}")
		MaxScaleBreasts = value
		
		
	; Duration settings
		
	ElseIf option == OIDSpermDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		SpermDuration = value
		
	ElseIf option == OIDMenstruationDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		MenstruationDuration = value
		
	ElseIf option == OIDFollicularDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		FollicularDuration = value
		
	ElseIf option == OIDOvulationDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		OvulationDuration = value
		
	ElseIf option == OIDLutealDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		LutealDuration = value
		
	ElseIf option == OIDTrimester1BaseDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		Trimester1BaseDuration = value
		
	ElseIf option == OIDTrimester2BaseDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		Trimester2BaseDuration = value
		
	ElseIf option == OIDTrimester3BaseDuration
		
		SetSliderOptionValue(option, floatValue, "{0} days")
		Trimester3BaseDuration = value
		
		
		
	; Irregularities
		
	ElseIf option == OIDIrregularityChance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		IrregularityChance = value
		
	ElseIf option == OIDRelativeMesntruationPhaseVariance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		RelativeMesntruationPhaseVariance = value
		
	ElseIf option == OIDRelativePregnancyPhaseVariance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		RelativePregnancyPhaseVariance = value
		
	ElseIf option == OIDRelativePregnancyDelayVariance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		RelativePregnancyDelayVariance = value
		
	ElseIf option == OIDPostBirthNormalizationVariance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		PostBirthNormalizationVariance = value
		
	ElseIf option == OIDRelativeSpermDurationVariance
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		RelativeSpermDurationVariance = value
		
	EndIf
	
EndEvent



Event OnOptionSliderOpen(int option)
	
	
	; Menstrual Cycle settings
	
	If option == OIDChanceOfPMS
		
		SetSliderDialogStartValue(ChanceOfPMS)
		SetSliderDialogDefaultValue(ChanceOfPMSDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDChanceOfMenstrualCramps
		
		SetSliderDialogStartValue(ChanceOfMenstrualCramps)
		SetSliderDialogDefaultValue(ChanceOfMenstrualCrampsDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
		
		
	; Contraception settings
	
	ElseIf option == OIDChanceToWashOut
		
		SetSliderDialogStartValue(ChanceToWashOut)
		SetSliderDialogDefaultValue(ChanceToWashOutDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDWashOutMaxAge
		
		SetSliderDialogStartValue(WashOutMaxAge)
		SetSliderDialogDefaultValue(WashOutMaxAgeDefault)
		SetSliderDialogRange(1, 72)
		SetSliderDialogInterval(0.25)
		
		
		
	; Pregnancy settings
	
	ElseIf option == OIDChanceToConceive
		
		SetSliderDialogStartValue(ChanceToConceive)
		SetSliderDialogDefaultValue(ChanceToConceiveDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTwinsThreshold
		
		SetSliderDialogStartValue(TwinsThreshold)
		SetSliderDialogDefaultValue(TwinsThresholdDefault)
		SetSliderDialogRange(0, TripletsThreshold)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTripletsThreshold
		
		SetSliderDialogStartValue(TripletsThreshold)
		SetSliderDialogDefaultValue(TripletsThresholdDefault)
		SetSliderDialogRange(TwinsThreshold, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDNormalPregMaxSize
		
		SetSliderDialogStartValue(NormalPregMaxSize)
		SetSliderDialogDefaultValue(NormalPregMaxSizeDefault)
		SetSliderDialogRange(0, TwinsPregMaxSize)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTwinsPregMaxSize
		
		SetSliderDialogStartValue(TwinsPregMaxSize)
		SetSliderDialogDefaultValue(TwinsPregMaxSizeDefault)
		SetSliderDialogRange(NormalPregMaxSize, TripletsPregMaxSize)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTripletsPregMaxSize
		
		SetSliderDialogStartValue(TripletsPregMaxSize)
		SetSliderDialogDefaultValue(TripletsPregMaxSizeDefault)
		SetSliderDialogRange(TwinsPregMaxSize, 100)
		SetSliderDialogInterval(1)
		
		
	; Belly size settings
	
	ElseIf option == OIDMaxScaleBelly
		
		SetSliderDialogStartValue(MaxScaleBelly)
		SetSliderDialogDefaultValue(MaxScaleBellyDefault)
		SetSliderDialogRange(1, 8)
		SetSliderDialogInterval(0.5)
		
	ElseIf option == OIDMaxScaleBreasts
		
		SetSliderDialogStartValue(MaxScaleBreasts)
		SetSliderDialogDefaultValue(MaxScaleBreastsDefault)
		SetSliderDialogRange(1, 3)
		SetSliderDialogInterval(0.25)
		
		
	
	; Duration settings
	
	ElseIf option == OIDSpermDuration
		
		SetSliderDialogStartValue(SpermDuration)
		SetSliderDialogDefaultValue(SpermDurationDefault)
		SetSliderDialogRange(1, 10)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDMenstruationDuration
		
		SetSliderDialogStartValue(MenstruationDuration)
		SetSliderDialogDefaultValue(MenstruationDurationDefault)
		SetSliderDialogRange(1, 20)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDFollicularDuration
		
		SetSliderDialogStartValue(FollicularDuration)
		SetSliderDialogDefaultValue(FollicularDurationDefault)
		SetSliderDialogRange(1, 20)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDOvulationDuration
		
		SetSliderDialogStartValue(OvulationDuration)
		SetSliderDialogDefaultValue(OvulationDurationDefault)
		SetSliderDialogRange(1, 20)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDLutealDuration
		
		SetSliderDialogStartValue(LutealDuration)
		SetSliderDialogDefaultValue(LutealDurationDefault)
		SetSliderDialogRange(1, 20)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTrimester1BaseDuration
		
		SetSliderDialogStartValue(Trimester1BaseDuration)
		SetSliderDialogDefaultValue(Trimester1BaseDurationDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTrimester2BaseDuration
		
		SetSliderDialogStartValue(Trimester2BaseDuration)
		SetSliderDialogDefaultValue(Trimester2BaseDurationDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDTrimester3BaseDuration
		
		SetSliderDialogStartValue(Trimester3BaseDuration)
		SetSliderDialogDefaultValue(Trimester3BaseDurationDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
		
		
		
	; Irregularities
	
	ElseIf option == OIDIrregularityChance
		
		SetSliderDialogStartValue(IrregularityChance)
		SetSliderDialogDefaultValue(IrregularityChanceDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDRelativeMesntruationPhaseVariance
		
		SetSliderDialogStartValue(RelativeMesntruationPhaseVariance)
		SetSliderDialogDefaultValue(RelativeMesntruationPhaseVarianceDefault)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDRelativePregnancyPhaseVariance
		
		SetSliderDialogStartValue(RelativePregnancyPhaseVariance)
		SetSliderDialogDefaultValue(RelativePregnancyPhaseVarianceDefault)
		SetSliderDialogRange(0, 90)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDRelativePregnancyDelayVariance
		
		SetSliderDialogStartValue(RelativePregnancyDelayVariance)
		SetSliderDialogDefaultValue(RelativePregnancyDelayVarianceDefault)
		SetSliderDialogRange(10, 100)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDPostBirthNormalizationVariance
		
		SetSliderDialogStartValue(PostBirthNormalizationVariance)
		SetSliderDialogDefaultValue(PostBirthNormalizationVarianceDefault)
		SetSliderDialogRange(0, 500)
		SetSliderDialogInterval(1)
		
	ElseIf option == OIDRelativeSpermDurationVariance
		
		SetSliderDialogStartValue(RelativeSpermDurationVariance)
		SetSliderDialogDefaultValue(RelativeSpermDurationVarianceDefault)
		SetSliderDialogRange(0, 99)
		SetSliderDialogInterval(1)
		
	EndIf
	
EndEvent



Event OnOptionSelect(int option)
	{Called when a non-interactive option has been selected}
	
	; General settings
	If option == OIDEnableMessages
	
		EnableMessages = !EnableMessages
		If EnableMessages == True
			EnableMessagesText = "HIGH"
		Else
			EnableMessagesText = "LOW"
		EndIf
		
		SetTextOptionValue(option, EnableMessagesText)
		
		
	; Racial Modifiers
	ElseIf option == OIDEnableRaceMultipliers
		
		EnableRaceMultipliers = !EnableRaceMultipliers
		SetToggleOptionValue(option, EnableRaceMultipliers)
		
		
	; Belly size settings
	ElseIf option == OIDVisualScalingType
		
		If VisualScalingType == 0
			VisualScalingType = 1
			VisualScalingTypeText = "Weight"
		ElseIf VisualScalingType == 1
			VisualScalingType = 2
			VisualScalingTypeText = "Skeleton"
		Else
			VisualScalingType = 0
			VisualScalingTypeText = "None"
		EndIf
		
		SetTextOptionValue(option, VisualScalingTypeText)
		
	EndIf
	
EndEvent


Event OnOptionDefault(int option)
	{Called when a non-interactive option has been selected}
	
	
	; Menstrual Cycle settings
	
	If option == OIDChanceOfPMS
		
		SetSliderOptionValue(option, ChanceOfPMSDefault as Float, "{0}%")
		ChanceOfPMS = ChanceOfPMSDefault
		
	ElseIf option == OIDChanceOfMenstrualCramps
		
		SetSliderOptionValue(option, ChanceOfMenstrualCrampsDefault as Float, "{0}%")
		ChanceOfMenstrualCramps = ChanceOfMenstrualCrampsDefault
		
		
	; Contraception settings
	
	ElseIf option == OIDChanceToWashOut
		
		SetSliderOptionValue(option, ChanceToWashOutDefault as Float, "{0}%")
		ChanceToWashOut = ChanceToWashOutDefault
		
	ElseIf option == OIDWashOutMaxAge
		
		SetSliderOptionValue(option, WashOutMaxAgeDefault, "{2} hours")
		WashOutMaxAge = WashOutMaxAgeDefault
		
		
	; Pregnancy settings
	
	ElseIf option == OIDChanceToConceive
		
		SetSliderOptionValue(option, ChanceToConceiveDefault as Float, "{0}%")
		ChanceToConceive = ChanceToConceiveDefault
		
	ElseIf option == OIDTwinsThreshold
		
		SetSliderOptionValue(option, TwinsThresholdDefault as Float, "{0}")
		TwinsThreshold = TwinsThresholdDefault
		
	ElseIf option == OIDTripletsThreshold
		
		SetSliderOptionValue(option, TripletsThresholdDefault as Float, "{0}")
		TripletsThreshold = TripletsThresholdDefault
		
	ElseIf option == OIDNormalPregMaxSize
		
		SetSliderOptionValue(option, NormalPregMaxSizeDefault as Float, "{0}%")
		NormalPregMaxSize = NormalPregMaxSizeDefault
		
	ElseIf option == OIDTwinsPregMaxSize
		
		SetSliderOptionValue(option, TwinsPregMaxSizeDefault as Float,"{0}%")
		TwinsPregMaxSize = TwinsPregMaxSizeDefault
		
	ElseIf option == OIDTripletsPregMaxSize
		
		SetSliderOptionValue(option, TripletsPregMaxSizeDefault as Float, "{0}%")
		TripletsPregMaxSize = TripletsPregMaxSizeDefault
		
		
		
	; Duration settings
		
	ElseIf option == OIDSpermDuration
		
		SetSliderOptionValue(option, SpermDurationDefault as Float, "{0} days")
		SpermDuration = SpermDurationDefault
		
	ElseIf option == OIDMenstruationDuration
		
		SetSliderOptionValue(option, MenstruationDurationDefault as Float, "{0} days")
		MenstruationDuration = MenstruationDurationDefault
		
	ElseIf option == OIDFollicularDuration
		
		SetSliderOptionValue(option, FollicularDurationDefault as Float, "{0} days")
		FollicularDuration = FollicularDurationDefault
		
	ElseIf option == OIDOvulationDuration
		
		SetSliderOptionValue(option, OvulationDurationDefault as Float, "{0} days")
		OvulationDuration = OvulationDurationDefault
		
	ElseIf option == OIDLutealDuration
		
		SetSliderOptionValue(option, LutealDurationDefault as Float, "{0} days")
		LutealDuration = LutealDurationDefault
		
	ElseIf option == OIDTrimester1BaseDuration
		
		SetSliderOptionValue(option, Trimester1BaseDurationDefault as Float, "{0} days")
		Trimester1BaseDuration = Trimester1BaseDurationDefault
		
	ElseIf option == OIDTrimester2BaseDuration
		
		SetSliderOptionValue(option, Trimester2BaseDurationDefault as Float, "{0} days")
		Trimester2BaseDuration = Trimester2BaseDurationDefault
		
	ElseIf option == OIDTrimester3BaseDuration
		
		SetSliderOptionValue(option, Trimester3BaseDurationDefault as Float, "{0} days")
		Trimester3BaseDuration = Trimester3BaseDurationDefault
		
		
		
	; Irregularities
		
	ElseIf option == OIDIrregularityChance
		
		SetSliderOptionValue(option, IrregularityChanceDefault as Float, "{0}%")
		IrregularityChance = IrregularityChanceDefault
		
	ElseIf option == OIDRelativeMesntruationPhaseVariance
		
		SetSliderOptionValue(option, RelativeMesntruationPhaseVarianceDefault as Float, "{0}%")
		RelativeMesntruationPhaseVariance = RelativeMesntruationPhaseVarianceDefault
		
	ElseIf option == OIDRelativePregnancyPhaseVariance
		
		SetSliderOptionValue(option, RelativePregnancyPhaseVarianceDefault as Float, "{0}%")
		RelativePregnancyPhaseVariance = RelativePregnancyPhaseVarianceDefault
		
	ElseIf option == OIDRelativePregnancyDelayVariance
		
		SetSliderOptionValue(option, RelativePregnancyDelayVarianceDefault as Float, "{0}%")
		RelativePregnancyDelayVariance = RelativePregnancyDelayVarianceDefault
		
	ElseIf option == OIDPostBirthNormalizationVariance
		
		SetSliderOptionValue(option, PostBirthNormalizationVarianceDefault as Float, "{0}%")
		PostBirthNormalizationVariance = PostBirthNormalizationVarianceDefault
		
	ElseIf option == OIDRelativeSpermDurationVariance
		
		SetSliderOptionValue(option, RelativeSpermDurationVarianceDefault as Float, "{0}%")
		RelativeSpermDurationVariance = RelativeSpermDurationVarianceDefault
		
		
	; General settings
	ElseIf option == OIDEnableMessages
		EnableMessages = EnableMessagesDefault
		EnableMessagesText = "HIGH"
		SetTextOptionValue(option, EnableMessagesText)
	
	; Racial Modifiers
	
	ElseIf option == OIDEnableRaceMultipliers
		EnableRaceMultipliers = EnableRaceMultipliersDefault
		SetToggleOptionValue(option, EnableRaceMultipliers)
	
	
	
	; Belly size settings
	
	ElseIf option == OIDVisualScalingType
		VisualScalingType = VisualScalingTypeDefault
		VisualScalingTypeText = "Skeleton"
		SetTextOptionValue(option, VisualScalingTypeText)
	
	ElseIf option == OIDMaxScaleBelly
		
		SetSliderOptionValue(option, MaxScaleBellyDefault, "{0}")
		MaxScaleBelly = MaxScaleBellyDefault
		
	ElseIf option == OIDMaxScaleBreasts
		
		SetSliderOptionValue(option, MaxScaleBreastsDefault, "{2}")
		MaxScaleBreasts = MaxScaleBreastsDefault
		
	EndIf
	
EndEvent


Event OnOptionHighlight(int option)
	
	; General settings
	If option == OIDEnableMessages
		SetInfoText(EnableMessagesDescription)
		
	; Menstrual Cycle settings
	ElseIf option == OIDChanceOfPMS
		SetInfoText(ChanceOfPMSDescription)
		
	ElseIf option == OIDChanceOfMenstrualCramps
		SetInfoText(ChanceOfMenstrualCrampsDescription)
		
		
	; Contraception settings
	ElseIf option == OIDChanceToWashOut
		SetInfoText(ChanceToWashOutDescription)
		
	ElseIf option == OIDWashOutMaxAge
		SetInfoText(WashOutMaxAgeDescription)
	
		
	; Pregnancy settings
	ElseIf option == OIDChanceToConceive
		SetInfoText(ChanceToConceiveDescription)
		
	ElseIf option == OIDTwinsThreshold
		SetInfoText(TwinsThresholdDescription)
		
	ElseIf option == OIDTripletsThreshold
		SetInfoText(TripletsThresholdDescription)
		
	; Duration settings
	ElseIf option == OIDSpermDuration
		SetInfoText(SpermDurationDescription)
		
	ElseIf option == OIDMenstruationDuration
		SetInfoText(MenstruationDurationDescription)
		
	ElseIf option == OIDFollicularDuration
		SetInfoText(FollicularDurationDescription)
		
	ElseIf option == OIDOvulationDuration
		SetInfoText(OvulationDurationDescription)
		
	ElseIf option == OIDLutealDuration
		SetInfoText(LutealDurationDescription)
		
	ElseIf option == OIDTrimester1BaseDuration
		SetInfoText(Trimester1BaseDurationDescription)
		
	ElseIf option == OIDTrimester2BaseDuration
		SetInfoText(Trimester2BaseDurationDescription)
		
	ElseIf option == OIDTrimester3BaseDuration
		SetInfoText(Trimester3BaseDurationDescription)
		
		
	; Belly size settings
	ElseIf option == OIDVisualScalingType
		SetInfoText(VisualScalingTypeDescription)
		
	ElseIf option == OIDMaxScaleBelly
		SetInfoText(MaxScaleBellyDescription)
		
	ElseIf option == OIDMaxScaleBreasts
		SetInfoText(MaxScaleBreastsDescription)
		
		
	; Racial Modifiers
	ElseIf option == OIDEnableRaceMultipliers
		SetInfoText(EnableRaceMultipliersDescription)
		
		
	; Irregularities
	ElseIf option == OIDIrregularityChance
		SetInfoText(IrregularityChanceDescription)
		
	ElseIf option == OIDRelativeMesntruationPhaseVariance
		SetInfoText(RelativeMesntruationPhaseVarianceDescription)
		
	ElseIf option == OIDRelativePregnancyPhaseVariance
		SetInfoText(RelativePregnancyPhaseVarianceDescription)
		
	ElseIf option == OIDRelativePregnancyDelayVariance
		SetInfoText(RelativePregnancyDelayVarianceDescription)
		
	ElseIf option == OIDPostBirthNormalizationVariance
		SetInfoText(PostBirthNormalizationVarianceDescription)
		
	ElseIf option == OIDRelativeSpermDurationVariance
		SetInfoText(RelativeSpermDurationVarianceDescription)
	
	EndIf
	
EndEvent

