Scriptname ProCAbilityEffectMenstrualCramps extends activemagiceffect  

; The image space modifier
ImageSpaceModifier Property BlurVision Auto
Float ImodStr = 2.0

; The sound effect property
Sound Property PainSound Auto
Float SoundVolume = 0.8

; Actor reference, from the spell cast event
Actor ActorReference

; Damage Settings
Float DamageBasePct = 0.120
Float DamageVariance = 0.1

; Interval
Float BaseInterval = 120.0
Float IntervalVariance = 0.25


Event OnEffectStart(Actor target, Actor caster)
	ActorReference = target
	RegisterForSingleUpdate(RandomizeInterval())
	CombinedTrigger()
EndEvent


Event OnUpdate()
	RegisterForSingleUpdate(RandomizeInterval())
	CombinedTrigger()
EndEvent


; The function that puts it all together.
Function CombinedTrigger()
	CausePain(ActorReference)
	CauseVisualEffect()
	; CauseSoundEffect() ; Turned off atm. because playing the players voice is apparently borderline impossible.
EndFunction


; This function doesn't work because I can't figure out which sound property to pass to the "PainSound" variable
Function CauseSoundEffect()
	If ActorReference == Game.GetPlayer()
		Int SoundIndex = PainSound.Play(ActorReference)
		Sound.SetInstanceVolume(SoundIndex, SoundVolume)
	EndIf
EndFunction

Function CauseVisualEffect()
	If ActorReference == Game.GetPlayer()
		BlurVision.Remove()
		BlurVision.Apply(ImodStr)
	EndIf
EndFunction

Function CausePain(Actor ActorRef)
	Float BaseHealth = ActorRef.GetBaseActorValue("Health")
	Float RandomModPct	= RandomizeDamage()
	Float DamageAmount = BaseHealth*RandomModPct
	ActorRef.DamageActorValue("Health", DamageAmount)
EndFunction

Float Function RandomizeDamage()
	Float random = Utility.RandomFloat(-DamageVariance, DamageVariance)
	Return DamageBasePct+random
EndFunction

Float Function RandomizeInterval()
	Float random = Utility.RandomFloat(-IntervalVariance, IntervalVariance)
	Return BaseInterval+(random*BaseInterval)
EndFunction
