Scriptname HentaiPregnantActorAlias extends ReferenceAlias  

HentaiPregnancyConfig Property config Auto
HentaiPregnancy Property HentaiP Auto

String LBreast = "NPC L Breast"
String RBreast = "NPC R Breast"
String Belly = "NPC Belly"

Float InitialBreastSize = 1.0
Float InitialBellySize = 0.0

Float CurrentBreastSize = 0.0
Float CurrentBellySize = 0.0

Float IncrBreastSize = 1.0
Float IncrBellySize = 5.0

Float IncrBreastRate = 0.0
Float IncrBellyRate = 0.0

Int pregnancyId = -1
Int DurationHours = 0
Int PostDurationHours = 0
Int ChildChance = 0
Int CurrentHour = 0

float TargetBreastSize = 0.0
float TargetBellySize = 0.0

Actor Property ActorRef Auto
Actor Property FatherRef Auto

float lastGameTime = 0.0

bool isvictim = false
bool fertilised = false

Event OnInit()
	GoToState("ReadyForPregnancy")
EndEvent

auto State ReadyForPregnancy
	Event OnBeginState()
		CurrentHour = 0
		ActorRef = none
		FatherRef = none
		lastGameTime = 0.0
		isvictim = false
		fertilised = false
		Clear()
		;Debug.Notification("HentaiPregnantActorAlias Normal")
	EndEvent
	
	event OnUpdate()
		; catch any pending updates
	endEvent	
EndState

function setConfig(HentaiPregnancyConfig hpconfig)
	config = hpconfig
endFunction

function setFather(Actor male)
	FatherRef = male
endFunction

function setIsVictim(bool victim)
	isvictim = victim
endFunction

bool function isVictim()
	return isvictim
endFunction

function setFertilised(bool fertilise)
	fertilised = fertilise
endFunction

bool function isFertilised()
	return fertilised
endFunction

Actor function getFather()
	return FatherRef
endFunction

Actor function getMother()
	return ActorRef
endFunction

int function getCurrentHour()
	return CurrentHour
endFunction

int function getId()
	return pregnancyId
endFunction

int function setId(int newid)
	pregnancyId = newid
endFunction

function incrSize()
	
	if ( CurrentBreastSize < TargetBreastSize)
		CurrentBreastSize += IncrBreastRate
	endIf
	if ( CurrentBellySize < TargetBellySize)
		CurrentBellySize += IncrBellyRate
	endIf	

endFunction

function decrSize()
	
	if ( CurrentBreastSize > InitialBreastSize)
		CurrentBreastSize -= IncrBreastRate
	endIf
	if ( CurrentBellySize > InitialBellySize)
		CurrentBellySize -= IncrBellyRate
	endIf
	
endFunction

State Inseminated
	Event OnBeginState()
		ActorRef = GetActorRef()
		ChildChance = config.ChildChance	
	
		InitialBreastSize = NetImmerse.GetNodeScale(ActorRef, LBreast, false)
		if(InitialBreastSize < 1)
			InitialBreastSize = 1
		endIf
		InitialBellySize = NetImmerse.GetNodeScale(ActorRef, Belly, false)	
		;Debug.Notification("InitialBreastSize " + InitialBreastSize)
		int random = Utility.RandomInt(0, 100)
		int chance = config.CumInflationChance
		if random <= chance
			GoToState("CumInflated")
		elseif fertilised
			GoToState("Pregnant")
		else
			GoToState("ReadyForPregnancy")
		endIf
	EndEvent
	
	Event OnUpdate()

	EndEvent
	
	Event OnUpdateGameTime()

	EndEvent
		
	event OnEndState()

	endEvent		
	
	event OnDeath(Actor akKiller)
		GoToState("PregnancyEnded")
	EndEvent	
EndState

State CumInflated
	Event OnBeginState()

		CurrentBellySize = InitialBellySize
		CurrentBreastSize = InitialBreastSize
		TargetBreastSize = config.MaxScaleBreasts * 0.5
		TargetBellySize = config.MaxScaleBelly * 0.75
		
		While CurrentBellySize < TargetBellySize || CurrentBreastSize < TargetBreastSize
			if CurrentBellySize < TargetBellySize
				CurrentBellySize += 0.1
				NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
			EndIf
			if CurrentBreastSize < TargetBreastSize
				CurrentBreastSize += 0.05
				NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
				NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)		
			EndIf
			Utility.Wait(0.1)
		EndWhile
		
		RegisterForSingleUpdateGameTime(1)
	EndEvent
	
	Event OnUpdate()

	EndEvent
	
	Event OnUpdateGameTime()
		HentaiP.endCumInflation(ActorRef, pregnancyId, isvictim)
	
		ResetBody()
		
		UnregisterForUpdate()
		
		if fertilised
			GoToState("Pregnant")
		else
			GoToState("ReadyForPregnancy")		
		endIf
	EndEvent
		
	event OnEndState()
		ResetBody()
	endEvent		
	
	event OnDeath(Actor akKiller)
		GoToState("PregnancyEnded")
	EndEvent	
EndState

State Pregnant
	Event OnBeginState()
		ActorRef = GetActorRef()
		;Debug.Notification("HentaiPregnantActorAlias Pregnant")
		int DurationDays = config.PregnancyDuration
		ChildChance = config.ChildChance
		
		CurrentBellySize = InitialBellySize
		CurrentBreastSize = InitialBreastSize
		TargetBreastSize = config.MaxScaleBreasts
		TargetBellySize = config.MaxScaleBelly	
		
		float BreastSizeDelta = TargetBreastSize - CurrentBreastSize
		float BellySizeDelt = TargetBellySize - CurrentBellySize
		DurationHours = DurationDays * 24
		IncrBreastRate = BreastSizeDelta / (DurationHours / 2)
		IncrBellyRate = BellySizeDelt / (DurationHours / 2)
		
		lastGameTime = Utility.GetCurrentGameTime()
		incrSize()

		RegisterForSingleUpdate(2.0)
		RegisterForSingleUpdateGameTime(1)
	EndEvent
	
	Event OnUpdate()
		recheckBody()
		RegisterForSingleUpdate(2.0)
	EndEvent
	
	Event OnUpdateGameTime()
		if CurrentHour < DurationHours
			if(lastGameTime == 0.0)
				lastGameTime  = Utility.GetCurrentGameTime()
			EndIf		
			float currentTime  = Utility.GetCurrentGameTime()	
			float hourspassedfloat = (currentTime - lastGameTime) * 24
			int hourspassed = hourspassedfloat as int
			;Debug.Notification("Hours passed " + hourspassed)	
			if(hourspassed<=0)
				hourspassed = 1
			endif
			CurrentHour += hourspassed
			int hourcount = 0;
			while hourcount < hourspassed
				incrSize()
				hourcount += 1
			endwhile
			lastGameTime = currentTime
			
			HentaiP.addTempPregnancyEffects(ActorRef, DurationHours - CurrentHour, isvictim)
			
			RegisterForSingleUpdateGameTime(1)
		Else
			UnregisterForUpdate()
			GoToState("PregnancyEnded")
		EndIf
	EndEvent		
	
	event OnDeath(Actor akKiller)
		GoToState("PregnancyEnded")
	EndEvent	
EndState

State PregnancyEnded
	Event OnBeginState()
		;Debug.Notification("HentaiPregnantActorAlias PregnancyEnded")
		
		while ( ActorRef.IsOnMount() )
			ActorRef.Dismount()
			Utility.Wait( 2.0 )
		endWhile		
	
		HentaiP.endPregnancy(ActorRef, pregnancyId, isvictim, CurrentHour)
		
		GoToState("PostPregnancy")
	EndEvent
	
	event OnEndState()
		Debug.Notification(ActorRef.GetActorBase().GetName() + " is no longer pregnant")
	endEvent	
	
	event OnUpdate()
		; catch any pending updates
	endEvent	
EndState

State PostPregnancy
	Event OnBeginState()
		int DurationDays = config.PregnancyDuration
		float BreastSizeDelta = CurrentBreastSize - InitialBreastSize
		float BellySizeDelt = CurrentBellySize - InitialBellySize
		PostDurationHours = DurationDays * 7
		PostDurationHours += CurrentHour
		IncrBreastRate = BreastSizeDelta / PostDurationHours
		IncrBellyRate = BellySizeDelt / PostDurationHours
		
		lastGameTime = Utility.GetCurrentGameTime()
		
		RegisterForSingleUpdate(2.0)
		RegisterForSingleUpdateGameTime(1)
	EndEvent
	
	Event OnUpdateGameTime()
		if CurrentHour < PostDurationHours
			if(lastGameTime == 0.0)
				lastGameTime  = Utility.GetCurrentGameTime()
			EndIf		
			float currentTime  = Utility.GetCurrentGameTime()	
			float hourspassedfloat = (currentTime - lastGameTime) * 24
			int hourspassed = hourspassedfloat as int
			;Debug.Notification("Hours passed " + hourspassed)	
			if(hourspassed<=0)
				hourspassed = 1
			endif
			CurrentHour += hourspassed
			int hourcount = 0;
			while hourcount < hourspassed
				decrSize()
				hourcount += 1
			endwhile
			lastGameTime = currentTime
			
			HentaiP.addTempPostPregnancyEffects(ActorRef, PostDurationHours - CurrentHour)
			
			RegisterForSingleUpdateGameTime(1)
		Else
			UnregisterForUpdate()
			GoToState("ReadyForPregnancy")
		EndIf
	EndEvent		
	
	event OnEndState()
		ResetBody()
		if config.EnableMessages
			Debug.Notification(ActorRef.GetActorBase().GetName() + "'s post pregnancy has ended")
		endif
	endEvent	
	
	event OnUpdate()
		recheckBody()
		RegisterForSingleUpdate(2.0)
	endEvent	
EndState

State ClearPregnancy
	Event OnBeginState()
		UnregisterForUpdate()	
		GoToState("ReadyForPregnancy")
	EndEvent
	
	event OnEndState()
		ResetBody()
		if config.EnableMessages
			Debug.Notification(ActorRef.GetActorBase().GetName() + "'s pregnancy terminated")
		endif
	endEvent	
	
	event OnUpdate()
		; catch any pending updates
	endEvent	
EndState

function UpdateBody()

	While CurrentBellySize < TargetBellySize || CurrentBreastSize < TargetBreastSize
		if CurrentBellySize < TargetBellySize
			CurrentBellySize += 0.1
			NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
		EndIf
		if CurrentBreastSize < TargetBreastSize
			CurrentBreastSize += 0.05
			NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
			NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)		
		EndIf
		Utility.Wait(0.1)
	EndWhile
	
endFunction



function recheckBody()
	NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
	NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
	NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)
endFunction

function ResetBody()
	While CurrentBellySize > InitialBellySize || CurrentBreastSize > InitialBreastSize
		if CurrentBellySize > InitialBellySize
			CurrentBellySize -= 0.1
			NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
		EndIf
		if CurrentBreastSize > InitialBreastSize
			CurrentBreastSize -= 0.05
			NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
			NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)		
		EndIf
		Utility.Wait(0.1)
	EndWhile
	NetImmerse.SetNodeScale(ActorRef, Belly, InitialBellySize, false)
	NetImmerse.SetNodeScale(ActorRef, LBreast, InitialBreastSize, false)
	NetImmerse.SetNodeScale(ActorRef, RBreast, InitialBreastSize, false)
endFunction



