Scriptname HentaiImpregnated extends activemagiceffect  

Import Game
Import Math
Import Debug
Import Utility

HentaiPregnancyConfig Property config Auto
HentaiPregnancy Property HentaiP Auto

String LBreast = "NPC L Breast"
String RBreast = "NPC R Breast"
String Belly = "NPC Belly"

Float InitialBreastSize = 0.0
Float InitialBellySize = 0.0

Float CurrentBreastSize = 1.0
Float CurrentBellySize = 0.0

Float IncrBreastSize = 1.0
Float IncrBellySize = 5.0

Int DurationDays = 1
Int ChildChance = 0
Int CurrentDay = 1
Int CurrentHour = 1

float TargetBreastSize = 0.0
float TargetBellySize = 0.0

Actor Property ActorRef Auto

Event OnEffectStart(Actor akTarget, Actor akCaster)
	ActorRef = akTarget

	;DurationDays = config.PregnancyDuration
	ChildChance = config.ChildChance
	
	InitialBreastSize = NetImmerse.GetNodeScale(ActorRef, LBreast, false)
	InitialBellySize = NetImmerse.GetNodeScale(ActorRef, Belly, false)
	CurrentBellySize = InitialBellySize
	CurrentBreastSize = InitialBreastSize
	TargetBreastSize = config.MaxScaleBreasts
	TargetBellySize = config.MaxScaleBelly	

	;RegisterForSingleUpdate(2)
	
	UpdateBody()
	RegisterForSingleUpdate(2.0)
	RegisterForSingleUpdateGameTime(24)
EndEvent

function UpdateBody()

	While CurrentBellySize < TargetBellySize || CurrentBreastSize < TargetBreastSize
		if CurrentBellySize < TargetBellySize
			CurrentBellySize += 0.1
			NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
		EndIf
		if CurrentBreastSize < TargetBreastSize
			CurrentBreastSize += 0.05
			NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
			NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)		
		EndIf
		Utility.Wait(0.1)
	EndWhile
	
endFunction

Event OnUpdate()
	recheckBody()
	RegisterForSingleUpdate(2.0)
EndEvent

function recheckBody()
	NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
	NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
	NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)
endFunction

function ResetBody()
	While CurrentBellySize > InitialBellySize || CurrentBreastSize > InitialBreastSize
		if CurrentBellySize > InitialBellySize
			CurrentBellySize -= 0.1
			NetImmerse.SetNodeScale(ActorRef, Belly, CurrentBellySize, false)
		EndIf
		if CurrentBreastSize > InitialBreastSize
			CurrentBreastSize -= 0.05
			NetImmerse.SetNodeScale(ActorRef, LBreast, CurrentBreastSize, false)
			NetImmerse.SetNodeScale(ActorRef, RBreast, CurrentBreastSize, false)		
		EndIf
		Utility.Wait(0.1)
	EndWhile
	NetImmerse.SetNodeScale(ActorRef, Belly, InitialBellySize, false)
	NetImmerse.SetNodeScale(ActorRef, LBreast, InitialBreastSize, false)
	NetImmerse.SetNodeScale(ActorRef, RBreast, InitialBreastSize, false)
endFunction

Event OnUpdateGameTime()

	if CurrentDay <= DurationDays
		CurrentDay += 1
		;recheckBody()
		RegisterForSingleUpdateGameTime(24)
	Else
		UnregisterForUpdate()
		HentaiP.endPregnancy(ActorRef, -1, true, 24)
		Debug.Notification(ActorRef.GetActorBase().GetName() + " is no longer inflated")
		ResetBody()
		Dispel()
	EndIf
	
EndEvent

Event OnEffectFinish(Actor akTarget, Actor akCaster)
	if CurrentDay <= DurationDays
		Debug.Notification(ActorRef.GetActorBase().GetName() + " is no longer inflated")
		HentaiP.endPregnancy(ActorRef, -1, true, 24)
	else
		ResetBody()
		UnregisterForUpdate()
	EndIf
EndEvent