Scriptname HPSoulGemBirthQuest extends Quest

HentaiPregnancy Property PregnancySystem Auto
HPSoulGemBirthConfig Property config Auto

SoulGem Property SoulGemBlackFilled Auto
SoulGem Property SoulGemGrandFilled Auto
SoulGem Property SoulGemGreaterFilled Auto
SoulGem Property SoulGemLesserFilled Auto
SoulGem Property SoulGemPettyFilled Auto

ActorBase Property NordBoy1 Auto
ActorBase Property NordGirl1 Auto
Actorbase Property BosmerGirl1 Auto
Actorbase Property BosmerBoy1 Auto
Actorbase Property RedguardBoy1 Auto
Actorbase Property RedguardGirl1 Auto
Actorbase Property ImperialBoy1 Auto
Actorbase Property ImperialGirl1 Auto
Actorbase Property BretonBoy1 Auto
Actorbase Property BretonGirl1 Auto
Actorbase Property AltmerBoy1 Auto
Actorbase Property AltmerGirl1 Auto
Actorbase Property OrcBoy1 Auto
Actorbase Property OrcGirl1 Auto
Actorbase Property ArgonianBoy1 Auto
Actorbase Property ArgonianGirl1 Auto
Actorbase Property KhajitBoy1 Auto
Actorbase Property KhajitGirl1 Auto
Actorbase Property DunmerBoy1 Auto
Actorbase Property DunmerGirl1 Auto

Race Property ArgonianRace Auto

function registerForEvents()

	UnregisterForModEvent("HentaiPregnancyBirth")
	
	RegisterForModEvent("HentaiPregnancyBirth", "Childbirth")
	
endFunction

function gameLoaded()

	;reconnect on save game load
	;triggered by HPSoulGemBirthConfig
	registerForEvents()
	
endFunction

Event OnInit()

	registerForEvents()
	
EndEvent

Event SoulGemImpregnation(string eventName, string pregnancyID, float durationHours, form sender)

	;duration in hours
	int pregnancyduration = durationHours as int
	
	HentaiPregnantActorAlias pregnancy = PregnancySystem.getPregnancyWithID(pregnancyID as int)
	Actor mother = pregnancy.getMother()
	Actor father = pregnancy.getFather()
	bool forced = pregnancy.isVictim()
	if(forced || !config.ForcedOnly)
		Debug.Notification(father.GetActorBase().GetName() + " has planted a gem seed in " + mother.GetActorBase().GetName())
	endIf
	
EndEvent

Event SoulGemBirth(string eventName, string pregnancyID, float durationHours, form sender)

	int iPregnancyID = pregnancyID as int

	;safety check, pregnancyID should always be > -1
	if(iPregnancyID > -1)

		HentaiPregnantActorAlias pregnancy = PregnancySystem.getPregnancyWithID(iPregnancyID)
		Actor mother = pregnancy.getMother()
	
		;duration in hours
		int iPregnancyDuration = durationHours as int
		
		;safety check, config.SoulGemDuration should always be > 0
		if config.SoulGemDuration > 0 && (pregnancy.isVictim() || !config.ForcedOnly)
		
			float soulGemSize = iPregnancyDuration / config.SoulGemDuration
			If soulGemSize > 4
				mother.addItem(SoulGemBlackFilled, 1, true)	
			elseIf soulGemSize > 4
				mother.addItem(SoulGemGrandFilled, 1, true)	
			elseIf soulGemSize > 3
				mother.addItem(SoulGemGreaterFilled, 1, true)
			elseIf soulGemSize > 2
				mother.addItem(SoulGemLesserFilled, 1, true)												
			elseif soulGemSize > 1
				mother.addItem(SoulGemPettyFilled, 1, true)
			endIf
			
			if soulGemSize > 1
				Debug.Notification(mother.GetActorBase().GetName() + " birthed a Soul Gem")
			endIf
		
		endIf
	
	endIf
	
EndEvent

Event Childbirth(string eventName, string pregnancyID, float durationHours, form sender)

	int iPregnancyID = pregnancyID as int

	;safety check, pregnancyID should always be > -1
	if(iPregnancyID > -1)

		HentaiPregnantActorAlias pregnancy = PregnancySystem.getPregnancyWithID(iPregnancyID)
		Actor mother = pregnancy.getMother()
		Actor father = pregnancy.getFather()
	
		;duration in hours
		int iPregnancyDuration = durationHours as int
		
		SpawnChild(mother, father)

		Debug.Notification(mother.GetActorBase().GetName() + " has given birth to a healthy child.")

	endIf
	
EndEvent

Function SpawnChild(Actor Father, Actor Mother)
		
	ActorBase ChildBase
	Actor Child
	
	ChildBase = InheritLooks(ChildBase, Father, Mother)
	Child = Father.PlaceActorAtMe(ChildBase)
	Child.QueueNiNodeUpdate()
	
EndFunction

ActorBase Function InheritLooks(ActorBase ChildBase, Actor Father, Actor Mother)
	
	ActorBase FatherBaseRef = Father.GetLeveledActorBase()
	ActorBase MotherBaseRef = Mother.GetLeveledActorBase()
	ActorBase FatherRaceRef = Father.GetActorBase()
	ActorBase MotherRaceRef = Mother.GetActorBase()	

	Race InheritRace

	Int Haircolor = Utility.RandomInt(0,1)
	Int Eyes = Utility.RandomInt(0,1)
	Int Nose = Utility.RandomInt(0,1)
	Int Mouth = Utility.RandomInt(0,1)
	Int ChildRace = Utility.RandomInt(0,1)
	Int gender = Utility.RandomInt(0,1)

	Int FatherNosePreset = FatherBaseRef.GetFacePreset(0)
	Int FatherEyesPreset = FatherBaseRef.GetFacePreset(2)
	Int FatherMouthPreset = FatherBaseRef.GetFacePreset(3)
	ColorForm FatherHairColor = FatherBaseRef.GetHairColor()
	Race FatherRace = FatherRaceRef.GetRace() as Race

	Int MotherNosePreset = MotherBaseRef.GetFacePreset(0)
	Int MotherEyesPreset = MotherBaseRef.GetFacePreset(2)
	Int MotherMouthPreset = MotherBaseRef.GetFacePreset(3)
	ColorForm MotherHairColor = MotherBaseRef.GetHairColor()
	Race MotherRace = MotherRaceRef.GetRace() as Race
	
	If ChildRace == 0
		InheritRace = FatherRace
		; Debug.Notification("Child is inheriting father's race.")
	Else
		InheritRace = MotherRace
		; Debug.Notification("Child is inheriting mother's race.")
	EndIf

	If InheritRace == None
		Debug.Notification("Race was not inherited correctly.")
	EndIf

	If InheritRace == ArgonianRace || InheritRace == ArgonianRaceVampire
		; Debug.Notification("Child will be Argonian.")
		If gender == 0
			ChildBase = ArgonianBoy1
		Else
			ChildBase = ArgonianGirl1
		EndIf
	ElseIf InheritRace == BretonRace || InheritRace == BretonRaceVampire
		; Debug.Notification("Child will be Breton.")
		If gender == 0
			ChildBase = BretonBoy1
		Else
			ChildBase = BretonGirl1
		EndIf
	ElseIf InheritRace == DarkElfRace || InheritRace == DarkElfRaceVampire
		; Debug.Notification("Child will be Dunmer.")
		If gender == 0
			ChildBase = DunmerBoy1
		Else 
			ChildBase = DunmerGirl1
		EndIf
	ElseIf InheritRace == HighElfRace || InheritRace == HighElfRaceVampire
		; Debug.Notification("Child will be Altmer.")
		If gender == 0
			ChildBase = AltmerBoy1
		Else 
			ChildBase = AltmerGirl1
		EndIf
	ElseIf InheritRace == ImperialRace || InheritRace == ImperialRaceVampire
		; Debug.Notification("Child will be Imperial.")
		If gender == 0
			ChildBase = ImperialBoy1
		Else 
			ChildBase = ImperialGirl1
		EndIf	
	ElseIf InheritRace == KhajiitRace || InheritRace == KhajiitRaceVampire
		; Debug.Notification("Child will be Khajiit.")
		If gender == 0
			ChildBase = KhajitBoy1
		Else 
			ChildBase = KhajitGirl1
		EndIf
	ElseIf InheritRace == NordRace || InheritRace == NordRaceVampire
		; Debug.Notification("Child will be Nord.")
		If gender == 0
			ChildBase = NordBoy1
		Else 
			ChildBase = NordGirl1
		EndIf
	ElseIf InheritRace == OrcRace || InheritRace == OrcRaceVampire
		; Debug.Notification("Child will be Orc.")
		If gender == 0
				ChildBase = OrcBoy1
		Else 
				ChildBase = OrcGirl1
		EndIf
	ElseIf InheritRace == RedguardRace || InheritRace == RedguardRaceVampire
		; Debug.Notification("Child will be Redguard.")
		If gender == 0
			ChildBase = RedguardBoy1
		Else 
			ChildBase = RedguardGirl1
		EndIf
	ElseIf InheritRace == WoodElfRace || InheritRace == WoodElfRaceVampire
		; Debug.Notification("Child will be Bosmer.")
		If gender == 0
			ChildBase = BosmerBoy1
		Else 
			ChildBase = BosmerGirl1
		EndIf
	Else
		Debug.Notification("Parent is a custom race. Defaulting to Nord.")
		If gender == 0
			ChildBase = NordBoy1
		Else 
			ChildBase = NordGirl1
		EndIf
	EndIf

	If Haircolor == 0
		ChildBase.SetHairColor(FatherHairColor)
	Else
		ChildBase.SetHairColor(MotherHairColor)
	EndIf

	If Eyes == 0
		ChildBase.SetFacePreset(FatherEyesPreset, 2)
	Else
		ChildBase.SetFacePreset(MotherEyesPreset, 2)
	EndIf

	If Nose == 0
		ChildBase.SetFacePreset(FatherNosePreset, 0)
	Else
		ChildBase.SetFacePreset(MotherNosePreset, 0)
	EndIf

	If Mouth == 0
		ChildBase.SetFacePreset(FatherMouthPreset, 3)
	Else
		ChildBase.SetFacePreset(MotherMouthPreset, 3)
	EndIf	
	
	Return ChildBase
	
EndFunction

Race Property KhajiitRace  Auto  

Race Property HighElfRace  Auto  

Race Property DarkElfRace  Auto  

Race Property WoodElfRace  Auto  

Race Property RedguardRace  Auto  

Race Property NordRace  Auto  

Race Property BretonRace  Auto  

Race Property ImperialRace  Auto  

Race Property OrcRace  Auto  

Race Property ArgonianRaceVampire  Auto  

Race Property OrcRaceVampire  Auto  

Race Property BretonRaceVampire Auto

Race Property DarkElfRaceVampire Auto

Race Property HighElfRaceVampire Auto

Race Property WoodElfRaceVampire Auto

Race Property RedguardRaceVampire Auto

Race Property KhajiitRaceVampire Auto

Race Property ImperialRaceVampire Auto

Race Property NordRaceVampire Auto
