ScriptName HPSoulGemBirthConfig extends SKI_ConfigBase

HPSoulGemBirthQuest Property SoulGemBirthQuest auto

; ----- Soul Gem settings -----

int Property SoulGemDuration = 10 Auto Hidden
int SoulGemDurationDefault = 10
int OIDSoulGemDuration
int OIDCustomRaceSupport
string[] CustomRaceList 
int CustomRaceIndex = 6
string SoulGemDurationDescription = "Time it takes for Soul Gems to group up to the next size"

int OIDForcedOnly
bool Property ForcedOnly = true Auto Hidden
string ForcedOnlyDescription = "Plant Soul Gem only when it was rape"

Event OnConfigInit()

	Pages = new string[1]
	Pages[0] = "Childbirth Settings"
	CustomRaceList = new string[10]
	CustomRaceList[0] = "Argonian"
	CustomRaceList[1] = "Breton"
	CustomRaceList[2] = "Dark Elf"
	CustomRaceList[3] = "High Elf"
	CustomRaceList[4] = "Imperial"
	CustomRaceList[5] = "Khajiit"
	CustomRaceList[6] = "Nord"
	CustomRaceList[7] = "Orc"
	CustomRaceList[8] = "Redguard"
	CustomRaceList[9] = "Wood Elf"
	
EndEvent

int function GetVersion()

	return 1000
	
endFunction

event OnVersionUpdate(int a_version)

	if (a_version > 1)
		Debug.Trace(self + ": Updating script to version " + a_version)
		OnConfigInit()
	endIf
	
endEvent

Event OnPageReset(string page)
	{Called when a new page is selected, including the initial empty page}
	
	If page == "Childbirth Settings"
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("Child")

		OIDCustomRaceSupport = AddMenuOption("Child Race if Custom", CustomRaceList[CustomRaceIndex])
		
		OIDForcedOnly = AddToggleOption("Forced Only", ForcedOnly)
		
	Else
		
		SetCursorFillMode(TOP_TO_BOTTOM)
		
		SetCursorPosition(0)
		
		AddHeaderOption("SexLab Hentai Pregnancy Soul Gem Birth")
		AddTextOption("Child plugin for Hentai Pregnancy.", "", OPTION_FLAG_DISABLED)
		
	EndIf
	
EndEvent

Event OnOptionSliderAccept(int option, float floatValue)
	
	If option == OIDSoulGemDuration
		
		SetSliderOptionValue(option, floatValue, "{0}%")
		SoulGemDuration = floatValue as int
		
	EndIf
	
EndEvent

event OnOptionSelect(int option)

	If option == OIDForcedOnly
	
		ForcedOnly = !ForcedOnly
		SetToggleOptionValue(OIDForcedOnly, ForcedOnly)
		
	endIf
	
endEvent

Event OnOptionSliderOpen(int option)
	
	If option == OIDSoulGemDuration
		
		SetSliderDialogStartValue(SoulGemDuration)
		SetSliderDialogDefaultValue(SoulGemDurationDefault)
		SetSliderDialogRange(1, 100)
		SetSliderDialogInterval(1)
		
	EndIf
	
EndEvent

Event OnOptionHighlight(int option)
	
	If option == OIDSoulGemDuration
	
		SetInfoText(SoulGemDurationDescription)	
		
	ElseIf option == OIDForcedOnly
	
		SetInfoText(ForcedOnlyDescription)	
					
	EndIf
	
EndEvent

event OnGameReload()

	parent.OnGameReload() ; Don't forget to call the parent!
	SoulGemBirthQuest.gameLoaded()
	
endEvent
