/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.messaging.saaj.soap;

import com.sun.xml.internal.messaging.saaj.util.transform.EfficientStreamingTransformer;
import java.awt.datatransfer.DataFlavor;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XmlDataContentHandler
implements DataContentHandler {
    public static final String STR_SRC = "javax.xml.transform.stream.StreamSource";
    private static Class streamSourceClass = null;

    public XmlDataContentHandler() throws ClassNotFoundException {
        if (streamSourceClass == null) {
            streamSourceClass = Class.forName(STR_SRC);
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[]{new ActivationDataFlavor(streamSourceClass, "text/xml", "XML"), new ActivationDataFlavor(streamSourceClass, "application/xml", "XML")};
        return dataFlavorArray;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor, DataSource dataSource) throws IOException {
        if ((dataFlavor.getMimeType().startsWith("text/xml") || dataFlavor.getMimeType().startsWith("application/xml")) && dataFlavor.getRepresentationClass().getName().equals(STR_SRC)) {
            return new StreamSource(dataSource.getInputStream());
        }
        return null;
    }

    @Override
    public Object getContent(DataSource dataSource) throws IOException {
        return new StreamSource(dataSource.getInputStream());
    }

    @Override
    public void writeTo(Object object, String string, OutputStream outputStream) throws IOException {
        if (!string.startsWith("text/xml") && !string.startsWith("application/xml")) {
            throw new IOException("Invalid content type \"" + string + "\" for XmlDCH");
        }
        try {
            Transformer transformer = EfficientStreamingTransformer.newTransformer();
            StreamResult streamResult = new StreamResult(outputStream);
            if (object instanceof DataSource) {
                transformer.transform((Source)this.getContent((DataSource)object), streamResult);
            } else {
                Source source = null;
                source = object instanceof String ? new StreamSource(new StringReader((String)object)) : (Source)object;
                transformer.transform(source, streamResult);
            }
        }
        catch (Exception exception) {
            throw new IOException("Unable to run the JAXP transformer on a stream " + exception.getMessage());
        }
    }
}

