/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvminstr;

import com.sun.jmx.snmp.SnmpOid;
import com.sun.jmx.snmp.SnmpOidRecord;
import com.sun.jmx.snmp.SnmpStatusException;
import java.io.Serializable;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import sun.management.snmp.jvminstr.JVM_MANAGEMENT_MIB_IMPL;
import sun.management.snmp.jvminstr.JvmThreadInstanceTableMetaImpl;
import sun.management.snmp.jvminstr.JvmThreadingImpl;
import sun.management.snmp.jvmmib.JVM_MANAGEMENT_MIBOidTable;
import sun.management.snmp.jvmmib.JvmThreadInstanceEntryMBean;
import sun.management.snmp.util.MibLogger;

public class JvmThreadInstanceEntryImpl
implements JvmThreadInstanceEntryMBean,
Serializable {
    static final long serialVersionUID = 910173589985461347L;
    private final ThreadInfo info;
    private final Byte[] index;
    private static String jvmThreadInstIndexOid = null;
    static final MibLogger log = new MibLogger(JvmThreadInstanceEntryImpl.class);

    public JvmThreadInstanceEntryImpl(ThreadInfo threadInfo, Byte[] byteArray) {
        this.info = threadInfo;
        this.index = byteArray;
    }

    public static String getJvmThreadInstIndexOid() throws SnmpStatusException {
        if (jvmThreadInstIndexOid == null) {
            JVM_MANAGEMENT_MIBOidTable jVM_MANAGEMENT_MIBOidTable = new JVM_MANAGEMENT_MIBOidTable();
            SnmpOidRecord snmpOidRecord = jVM_MANAGEMENT_MIBOidTable.resolveVarName("jvmThreadInstIndex");
            jvmThreadInstIndexOid = snmpOidRecord.getOid();
        }
        return jvmThreadInstIndexOid;
    }

    @Override
    public String getJvmThreadInstLockOwnerPtr() throws SnmpStatusException {
        long l = this.info.getLockOwnerId();
        if (l == -1L) {
            return new String("0.0");
        }
        SnmpOid snmpOid = JvmThreadInstanceTableMetaImpl.makeOid(l);
        return JvmThreadInstanceEntryImpl.getJvmThreadInstIndexOid() + "." + snmpOid.toString();
    }

    private String validDisplayStringTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validDisplayStringTC(string);
    }

    private String validJavaObjectNameTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validJavaObjectNameTC(string);
    }

    private String validPathElementTC(String string) {
        return JVM_MANAGEMENT_MIB_IMPL.validPathElementTC(string);
    }

    @Override
    public String getJvmThreadInstLockName() throws SnmpStatusException {
        return this.validJavaObjectNameTC(this.info.getLockName());
    }

    @Override
    public String getJvmThreadInstName() throws SnmpStatusException {
        return this.validJavaObjectNameTC(this.info.getThreadName());
    }

    @Override
    public Long getJvmThreadInstCpuTimeNs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        try {
            if (threadMXBean.isThreadCpuTimeSupported()) {
                l = threadMXBean.getThreadCpuTime(this.info.getThreadId());
                log.debug("getJvmThreadInstCpuTimeNs", "Cpu time ns : " + l);
                if (l == -1L) {
                    l = 0L;
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            log.debug("getJvmThreadInstCpuTimeNs", "Operation not supported: " + unsatisfiedLinkError);
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstBlockTimeMs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (threadMXBean.isThreadContentionMonitoringSupported() && (l = this.info.getBlockedTime()) == -1L) {
            l = 0L;
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstBlockCount() throws SnmpStatusException {
        return new Long(this.info.getBlockedCount());
    }

    @Override
    public Long getJvmThreadInstWaitTimeMs() throws SnmpStatusException {
        long l = 0L;
        ThreadMXBean threadMXBean = JvmThreadingImpl.getThreadMXBean();
        if (threadMXBean.isThreadContentionMonitoringSupported() && (l = this.info.getWaitedTime()) == -1L) {
            l = 0L;
        }
        return new Long(l);
    }

    @Override
    public Long getJvmThreadInstWaitCount() throws SnmpStatusException {
        return new Long(this.info.getWaitedCount());
    }

    @Override
    public Byte[] getJvmThreadInstState() throws SnmpStatusException {
        return ThreadStateMap.getState(this.info);
    }

    @Override
    public Long getJvmThreadInstId() throws SnmpStatusException {
        return new Long(this.info.getThreadId());
    }

    @Override
    public Byte[] getJvmThreadInstIndex() throws SnmpStatusException {
        return this.index;
    }

    private String getJvmThreadInstStackTrace() throws SnmpStatusException {
        StackTraceElement[] stackTraceElementArray = this.info.getStackTrace();
        StringBuffer stringBuffer = new StringBuffer();
        int n = stackTraceElementArray.length;
        log.debug("getJvmThreadInstStackTrace", "Stack size : " + n);
        for (int i = 0; i < n; ++i) {
            log.debug("getJvmThreadInstStackTrace", "Append " + stackTraceElementArray[i].toString());
            stringBuffer.append(stackTraceElementArray[i].toString());
            if (i >= n) continue;
            stringBuffer.append("\n");
        }
        return this.validPathElementTC(stringBuffer.toString());
    }

    public static final class ThreadStateMap {
        public static final byte mask0 = 63;
        public static final byte mask1 = -128;

        private static void setBit(byte[] byArray, int n, byte by) {
            byArray[n] = (byte)(byArray[n] | by);
        }

        public static void setNative(byte[] byArray) {
            ThreadStateMap.setBit(byArray, 0, (byte)-128);
        }

        public static void setSuspended(byte[] byArray) {
            ThreadStateMap.setBit(byArray, 0, (byte)64);
        }

        public static void setState(byte[] byArray, Thread.State state) {
            switch (state) {
                case BLOCKED: {
                    ThreadStateMap.setBit(byArray, 0, (byte)8);
                    return;
                }
                case NEW: {
                    ThreadStateMap.setBit(byArray, 0, (byte)32);
                    return;
                }
                case RUNNABLE: {
                    ThreadStateMap.setBit(byArray, 0, (byte)16);
                    return;
                }
                case TERMINATED: {
                    ThreadStateMap.setBit(byArray, 0, (byte)4);
                    return;
                }
                case TIMED_WAITING: {
                    ThreadStateMap.setBit(byArray, 0, (byte)1);
                    return;
                }
                case WAITING: {
                    ThreadStateMap.setBit(byArray, 0, (byte)2);
                    return;
                }
            }
        }

        public static void checkOther(byte[] byArray) {
            if ((byArray[0] & 0x3F) == 0 && (byArray[1] & 0xFFFFFF80) == 0) {
                ThreadStateMap.setBit(byArray, 1, (byte)-128);
            }
        }

        public static Byte[] getState(ThreadInfo threadInfo) {
            Byte[] byteArray;
            byte[] byArray = new byte[]{0, 0};
            try {
                byteArray = threadInfo.getThreadState();
                boolean bl = threadInfo.isInNative();
                boolean bl2 = threadInfo.isSuspended();
                log.debug("getJvmThreadInstState", "[State=" + byteArray + ",isInNative=" + bl + ",isSuspended=" + bl2 + "]");
                ThreadStateMap.setState(byArray, (Thread.State)byteArray);
                if (bl) {
                    ThreadStateMap.setNative(byArray);
                }
                if (bl2) {
                    ThreadStateMap.setSuspended(byArray);
                }
                ThreadStateMap.checkOther(byArray);
            }
            catch (RuntimeException runtimeException) {
                byArray[0] = 0;
                byArray[1] = -128;
                log.trace("getJvmThreadInstState", "Unexpected exception: " + runtimeException);
                log.debug("getJvmThreadInstState", runtimeException);
            }
            byteArray = new Byte[]{new Byte(byArray[0]), new Byte(byArray[1])};
            return byteArray;
        }

        public static final class Byte0 {
            public static final byte inNative = -128;
            public static final byte suspended = 64;
            public static final byte newThread = 32;
            public static final byte runnable = 16;
            public static final byte blocked = 8;
            public static final byte terminated = 4;
            public static final byte waiting = 2;
            public static final byte timedWaiting = 1;
        }

        public static final class Byte1 {
            public static final byte other = -128;
            public static final byte reserved10 = 64;
            public static final byte reserved11 = 32;
            public static final byte reserved12 = 16;
            public static final byte reserved13 = 8;
            public static final byte reserved14 = 4;
            public static final byte reserved15 = 2;
            public static final byte reserved16 = 1;
        }
    }
}

