/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.management.resource.ResourceId;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

@InstrumentationTarget(value="java.nio.channels.spi.AbstractInterruptibleChannel")
public final class AbstractInterruptibleChannelRMHooks {
    private final Object closeLock = new Object();
    private volatile boolean open = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public final void close() throws IOException {
        Object object;
        Object object2 = this.closeLock;
        synchronized (object2) {
            if (!this.open) {
                return;
            }
        }
        object2 = null;
        SocketAddress socketAddress = null;
        if (DatagramChannel.class.isInstance(this)) {
            object = (DatagramChannel)((Object)this);
            socketAddress = ((DatagramChannel)object).getLocalAddress();
            object2 = ResourceIdImpl.of(socketAddress);
        } else if (SocketChannel.class.isInstance(this)) {
            object = (SocketChannel)((Object)this);
            socketAddress = ((SocketChannel)object).getLocalAddress();
            object2 = ResourceIdImpl.of(socketAddress);
        } else if (ServerSocketChannel.class.isInstance(this)) {
            object = (ServerSocketChannel)((Object)this);
            socketAddress = ((ServerSocketChannel)object).getLocalAddress();
            object2 = ResourceIdImpl.of(socketAddress);
        }
        try {
            this.close();
        }
        finally {
            if (socketAddress != null) {
                if (DatagramChannel.class.isInstance(this)) {
                    object = ApproverGroup.DATAGRAM_OPEN_GROUP.getApprover(this);
                    object.request(-1L, (ResourceId)object2);
                } else if (SocketChannel.class.isInstance(this) || ServerSocketChannel.class.isInstance(this)) {
                    object = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
                    object.request(-1L, (ResourceId)object2);
                }
            }
        }
    }
}

