/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.DontInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.Invokers;
import java.lang.invoke.LambdaFormEditor;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleImpl;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.Stable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import sun.invoke.util.Wrapper;

class LambdaForm {
    final int arity;
    final int result;
    final boolean forceInline;
    final MethodHandle customized;
    @Stable
    final Name[] names;
    final String debugName;
    MemberName vmentry;
    private boolean isCompiled;
    volatile Object transformCache;
    public static final int VOID_RESULT = -1;
    public static final int LAST_RESULT = -2;
    private static final boolean USE_PREDEFINED_INTERPRET_METHODS = true;
    private static final int COMPILE_THRESHOLD = Math.max(-1, MethodHandleStatics.COMPILE_THRESHOLD);
    private int invocationCounter = 0;
    static final int INTERNED_ARGUMENT_LIMIT = 10;
    private static final Name[][] INTERNED_ARGUMENTS = new Name[BasicType.ARG_TYPE_LIMIT][10];
    private static final MemberName.Factory IMPL_NAMES;
    private static final LambdaForm[] LF_identityForm;
    private static final LambdaForm[] LF_zeroForm;
    private static final NamedFunction[] NF_identity;
    private static final NamedFunction[] NF_zero;
    private static final HashMap<String, Integer> DEBUG_NAME_COUNTERS;
    private static final boolean TRACE_INTERPRETER;

    LambdaForm(String string, int n, Name[] nameArray, int n2) {
        this(string, n, nameArray, n2, true, null);
    }

    LambdaForm(String string, int n, Name[] nameArray, int n2, boolean bl, MethodHandle methodHandle) {
        assert (LambdaForm.namesOK(n, nameArray));
        this.arity = n;
        this.result = LambdaForm.fixResult(n2, nameArray);
        this.names = (Name[])nameArray.clone();
        this.debugName = LambdaForm.fixDebugName(string);
        this.forceInline = bl;
        this.customized = methodHandle;
        int n3 = this.normalize();
        if (n3 > 253) {
            assert (n3 <= 255);
            this.compileToBytecode();
        }
    }

    LambdaForm(String string, int n, Name[] nameArray) {
        this(string, n, nameArray, -2, true, null);
    }

    LambdaForm(String string, int n, Name[] nameArray, boolean bl) {
        this(string, n, nameArray, -2, bl, null);
    }

    LambdaForm(String string, Name[] nameArray, Name[] nameArray2, Name name) {
        this(string, nameArray.length, LambdaForm.buildNames(nameArray, nameArray2, name), -2, true, null);
    }

    LambdaForm(String string, Name[] nameArray, Name[] nameArray2, Name name, boolean bl) {
        this(string, nameArray.length, LambdaForm.buildNames(nameArray, nameArray2, name), -2, bl, null);
    }

    private static Name[] buildNames(Name[] nameArray, Name[] nameArray2, Name name) {
        int n = nameArray.length;
        int n2 = n + nameArray2.length + (name == null ? 0 : 1);
        Name[] nameArray3 = Arrays.copyOf(nameArray, n2);
        System.arraycopy(nameArray2, 0, nameArray3, n, nameArray2.length);
        if (name != null) {
            nameArray3[n2 - 1] = name;
        }
        return nameArray3;
    }

    private LambdaForm(String string) {
        assert (LambdaForm.isValidSignature(string));
        this.arity = LambdaForm.signatureArity(string);
        this.result = LambdaForm.signatureReturn(string) == BasicType.V_TYPE ? -1 : this.arity;
        this.names = LambdaForm.buildEmptyNames(this.arity, string);
        this.debugName = "LF.zero";
        this.forceInline = true;
        this.customized = null;
        assert (this.nameRefsAreLegal());
        assert (this.isEmpty());
        assert (string.equals(this.basicTypeSignature())) : string + " != " + this.basicTypeSignature();
    }

    private static Name[] buildEmptyNames(int n, String string) {
        assert (LambdaForm.isValidSignature(string));
        int n2 = n + 1;
        if (n < 0 || string.length() != n2 + 1) {
            throw new IllegalArgumentException("bad arity for " + string);
        }
        int n3 = BasicType.basicType(string.charAt(n2)) == BasicType.V_TYPE ? 0 : 1;
        Name[] nameArray = LambdaForm.arguments(n3, string.substring(0, n));
        for (int i = 0; i < n3; ++i) {
            Name name = new Name(LambdaForm.constantZero(BasicType.basicType(string.charAt(n2 + i))), new Object[0]);
            nameArray[n + i] = name.newIndex(n + i);
        }
        return nameArray;
    }

    private static int fixResult(int n, Name[] nameArray) {
        if (n == -2) {
            n = nameArray.length - 1;
        }
        if (n >= 0 && nameArray[n].type == BasicType.V_TYPE) {
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fixDebugName(String string) {
        if (DEBUG_NAME_COUNTERS != null) {
            Integer n;
            int n2 = string.indexOf(95);
            int n3 = string.length();
            if (n2 < 0) {
                n2 = n3;
            }
            String string2 = string.substring(0, n2);
            Serializable serializable = DEBUG_NAME_COUNTERS;
            synchronized (serializable) {
                n = DEBUG_NAME_COUNTERS.get(string2);
                if (n == null) {
                    n = 0;
                }
                DEBUG_NAME_COUNTERS.put(string2, n + 1);
            }
            serializable = new StringBuilder(string2);
            ((StringBuilder)serializable).append('_');
            int n4 = ((StringBuilder)serializable).length();
            ((StringBuilder)serializable).append(n);
            for (int i = ((StringBuilder)serializable).length() - n4; i < 3; ++i) {
                ((StringBuilder)serializable).insert(n4, '0');
            }
            if (n2 < n3) {
                ++n2;
                while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
                    ++n2;
                }
                if (n2 < n3 && string.charAt(n2) == '_') {
                    ++n2;
                }
                if (n2 < n3) {
                    ((StringBuilder)serializable).append('_').append(string, n2, n3);
                }
            }
            return ((StringBuilder)serializable).toString();
        }
        return string;
    }

    private static boolean namesOK(int n, Name[] nameArray) {
        for (int i = 0; i < nameArray.length; ++i) {
            Name name = nameArray[i];
            assert (name != null) : "n is null";
            if (i < n) {
                assert (name.isParam()) : name + " is not param at " + i;
                continue;
            }
            assert (!name.isParam()) : name + " is param at " + i;
        }
        return true;
    }

    LambdaForm customize(MethodHandle methodHandle) {
        LambdaForm lambdaForm = new LambdaForm(this.debugName, this.arity, this.names, this.result, this.forceInline, methodHandle);
        if (COMPILE_THRESHOLD > 0 && this.isCompiled) {
            lambdaForm.compileToBytecode();
        }
        lambdaForm.transformCache = this;
        return lambdaForm;
    }

    LambdaForm uncustomize() {
        if (this.customized == null) {
            return this;
        }
        assert (this.transformCache != null);
        LambdaForm lambdaForm = (LambdaForm)this.transformCache;
        if (COMPILE_THRESHOLD > 0 && this.isCompiled) {
            lambdaForm.compileToBytecode();
        }
        return lambdaForm;
    }

    private int normalize() {
        int n;
        int n2;
        Name[] nameArray = null;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < this.names.length; ++n2) {
            Name name = this.names[n2];
            if (!name.initIndex(n2)) {
                if (nameArray == null) {
                    nameArray = (Name[])this.names.clone();
                    n4 = n2;
                }
                this.names[n2] = name.cloneWithIndex(n2);
            }
            if (name.arguments == null || n3 >= name.arguments.length) continue;
            n3 = name.arguments.length;
        }
        if (nameArray != null) {
            n2 = this.arity;
            if (n2 <= n4) {
                n2 = n4 + 1;
            }
            for (int i = n2; i < this.names.length; ++i) {
                Name name = this.names[i].replaceNames(nameArray, this.names, n4, i);
                this.names[i] = name.newIndex(i);
            }
        }
        assert (this.nameRefsAreLegal());
        n2 = Math.min(this.arity, 10);
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            Name name = this.names[n];
            Name name2 = LambdaForm.internArgument(name);
            if (name == name2) continue;
            this.names[n] = name2;
            bl = true;
        }
        if (bl) {
            for (n = this.arity; n < this.names.length; ++n) {
                this.names[n].internArguments();
            }
        }
        assert (this.nameRefsAreLegal());
        return n3;
    }

    boolean nameRefsAreLegal() {
        Name name;
        int n;
        assert (this.arity >= 0 && this.arity <= this.names.length);
        assert (this.result >= -1 && this.result < this.names.length);
        for (n = 0; n < this.arity; ++n) {
            name = this.names[n];
            assert (name.index() == n) : Arrays.asList(name.index(), n);
            assert (name.isParam());
        }
        for (n = this.arity; n < this.names.length; ++n) {
            name = this.names[n];
            assert (name.index() == n);
            for (Object object : name.arguments) {
                if (!(object instanceof Name)) continue;
                Name name2 = (Name)object;
                short s = name2.index;
                assert (0 <= s && s < this.names.length) : name.debugString() + ": 0 <= i2 && i2 < names.length: 0 <= " + s + " < " + this.names.length;
                assert (this.names[s] == name2) : Arrays.asList("-1-", n, "-2-", name.debugString(), "-3-", s, "-4-", name2.debugString(), "-5-", this.names[s].debugString(), "-6-", this);
                assert (s < n);
            }
        }
        return true;
    }

    BasicType returnType() {
        if (this.result < 0) {
            return BasicType.V_TYPE;
        }
        Name name = this.names[this.result];
        return name.type;
    }

    BasicType parameterType(int n) {
        return this.parameter((int)n).type;
    }

    Name parameter(int n) {
        assert (n < this.arity);
        Name name = this.names[n];
        assert (name.isParam());
        return name;
    }

    Object parameterConstraint(int n) {
        return this.parameter((int)n).constraint;
    }

    int arity() {
        return this.arity;
    }

    int expressionCount() {
        return this.names.length - this.arity;
    }

    MethodType methodType() {
        return LambdaForm.signatureType(this.basicTypeSignature());
    }

    final String basicTypeSignature() {
        StringBuilder stringBuilder = new StringBuilder(this.arity() + 3);
        int n = this.arity();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(this.parameterType(i).basicTypeChar());
        }
        return stringBuilder.append('_').append(this.returnType().basicTypeChar()).toString();
    }

    static int signatureArity(String string) {
        assert (LambdaForm.isValidSignature(string));
        return string.indexOf(95);
    }

    static BasicType signatureReturn(String string) {
        return BasicType.basicType(string.charAt(LambdaForm.signatureArity(string) + 1));
    }

    static boolean isValidSignature(String string) {
        int n = string.indexOf(95);
        if (n < 0) {
            return false;
        }
        int n2 = string.length();
        if (n2 != n + 2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            char c = string.charAt(i);
            if (c == 'V') {
                return i == n2 - 1 && n == n2 - 2;
            }
            if (BasicType.isArgBasicTypeChar(c)) continue;
            return false;
        }
        return true;
    }

    static MethodType signatureType(String string) {
        Class[] classArray = new Class[LambdaForm.signatureArity(string)];
        for (int i = 0; i < classArray.length; ++i) {
            classArray[i] = BasicType.basicType(string.charAt(i)).btClass;
        }
        Class clazz = LambdaForm.signatureReturn(string).btClass;
        return MethodType.methodType(clazz, classArray);
    }

    public void prepare() {
        if (COMPILE_THRESHOLD == 0 && !this.isCompiled) {
            this.compileToBytecode();
        }
        if (this.vmentry != null) {
            return;
        }
        LambdaForm lambdaForm = LambdaForm.getPreparedForm(this.basicTypeSignature());
        this.vmentry = lambdaForm.vmentry;
    }

    MemberName compileToBytecode() {
        if (this.vmentry != null && this.isCompiled) {
            return this.vmentry;
        }
        MethodType methodType = this.methodType();
        assert (this.vmentry == null || this.vmentry.getMethodType().basicType().equals((Object)methodType));
        try {
            this.vmentry = InvokerBytecodeGenerator.generateCustomizedCode(this, methodType);
            if (TRACE_INTERPRETER) {
                LambdaForm.traceInterpreter("compileToBytecode", this);
            }
            this.isCompiled = true;
            return this.vmentry;
        }
        catch (Error | Exception throwable) {
            throw MethodHandleStatics.newInternalError(this.toString(), throwable);
        }
    }

    private static void computeInitialPreparedForms() {
        for (MemberName memberName : MemberName.getFactory().getMethods(LambdaForm.class, false, null, null, null)) {
            MethodType methodType;
            if (!memberName.isStatic() || !memberName.isPackage() || (methodType = memberName.getMethodType()).parameterCount() <= 0 || methodType.parameterType(0) != MethodHandle.class || !memberName.getName().startsWith("interpret_")) continue;
            String string = LambdaForm.basicTypeSignature(methodType);
            assert (memberName.getName().equals("interpret" + string.substring(string.indexOf(95))));
            LambdaForm lambdaForm = new LambdaForm(string);
            lambdaForm.vmentry = memberName;
            lambdaForm = methodType.form().setCachedLambdaForm(6, lambdaForm);
        }
    }

    static Object interpret_L(MethodHandle methodHandle) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle};
        String string = null;
        if (!$assertionsDisabled) {
            string = "L_L";
            if (!LambdaForm.argumentTypesMatch("L_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object));
        return object;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LL_L";
            if (!LambdaForm.argumentTypesMatch("LL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object2 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object2));
        return object2;
    }

    static Object interpret_L(MethodHandle methodHandle, Object object, Object object2) throws Throwable {
        Object[] objectArray = new Object[]{methodHandle, object, object2};
        String string = null;
        if (!$assertionsDisabled) {
            string = "LLL_L";
            if (!LambdaForm.argumentTypesMatch("LLL_L", objectArray)) {
                throw new AssertionError();
            }
        }
        Object object3 = methodHandle.form.interpretWithArguments(objectArray);
        assert (LambdaForm.returnTypesMatch(string, objectArray, object3));
        return object3;
    }

    private static LambdaForm getPreparedForm(String string) {
        MethodType methodType = LambdaForm.signatureType(string);
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(6);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        assert (LambdaForm.isValidSignature(string));
        lambdaForm = new LambdaForm(string);
        lambdaForm.vmentry = InvokerBytecodeGenerator.generateLambdaFormInterpreterEntryPoint(string);
        return methodType.form().setCachedLambdaForm(6, lambdaForm);
    }

    private static boolean argumentTypesMatch(String string, Object[] objectArray) {
        int n = LambdaForm.signatureArity(string);
        assert (objectArray.length == n) : "av.length == arity: av.length=" + objectArray.length + ", arity=" + n;
        assert (objectArray[0] instanceof MethodHandle) : "av[0] not instace of MethodHandle: " + objectArray[0];
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        MethodType methodType = methodHandle.type();
        assert (methodType.parameterCount() == n - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            Class<MethodHandle> clazz;
            Class clazz2 = clazz = i == 0 ? MethodHandle.class : methodType.parameterType(i - 1);
            assert (LambdaForm.valueMatches(BasicType.basicType(string.charAt(i)), clazz, objectArray[i]));
        }
        return true;
    }

    private static boolean valueMatches(BasicType basicType, Class<?> clazz, Object object) {
        if (clazz == Void.TYPE) {
            basicType = BasicType.V_TYPE;
        }
        assert (basicType == BasicType.basicType(clazz)) : (Object)((Object)basicType) + " == basicType(" + clazz + ")=" + (Object)((Object)BasicType.basicType(clazz));
        switch (basicType) {
            case I_TYPE: {
                assert (LambdaForm.checkInt(clazz, object)) : "checkInt(" + clazz + "," + object + ")";
                break;
            }
            case J_TYPE: {
                assert (object instanceof Long) : "instanceof Long: " + object;
                break;
            }
            case F_TYPE: {
                assert (object instanceof Float) : "instanceof Float: " + object;
                break;
            }
            case D_TYPE: {
                assert (object instanceof Double) : "instanceof Double: " + object;
                break;
            }
            case L_TYPE: {
                assert (LambdaForm.checkRef(clazz, object)) : "checkRef(" + clazz + "," + object + ")";
                break;
            }
            case V_TYPE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return true;
    }

    private static boolean returnTypesMatch(String string, Object[] objectArray, Object object) {
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        return LambdaForm.valueMatches(LambdaForm.signatureReturn(string), methodHandle.type().returnType(), object);
    }

    private static boolean checkInt(Class<?> clazz, Object object) {
        assert (object instanceof Integer);
        if (clazz == Integer.TYPE) {
            return true;
        }
        Wrapper wrapper = Wrapper.forBasicType(clazz);
        assert (wrapper.isSubwordOrInt());
        Object object2 = Wrapper.INT.wrap(wrapper.wrap(object));
        return object.equals(object2);
    }

    private static boolean checkRef(Class<?> clazz, Object object) {
        assert (!clazz.isPrimitive());
        if (object == null) {
            return true;
        }
        if (clazz.isInterface()) {
            return true;
        }
        return clazz.isInstance(object);
    }

    @Hidden
    @DontInline
    Object interpretWithArguments(Object ... objectArray) throws Throwable {
        Object object;
        if (TRACE_INTERPRETER) {
            return this.interpretWithArgumentsTracing(objectArray);
        }
        this.checkInvocationCounter();
        assert (this.arityCheck(objectArray));
        Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
        for (int i = objectArray.length; i < objectArray2.length; ++i) {
            objectArray2[i] = this.interpretName(this.names[i], objectArray2);
        }
        Object object2 = object = this.result < 0 ? null : objectArray2[this.result];
        assert (this.resultCheck(objectArray, object));
        return object;
    }

    @Hidden
    @DontInline
    Object interpretName(Name name, Object[] objectArray) throws Throwable {
        if (TRACE_INTERPRETER) {
            LambdaForm.traceInterpreter("| interpretName", name.debugString(), null);
        }
        Object[] objectArray2 = Arrays.copyOf(name.arguments, name.arguments.length, Object[].class);
        for (int i = 0; i < objectArray2.length; ++i) {
            Object object = objectArray2[i];
            if (!(object instanceof Name)) continue;
            int n = ((Name)object).index();
            assert (this.names[n] == object);
            object = objectArray[n];
            objectArray2[i] = object;
        }
        return name.function.invokeWithArguments(objectArray2);
    }

    private void checkInvocationCounter() {
        if (COMPILE_THRESHOLD != 0 && this.invocationCounter < COMPILE_THRESHOLD) {
            ++this.invocationCounter;
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
    }

    Object interpretWithArgumentsTracing(Object ... objectArray) throws Throwable {
        Object object;
        LambdaForm.traceInterpreter("[ interpretWithArguments", this, objectArray);
        if (this.invocationCounter < COMPILE_THRESHOLD) {
            int n = this.invocationCounter++;
            LambdaForm.traceInterpreter("| invocationCounter", n);
            if (this.invocationCounter >= COMPILE_THRESHOLD) {
                this.compileToBytecode();
            }
        }
        try {
            assert (this.arityCheck(objectArray));
            Object[] objectArray2 = Arrays.copyOf(objectArray, this.names.length);
            for (int i = objectArray.length; i < objectArray2.length; ++i) {
                objectArray2[i] = this.interpretName(this.names[i], objectArray2);
            }
            object = this.result < 0 ? null : objectArray2[this.result];
        }
        catch (Throwable throwable) {
            LambdaForm.traceInterpreter("] throw =>", throwable);
            throw throwable;
        }
        LambdaForm.traceInterpreter("] return =>", object);
        return object;
    }

    static void traceInterpreter(String string, Object object, Object ... objectArray) {
        if (TRACE_INTERPRETER) {
            System.out.println("LFI: " + string + " " + (object != null ? object : "") + (objectArray != null && objectArray.length != 0 ? Arrays.asList(objectArray) : ""));
        }
    }

    static void traceInterpreter(String string, Object object) {
        LambdaForm.traceInterpreter(string, object, null);
    }

    private boolean arityCheck(Object[] objectArray) {
        assert (objectArray.length == this.arity) : this.arity + "!=" + Arrays.asList(objectArray) + ".length";
        assert (objectArray[0] instanceof MethodHandle) : "not MH: " + objectArray[0];
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        assert (methodHandle.internalForm() == this);
        LambdaForm.argumentTypesMatch(this.basicTypeSignature(), objectArray);
        return true;
    }

    private boolean resultCheck(Object[] objectArray, Object object) {
        MethodHandle methodHandle = (MethodHandle)objectArray[0];
        MethodType methodType = methodHandle.type();
        assert (LambdaForm.valueMatches(this.returnType(), methodType.returnType(), object));
        return true;
    }

    private boolean isEmpty() {
        if (this.result < 0) {
            return this.names.length == this.arity;
        }
        if (this.result == this.arity && this.names.length == this.arity + 1) {
            return this.names[this.arity].isConstantZero();
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.debugName + "=Lambda(");
        for (int i = 0; i < this.names.length; ++i) {
            if (i == this.arity) {
                stringBuilder.append(")=>{");
            }
            Name name = this.names[i];
            if (i >= this.arity) {
                stringBuilder.append("\n    ");
            }
            stringBuilder.append(name.paramString());
            if (i < this.arity) {
                if (i + 1 >= this.arity) continue;
                stringBuilder.append(",");
                continue;
            }
            stringBuilder.append("=").append(name.exprString());
            stringBuilder.append(";");
        }
        if (this.arity == this.names.length) {
            stringBuilder.append(")=>{");
        }
        stringBuilder.append(this.result < 0 ? "void" : this.names[this.result]).append("}");
        if (TRACE_INTERPRETER) {
            stringBuilder.append(":").append(this.basicTypeSignature());
            stringBuilder.append("/").append(this.vmentry);
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        return object instanceof LambdaForm && this.equals((LambdaForm)object);
    }

    public boolean equals(LambdaForm lambdaForm) {
        if (this.result != lambdaForm.result) {
            return false;
        }
        return Arrays.equals(this.names, lambdaForm.names);
    }

    public int hashCode() {
        return this.result + 31 * Arrays.hashCode(this.names);
    }

    LambdaFormEditor editor() {
        return LambdaFormEditor.lambdaFormEditor(this);
    }

    boolean contains(Name name) {
        int n = name.index();
        if (n >= 0) {
            return n < this.names.length && name.equals(this.names[n]);
        }
        for (int i = this.arity; i < this.names.length; ++i) {
            if (!name.equals(this.names[i])) continue;
            return true;
        }
        return false;
    }

    LambdaForm addArguments(int n, BasicType ... basicTypeArray) {
        int n2 = n + 1;
        assert (n2 <= this.arity);
        int n3 = this.names.length;
        int n4 = basicTypeArray.length;
        Name[] nameArray = Arrays.copyOf(this.names, n3 + n4);
        int n5 = this.arity + n4;
        int n6 = this.result;
        if (n6 >= n2) {
            n6 += n4;
        }
        System.arraycopy(this.names, n2, nameArray, n2 + n4, n3 - n2);
        for (int i = 0; i < n4; ++i) {
            nameArray[n2 + i] = new Name(basicTypeArray[i]);
        }
        return new LambdaForm(this.debugName, n5, nameArray, n6);
    }

    LambdaForm addArguments(int n, List<Class<?>> list) {
        return this.addArguments(n, BasicType.basicTypes(list));
    }

    LambdaForm permuteArguments(int n, int[] nArray, BasicType[] basicTypeArray) {
        int n2;
        Name name;
        int n3;
        int n4;
        int n5 = this.names.length;
        int n6 = basicTypeArray.length;
        int n7 = nArray.length;
        assert (n + n7 == this.arity);
        assert (LambdaForm.permutedTypesMatch(nArray, basicTypeArray, this.names, n));
        for (n4 = 0; n4 < n7 && nArray[n4] == n4; ++n4) {
        }
        Name[] nameArray = new Name[n5 - n7 + n6];
        System.arraycopy(this.names, 0, nameArray, 0, n + n4);
        int n8 = n5 - this.arity;
        System.arraycopy(this.names, n + n7, nameArray, n + n6, n8);
        int n9 = nameArray.length - n8;
        int n10 = this.result;
        if (n10 >= 0) {
            n10 = n10 < n + n7 ? nArray[n10 - n] : n10 - n7 + n6;
        }
        for (n3 = n4; n3 < n7; ++n3) {
            Name name2 = this.names[n + n3];
            int n11 = nArray[n3];
            name = nameArray[n + n11];
            if (name == null) {
                nameArray[n + n11] = name = new Name(basicTypeArray[n11]);
            } else assert (name.type == basicTypeArray[n11]);
            for (n2 = n9; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name2, name);
            }
        }
        for (n3 = n + n4; n3 < n9; ++n3) {
            if (nameArray[n3] != null) continue;
            nameArray[n3] = LambdaForm.argument(n3, basicTypeArray[n3 - n]);
        }
        for (n3 = this.arity; n3 < this.names.length; ++n3) {
            Name name3 = this.names[n3];
            int n12 = n3 - this.arity + n9;
            name = nameArray[n12];
            if (name3 == name) continue;
            for (n2 = n12 + 1; n2 < nameArray.length; ++n2) {
                nameArray[n2] = nameArray[n2].replaceName(name3, name);
            }
        }
        return new LambdaForm(this.debugName, n9, nameArray, n10);
    }

    static boolean permutedTypesMatch(int[] nArray, BasicType[] basicTypeArray, Name[] nameArray, int n) {
        int n2 = basicTypeArray.length;
        int n3 = nArray.length;
        for (int i = 0; i < n3; ++i) {
            assert (nameArray[n + i].isParam());
            assert (nameArray[n + i].type == basicTypeArray[nArray[i]]);
        }
        return true;
    }

    public static String basicTypeSignature(MethodType methodType) {
        char[] cArray = new char[methodType.parameterCount() + 2];
        int n = 0;
        for (Class<?> clazz : methodType.parameterList()) {
            cArray[n++] = BasicType.basicTypeChar(clazz);
        }
        cArray[n++] = 95;
        cArray[n++] = BasicType.basicTypeChar(methodType.returnType());
        assert (n == cArray.length);
        return String.valueOf(cArray);
    }

    public static String shortenSignature(String string) {
        int n = -1;
        int n2 = 0;
        StringBuilder stringBuilder = null;
        int n3 = string.length();
        if (n3 < 3) {
            return string;
        }
        for (int i = 0; i <= n3; ++i) {
            int n4 = n;
            int n5 = n = i == n3 ? -1 : (int)string.charAt(i);
            if (n == n4) {
                ++n2;
                continue;
            }
            int n6 = n2;
            n2 = 1;
            if (n6 < 3) {
                if (stringBuilder == null) continue;
                while (--n6 >= 0) {
                    stringBuilder.append((char)n4);
                }
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder().append(string, 0, i - n6);
            }
            stringBuilder.append((char)n4).append(n6);
        }
        return stringBuilder == null ? string : stringBuilder.toString();
    }

    int lastUseIndex(Name name) {
        short s = name.index;
        int n = this.names.length;
        assert (this.names[s] == name);
        if (this.result == s) {
            return n;
        }
        int n2 = n;
        while (--n2 > s) {
            if (this.names[n2].lastUseIndex(name) < 0) continue;
            return n2;
        }
        return -1;
    }

    int useCount(Name name) {
        int n;
        short s = name.index;
        int n2 = this.names.length;
        int n3 = this.lastUseIndex(name);
        if (n3 < 0) {
            return 0;
        }
        int n4 = 0;
        if (n3 == n2) {
            ++n4;
            --n3;
        }
        if ((n = name.index() + 1) < this.arity) {
            n = this.arity;
        }
        for (int i = n; i <= n3; ++i) {
            n4 += this.names[i].useCount(name);
        }
        return n4;
    }

    static Name argument(int n, char c) {
        return LambdaForm.argument(n, BasicType.basicType(c));
    }

    static Name argument(int n, BasicType basicType) {
        if (n >= 10) {
            return new Name(n, basicType);
        }
        return INTERNED_ARGUMENTS[basicType.ordinal()][n];
    }

    static Name internArgument(Name name) {
        assert (name.isParam()) : "not param: " + name;
        assert (name.index < 10);
        if (name.constraint != null) {
            return name;
        }
        return LambdaForm.argument((int)name.index, name.type);
    }

    static Name[] arguments(int n, String string) {
        int n2 = string.length();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, string.charAt(i));
        }
        return nameArray;
    }

    static Name[] arguments(int n, char ... cArray) {
        int n2 = cArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, cArray[i]);
        }
        return nameArray;
    }

    static Name[] arguments(int n, List<Class<?>> list) {
        int n2 = list.size();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, BasicType.basicType(list.get(i)));
        }
        return nameArray;
    }

    static Name[] arguments(int n, Class<?> ... classArray) {
        int n2 = classArray.length;
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, BasicType.basicType(classArray[i]));
        }
        return nameArray;
    }

    static Name[] arguments(int n, MethodType methodType) {
        int n2 = methodType.parameterCount();
        Name[] nameArray = new Name[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nameArray[i] = LambdaForm.argument(i, BasicType.basicType(methodType.parameterType(i)));
        }
        return nameArray;
    }

    static LambdaForm identityForm(BasicType basicType) {
        return LF_identityForm[basicType.ordinal()];
    }

    static LambdaForm zeroForm(BasicType basicType) {
        return LF_zeroForm[basicType.ordinal()];
    }

    static NamedFunction identity(BasicType basicType) {
        return NF_identity[basicType.ordinal()];
    }

    static NamedFunction constantZero(BasicType basicType) {
        return NF_zero[basicType.ordinal()];
    }

    private static void createIdentityForms() {
        MemberName memberName;
        Object object;
        Object object2;
        Object object3;
        int n;
        for (BasicType basicType : BasicType.ALL_TYPES) {
            LambdaForm lambdaForm;
            LambdaForm lambdaForm2;
            Object object4;
            n = basicType.ordinal();
            char c = basicType.basicTypeChar();
            boolean bl = basicType == BasicType.V_TYPE;
            object3 = basicType.btClass;
            object2 = MethodType.methodType(object3);
            object = bl ? object2 : ((MethodType)object2).appendParameterTypes(new Class[]{object3});
            memberName = new MemberName(LambdaForm.class, "identity_" + c, (MethodType)object, 6);
            MemberName memberName2 = new MemberName(LambdaForm.class, "zero_" + c, (MethodType)object2, 6);
            try {
                memberName2 = IMPL_NAMES.resolveOrFail((byte)6, memberName2, null, NoSuchMethodException.class);
                memberName = IMPL_NAMES.resolveOrFail((byte)6, memberName, null, NoSuchMethodException.class);
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
            NamedFunction namedFunction = new NamedFunction(memberName);
            if (bl) {
                object4 = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE)};
                lambdaForm2 = new LambdaForm(memberName.getName(), 1, (Name[])object4, -1);
            } else {
                object4 = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), LambdaForm.argument(1, basicType)};
                lambdaForm2 = new LambdaForm(memberName.getName(), 2, (Name[])object4, 1);
            }
            LambdaForm.LF_identityForm[n] = lambdaForm2;
            LambdaForm.NF_identity[n] = namedFunction;
            object4 = new NamedFunction(memberName2);
            if (bl) {
                lambdaForm = lambdaForm2;
            } else {
                Object object5 = Wrapper.forBasicType(c).zero();
                Name[] nameArray = new Name[]{LambdaForm.argument(0, BasicType.L_TYPE), new Name(namedFunction, object5)};
                lambdaForm = new LambdaForm(memberName2.getName(), 1, nameArray, 1);
            }
            LambdaForm.LF_zeroForm[n] = lambdaForm;
            LambdaForm.NF_zero[n] = object4;
            assert (namedFunction.isIdentity());
            assert (((NamedFunction)object4).isConstantZero());
            assert (new Name((NamedFunction)object4, new Object[0]).isConstantZero());
        }
        for (BasicType basicType : BasicType.ALL_TYPES) {
            n = basicType.ordinal();
            NamedFunction namedFunction = NF_identity[n];
            LambdaForm lambdaForm = LF_identityForm[n];
            object3 = namedFunction.member;
            namedFunction.resolvedHandle = SimpleMethodHandle.make(((MemberName)object3).getInvocationType(), lambdaForm);
            object2 = NF_zero[n];
            object = LF_zeroForm[n];
            memberName = ((NamedFunction)object2).member;
            ((NamedFunction)object2).resolvedHandle = SimpleMethodHandle.make(memberName.getInvocationType(), (LambdaForm)object);
            assert (namedFunction.isIdentity());
            assert (((NamedFunction)object2).isConstantZero());
            assert (new Name((NamedFunction)object2, new Object[0]).isConstantZero());
        }
    }

    private static int identity_I(int n) {
        return n;
    }

    private static long identity_J(long l) {
        return l;
    }

    private static float identity_F(float f) {
        return f;
    }

    private static double identity_D(double d) {
        return d;
    }

    private static Object identity_L(Object object) {
        return object;
    }

    private static void identity_V() {
    }

    private static int zero_I() {
        return 0;
    }

    private static long zero_J() {
        return 0L;
    }

    private static float zero_F() {
        return 0.0f;
    }

    private static double zero_D() {
        return 0.0;
    }

    private static Object zero_L() {
        return null;
    }

    private static void zero_V() {
    }

    static {
        for (BasicType basicType : BasicType.ARG_TYPES) {
            int n = basicType.ordinal();
            for (int i = 0; i < INTERNED_ARGUMENTS[n].length; ++i) {
                LambdaForm.INTERNED_ARGUMENTS[n][i] = new Name(i, basicType);
            }
        }
        IMPL_NAMES = MemberName.getFactory();
        LF_identityForm = new LambdaForm[BasicType.TYPE_LIMIT];
        LF_zeroForm = new LambdaForm[BasicType.TYPE_LIMIT];
        NF_identity = new NamedFunction[BasicType.TYPE_LIMIT];
        NF_zero = new NamedFunction[BasicType.TYPE_LIMIT];
        DEBUG_NAME_COUNTERS = MethodHandleStatics.debugEnabled() ? new HashMap() : null;
        LambdaForm.createIdentityForms();
        LambdaForm.computeInitialPreparedForms();
        NamedFunction.initializeInvokers();
        TRACE_INTERPRETER = MethodHandleStatics.TRACE_INTERPRETER;
    }

    static final class BasicType
    extends Enum<BasicType> {
        public static final /* enum */ BasicType L_TYPE = new BasicType('L', Object.class, Wrapper.OBJECT);
        public static final /* enum */ BasicType I_TYPE = new BasicType('I', Integer.TYPE, Wrapper.INT);
        public static final /* enum */ BasicType J_TYPE = new BasicType('J', Long.TYPE, Wrapper.LONG);
        public static final /* enum */ BasicType F_TYPE = new BasicType('F', Float.TYPE, Wrapper.FLOAT);
        public static final /* enum */ BasicType D_TYPE = new BasicType('D', Double.TYPE, Wrapper.DOUBLE);
        public static final /* enum */ BasicType V_TYPE = new BasicType('V', Void.TYPE, Wrapper.VOID);
        static final BasicType[] ALL_TYPES;
        static final BasicType[] ARG_TYPES;
        static final int ARG_TYPE_LIMIT;
        static final int TYPE_LIMIT;
        private final char btChar;
        private final Class<?> btClass;
        private final Wrapper btWrapper;
        private static final /* synthetic */ BasicType[] $VALUES;

        public static BasicType[] values() {
            return (BasicType[])$VALUES.clone();
        }

        public static BasicType valueOf(String string) {
            return Enum.valueOf(BasicType.class, string);
        }

        private BasicType(char c, Class<?> clazz, Wrapper wrapper) {
            this.btChar = c;
            this.btClass = clazz;
            this.btWrapper = wrapper;
        }

        char basicTypeChar() {
            return this.btChar;
        }

        Class<?> basicTypeClass() {
            return this.btClass;
        }

        Wrapper basicTypeWrapper() {
            return this.btWrapper;
        }

        int basicTypeSlots() {
            return this.btWrapper.stackSlots();
        }

        static BasicType basicType(byte by) {
            return ALL_TYPES[by];
        }

        static BasicType basicType(char c) {
            switch (c) {
                case 'L': {
                    return L_TYPE;
                }
                case 'I': {
                    return I_TYPE;
                }
                case 'J': {
                    return J_TYPE;
                }
                case 'F': {
                    return F_TYPE;
                }
                case 'D': {
                    return D_TYPE;
                }
                case 'V': {
                    return V_TYPE;
                }
                case 'B': 
                case 'C': 
                case 'S': 
                case 'Z': {
                    return I_TYPE;
                }
            }
            throw MethodHandleStatics.newInternalError("Unknown type char: '" + c + "'");
        }

        static BasicType basicType(Wrapper wrapper) {
            char c = wrapper.basicTypeChar();
            return BasicType.basicType(c);
        }

        static BasicType basicType(Class<?> clazz) {
            if (!clazz.isPrimitive()) {
                return L_TYPE;
            }
            return BasicType.basicType(Wrapper.forPrimitiveType(clazz));
        }

        static char basicTypeChar(Class<?> clazz) {
            return BasicType.basicType(clazz).btChar;
        }

        static BasicType[] basicTypes(List<Class<?>> list) {
            BasicType[] basicTypeArray = new BasicType[list.size()];
            for (int i = 0; i < basicTypeArray.length; ++i) {
                basicTypeArray[i] = BasicType.basicType(list.get(i));
            }
            return basicTypeArray;
        }

        static BasicType[] basicTypes(String string) {
            BasicType[] basicTypeArray = new BasicType[string.length()];
            for (int i = 0; i < basicTypeArray.length; ++i) {
                basicTypeArray[i] = BasicType.basicType(string.charAt(i));
            }
            return basicTypeArray;
        }

        static byte[] basicTypesOrd(BasicType[] basicTypeArray) {
            byte[] byArray = new byte[basicTypeArray.length];
            for (int i = 0; i < basicTypeArray.length; ++i) {
                byArray[i] = (byte)basicTypeArray[i].ordinal();
            }
            return byArray;
        }

        static boolean isBasicTypeChar(char c) {
            return "LIJFDV".indexOf(c) >= 0;
        }

        static boolean isArgBasicTypeChar(char c) {
            return "LIJFD".indexOf(c) >= 0;
        }

        private static boolean checkBasicType() {
            int n;
            for (n = 0; n < ARG_TYPE_LIMIT; ++n) {
                assert (ARG_TYPES[n].ordinal() == n);
                assert (ARG_TYPES[n] == ALL_TYPES[n]);
            }
            for (n = 0; n < TYPE_LIMIT; ++n) {
                assert (ALL_TYPES[n].ordinal() == n);
            }
            assert (ALL_TYPES[TYPE_LIMIT - 1] == V_TYPE);
            assert (!Arrays.asList(ARG_TYPES).contains((Object)V_TYPE));
            return true;
        }

        static {
            $VALUES = new BasicType[]{L_TYPE, I_TYPE, J_TYPE, F_TYPE, D_TYPE, V_TYPE};
            ALL_TYPES = BasicType.values();
            ARG_TYPES = Arrays.copyOf(ALL_TYPES, ALL_TYPES.length - 1);
            ARG_TYPE_LIMIT = ARG_TYPES.length;
            TYPE_LIMIT = ALL_TYPES.length;
            assert (BasicType.checkBasicType());
        }
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Compiled {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Hidden {
    }

    static final class Name {
        final BasicType type;
        private short index;
        final NamedFunction function;
        final Object constraint;
        @Stable
        final Object[] arguments;

        private Name(int n, BasicType basicType, NamedFunction namedFunction, Object[] objectArray) {
            this.index = (short)n;
            this.type = basicType;
            this.function = namedFunction;
            this.arguments = objectArray;
            this.constraint = null;
            assert (this.index == n);
        }

        private Name(Name name, Object object) {
            this.index = name.index;
            this.type = name.type;
            this.function = name.function;
            this.arguments = name.arguments;
            this.constraint = object;
            assert (object == null || this.isParam());
            assert (object == null || object instanceof BoundMethodHandle.SpeciesData || object instanceof Class);
        }

        Name(MethodHandle methodHandle, Object ... objectArray) {
            this(new NamedFunction(methodHandle), objectArray);
        }

        Name(MethodType methodType, Object ... objectArray) {
            this(new NamedFunction(methodType), objectArray);
            assert (objectArray[0] instanceof Name && ((Name)objectArray[0]).type == BasicType.L_TYPE);
        }

        Name(MemberName memberName, Object ... objectArray) {
            this(new NamedFunction(memberName), objectArray);
        }

        Name(NamedFunction namedFunction, Object ... objectArray) {
            objectArray = Arrays.copyOf(objectArray, objectArray.length, Object[].class);
            this(-1, namedFunction.returnType(), namedFunction, objectArray);
            assert (objectArray.length == namedFunction.arity()) : "arity mismatch: arguments.length=" + objectArray.length + " == function.arity()=" + namedFunction.arity() + " in " + this.debugString();
            for (int i = 0; i < objectArray.length; ++i) {
                assert (Name.typesMatch(namedFunction.parameterType(i), objectArray[i])) : "types don't match: function.parameterType(" + i + ")=" + (Object)((Object)namedFunction.parameterType(i)) + ", arguments[" + i + "]=" + objectArray[i] + " in " + this.debugString();
            }
        }

        Name(int n, BasicType basicType) {
            this(n, basicType, null, null);
        }

        Name(BasicType basicType) {
            this(-1, basicType);
        }

        BasicType type() {
            return this.type;
        }

        int index() {
            return this.index;
        }

        boolean initIndex(int n) {
            if (this.index != n) {
                if (this.index != -1) {
                    return false;
                }
                this.index = (short)n;
            }
            return true;
        }

        char typeChar() {
            return this.type.btChar;
        }

        void resolve() {
            if (this.function != null) {
                this.function.resolve();
            }
        }

        Name newIndex(int n) {
            if (this.initIndex(n)) {
                return this;
            }
            return this.cloneWithIndex(n);
        }

        Name cloneWithIndex(int n) {
            Object[] objectArray = this.arguments == null ? null : (Object[])this.arguments.clone();
            return new Name(n, this.type, this.function, objectArray).withConstraint(this.constraint);
        }

        Name withConstraint(Object object) {
            if (object == this.constraint) {
                return this;
            }
            return new Name(this, object);
        }

        Name replaceName(Name name, Name name2) {
            if (name == name2) {
                return this;
            }
            Object[] objectArray = this.arguments;
            if (objectArray == null) {
                return this;
            }
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != name) continue;
                if (!bl) {
                    bl = true;
                    objectArray = (Object[])objectArray.clone();
                }
                objectArray[i] = name2;
            }
            if (!bl) {
                return this;
            }
            return new Name(this.function, objectArray);
        }

        Name replaceNames(Name[] nameArray, Name[] nameArray2, int n, int n2) {
            if (n >= n2) {
                return this;
            }
            Object[] objectArray = this.arguments;
            boolean bl = false;
            block0: for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Name)) continue;
                Name name = (Name)objectArray[i];
                short s = name.index;
                if (s >= 0 && s < nameArray2.length && name == nameArray2[s]) continue;
                for (int j = n; j < n2; ++j) {
                    if (name != nameArray[j]) continue;
                    if (name == nameArray2[j]) continue block0;
                    if (!bl) {
                        bl = true;
                        objectArray = (Object[])objectArray.clone();
                    }
                    objectArray[i] = nameArray2[j];
                    continue block0;
                }
            }
            if (!bl) {
                return this;
            }
            return new Name(this.function, objectArray);
        }

        void internArguments() {
            Object[] objectArray = this.arguments;
            for (int i = 0; i < objectArray.length; ++i) {
                Name name;
                if (!(objectArray[i] instanceof Name) || !(name = (Name)objectArray[i]).isParam() || name.index >= 10) continue;
                objectArray[i] = LambdaForm.internArgument(name);
            }
        }

        boolean isParam() {
            return this.function == null;
        }

        boolean isConstantZero() {
            return !this.isParam() && this.arguments.length == 0 && this.function.isConstantZero();
        }

        public String toString() {
            return (this.isParam() ? "a" : "t") + (this.index >= 0 ? this.index : System.identityHashCode(this)) + ":" + this.typeChar();
        }

        public String debugString() {
            String string = this.paramString();
            return this.function == null ? string : string + "=" + this.exprString();
        }

        public String paramString() {
            String string = this.toString();
            Object object = this.constraint;
            if (object == null) {
                return string;
            }
            if (object instanceof Class) {
                object = ((Class)object).getSimpleName();
            }
            return string + "/" + object;
        }

        public String exprString() {
            if (this.function == null) {
                return this.toString();
            }
            StringBuilder stringBuilder = new StringBuilder(this.function.toString());
            stringBuilder.append("(");
            String string = "";
            for (Object object : this.arguments) {
                stringBuilder.append(string);
                string = ",";
                if (object instanceof Name || object instanceof Integer) {
                    stringBuilder.append(object);
                    continue;
                }
                stringBuilder.append("(").append(object).append(")");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }

        static boolean typesMatch(BasicType basicType, Object object) {
            if (object instanceof Name) {
                return ((Name)object).type == basicType;
            }
            switch (basicType) {
                case I_TYPE: {
                    return object instanceof Integer;
                }
                case J_TYPE: {
                    return object instanceof Long;
                }
                case F_TYPE: {
                    return object instanceof Float;
                }
                case D_TYPE: {
                    return object instanceof Double;
                }
            }
            assert (basicType == BasicType.L_TYPE);
            return true;
        }

        int lastUseIndex(Name name) {
            if (this.arguments == null) {
                return -1;
            }
            int n = this.arguments.length;
            while (--n >= 0) {
                if (this.arguments[n] != name) continue;
                return n;
            }
            return -1;
        }

        int useCount(Name name) {
            if (this.arguments == null) {
                return 0;
            }
            int n = 0;
            int n2 = this.arguments.length;
            while (--n2 >= 0) {
                if (this.arguments[n2] != name) continue;
                ++n;
            }
            return n;
        }

        boolean contains(Name name) {
            return this == name || this.lastUseIndex(name) >= 0;
        }

        public boolean equals(Name name) {
            if (this == name) {
                return true;
            }
            if (this.isParam()) {
                return false;
            }
            return this.type == name.type && this.function.equals(name.function) && Arrays.equals(this.arguments, name.arguments);
        }

        public boolean equals(Object object) {
            return object instanceof Name && this.equals((Name)object);
        }

        public int hashCode() {
            if (this.isParam()) {
                return this.index | this.type.ordinal() << 8;
            }
            return this.function.hashCode() ^ Arrays.hashCode(this.arguments);
        }
    }

    static class NamedFunction {
        final MemberName member;
        @Stable
        MethodHandle resolvedHandle;
        @Stable
        MethodHandle invoker;
        static final MethodType INVOKER_METHOD_TYPE = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);

        NamedFunction(MethodHandle methodHandle) {
            this(methodHandle.internalMemberName(), methodHandle);
        }

        NamedFunction(MemberName memberName, MethodHandle methodHandle) {
            this.member = memberName;
            this.resolvedHandle = methodHandle;
        }

        NamedFunction(MethodType methodType) {
            assert (methodType == methodType.basicType()) : methodType;
            if (methodType.parameterSlotCount() < 253) {
                this.resolvedHandle = methodType.invokers().basicInvoker();
                this.member = this.resolvedHandle.internalMemberName();
            } else {
                this.member = Invokers.invokeBasicMethod(methodType);
            }
            assert (this.isInvokeBasic());
        }

        private boolean isInvokeBasic() {
            return this.member != null && this.member.isMethodHandleInvoke() && "invokeBasic".equals(this.member.getName());
        }

        NamedFunction(Method method) {
            this(new MemberName(method));
        }

        NamedFunction(Field field) {
            this(new MemberName(field));
        }

        NamedFunction(MemberName memberName) {
            this.member = memberName;
            this.resolvedHandle = null;
        }

        MethodHandle resolvedHandle() {
            if (this.resolvedHandle == null) {
                this.resolve();
            }
            return this.resolvedHandle;
        }

        void resolve() {
            this.resolvedHandle = DirectMethodHandle.make(this.member);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof NamedFunction)) {
                return false;
            }
            NamedFunction namedFunction = (NamedFunction)object;
            return this.member != null && this.member.equals(namedFunction.member);
        }

        public int hashCode() {
            if (this.member != null) {
                return this.member.hashCode();
            }
            return super.hashCode();
        }

        static void initializeInvokers() {
            for (MemberName memberName : MemberName.getFactory().getMethods(NamedFunction.class, false, null, null, null)) {
                MethodType methodType;
                if (!memberName.isStatic() || !memberName.isPackage() || !(methodType = memberName.getMethodType()).equals((Object)INVOKER_METHOD_TYPE) || !memberName.getName().startsWith("invoke_")) continue;
                String string = memberName.getName().substring("invoke_".length());
                int n = LambdaForm.signatureArity(string);
                MethodType methodType2 = MethodType.genericMethodType(n);
                if (LambdaForm.signatureReturn(string) == BasicType.V_TYPE) {
                    methodType2 = methodType2.changeReturnType(Void.TYPE);
                }
                MethodTypeForm methodTypeForm = methodType2.form();
                methodTypeForm.setCachedMethodHandle(1, DirectMethodHandle.make(memberName));
            }
        }

        @Hidden
        static Object invoke__V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(0, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic();
            return null;
        }

        @Hidden
        static Object invoke_L_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(1, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic(objectArray[0]);
            return null;
        }

        @Hidden
        static Object invoke_LL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(2, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic(objectArray[0], objectArray[1]);
            return null;
        }

        @Hidden
        static Object invoke_LLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(3, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2]);
            return null;
        }

        @Hidden
        static Object invoke_LLLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(4, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
            return null;
        }

        @Hidden
        static Object invoke_LLLLL_V(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(5, Void.TYPE, methodHandle, objectArray));
            methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
            return null;
        }

        @Hidden
        static Object invoke__L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(0, methodHandle, objectArray));
            return methodHandle.invokeBasic();
        }

        @Hidden
        static Object invoke_L_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(1, methodHandle, objectArray));
            return methodHandle.invokeBasic(objectArray[0]);
        }

        @Hidden
        static Object invoke_LL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(2, methodHandle, objectArray));
            return methodHandle.invokeBasic(objectArray[0], objectArray[1]);
        }

        @Hidden
        static Object invoke_LLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(3, methodHandle, objectArray));
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2]);
        }

        @Hidden
        static Object invoke_LLLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(4, methodHandle, objectArray));
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3]);
        }

        @Hidden
        static Object invoke_LLLLL_L(MethodHandle methodHandle, Object[] objectArray) throws Throwable {
            assert (NamedFunction.arityCheck(5, methodHandle, objectArray));
            return methodHandle.invokeBasic(objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4]);
        }

        private static boolean arityCheck(int n, MethodHandle methodHandle, Object[] objectArray) {
            return NamedFunction.arityCheck(n, Object.class, methodHandle, objectArray);
        }

        private static boolean arityCheck(int n, Class<?> clazz, MethodHandle methodHandle, Object[] objectArray) {
            assert (objectArray.length == n) : Arrays.asList(objectArray.length, n);
            assert (methodHandle.type().basicType() == MethodType.genericMethodType(n).changeReturnType(clazz)) : Arrays.asList(methodHandle, clazz, n);
            MemberName memberName = methodHandle.internalMemberName();
            if (memberName != null && memberName.getName().equals("invokeBasic") && memberName.isMethodHandleInvoke()) {
                assert (n > 0);
                assert (objectArray[0] instanceof MethodHandle);
                MethodHandle methodHandle2 = (MethodHandle)objectArray[0];
                assert (methodHandle2.type().basicType() == MethodType.genericMethodType(n - 1).changeReturnType(clazz)) : Arrays.asList(memberName, methodHandle2, clazz, n);
            }
            return true;
        }

        private static MethodHandle computeInvoker(MethodTypeForm methodTypeForm) {
            MethodHandle methodHandle = (methodTypeForm = methodTypeForm.basicType().form()).cachedMethodHandle(1);
            if (methodHandle != null) {
                return methodHandle;
            }
            MemberName memberName = InvokerBytecodeGenerator.generateNamedFunctionInvoker(methodTypeForm);
            methodHandle = DirectMethodHandle.make(memberName);
            MethodHandle methodHandle2 = methodTypeForm.cachedMethodHandle(1);
            if (methodHandle2 != null) {
                return methodHandle2;
            }
            if (!methodHandle.type().equals((Object)INVOKER_METHOD_TYPE)) {
                throw MethodHandleStatics.newInternalError(methodHandle.debugString());
            }
            return methodTypeForm.setCachedMethodHandle(1, methodHandle);
        }

        @Hidden
        Object invokeWithArguments(Object ... objectArray) throws Throwable {
            if (TRACE_INTERPRETER) {
                return this.invokeWithArgumentsTracing(objectArray);
            }
            assert (NamedFunction.checkArgumentTypes(objectArray, this.methodType()));
            return this.invoker().invokeBasic(this.resolvedHandle(), objectArray);
        }

        @Hidden
        Object invokeWithArgumentsTracing(Object[] objectArray) throws Throwable {
            Object object;
            try {
                LambdaForm.traceInterpreter("[ call", this, objectArray);
                if (this.invoker == null) {
                    LambdaForm.traceInterpreter("| getInvoker", this);
                    this.invoker();
                }
                if (this.resolvedHandle == null) {
                    LambdaForm.traceInterpreter("| resolve", this);
                    this.resolvedHandle();
                }
                assert (NamedFunction.checkArgumentTypes(objectArray, this.methodType()));
                object = this.invoker().invokeBasic(this.resolvedHandle(), objectArray);
            }
            catch (Throwable throwable) {
                LambdaForm.traceInterpreter("] throw =>", throwable);
                throw throwable;
            }
            LambdaForm.traceInterpreter("] return =>", object);
            return object;
        }

        private MethodHandle invoker() {
            if (this.invoker != null) {
                return this.invoker;
            }
            this.invoker = NamedFunction.computeInvoker(this.methodType().form());
            return this.invoker;
        }

        private static boolean checkArgumentTypes(Object[] objectArray, MethodType methodType) {
            return true;
        }

        MethodType methodType() {
            if (this.resolvedHandle != null) {
                return this.resolvedHandle.type();
            }
            return this.member.getInvocationType();
        }

        MemberName member() {
            assert (this.assertMemberIsConsistent());
            return this.member;
        }

        private boolean assertMemberIsConsistent() {
            if (this.resolvedHandle instanceof DirectMethodHandle) {
                MemberName memberName = this.resolvedHandle.internalMemberName();
                assert (memberName.equals(this.member));
            }
            return true;
        }

        Class<?> memberDeclaringClassOrNull() {
            return this.member == null ? null : this.member.getDeclaringClass();
        }

        BasicType returnType() {
            return BasicType.basicType(this.methodType().returnType());
        }

        BasicType parameterType(int n) {
            return BasicType.basicType(this.methodType().parameterType(n));
        }

        int arity() {
            return this.methodType().parameterCount();
        }

        public String toString() {
            if (this.member == null) {
                return String.valueOf(this.resolvedHandle);
            }
            return this.member.getDeclaringClass().getSimpleName() + "." + this.member.getName();
        }

        public boolean isIdentity() {
            return this.equals(LambdaForm.identity(this.returnType()));
        }

        public boolean isConstantZero() {
            return this.equals(LambdaForm.constantZero(this.returnType()));
        }

        public MethodHandleImpl.Intrinsic intrinsicName() {
            return this.resolvedHandle == null ? MethodHandleImpl.Intrinsic.NONE : this.resolvedHandle.intrinsicName();
        }
    }
}

