/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.provider;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.server.AsyncProvider;
import com.sun.xml.internal.ws.resources.ServerMessages;
import com.sun.xml.internal.ws.spi.db.BindingHelper;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.activation.DataSource;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import javax.xml.ws.Provider;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPBinding;

final class ProviderEndpointModel<T> {
    final boolean isAsync;
    @NotNull
    final Service.Mode mode;
    @NotNull
    final Class datatype;
    @NotNull
    final Class implClass;

    ProviderEndpointModel(Class<T> clazz, WSBinding wSBinding) {
        assert (clazz != null);
        assert (wSBinding != null);
        this.implClass = clazz;
        this.mode = ProviderEndpointModel.getServiceMode(clazz);
        Class clazz2 = wSBinding instanceof SOAPBinding ? SOAPMessage.class : DataSource.class;
        this.isAsync = AsyncProvider.class.isAssignableFrom(clazz);
        Class clazz3 = this.isAsync ? AsyncProvider.class : Provider.class;
        Type type = BindingHelper.getBaseType(clazz, clazz3);
        if (type == null) {
            throw new WebServiceException(ServerMessages.NOT_IMPLEMENT_PROVIDER(clazz.getName()));
        }
        if (!(type instanceof ParameterizedType)) {
            throw new WebServiceException(ServerMessages.PROVIDER_NOT_PARAMETERIZED(clazz.getName()));
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type[] typeArray = parameterizedType.getActualTypeArguments();
        if (!(typeArray[0] instanceof Class)) {
            throw new WebServiceException(ServerMessages.PROVIDER_INVALID_PARAMETER_TYPE(clazz.getName(), typeArray[0]));
        }
        this.datatype = (Class)typeArray[0];
        if (this.mode == Service.Mode.PAYLOAD && this.datatype != Source.class) {
            throw new IllegalArgumentException("Illeagal combination - Mode.PAYLOAD and Provider<" + clazz2.getName() + ">");
        }
    }

    private static Service.Mode getServiceMode(Class<?> clazz) {
        ServiceMode serviceMode = clazz.getAnnotation(ServiceMode.class);
        return serviceMode == null ? Service.Mode.PAYLOAD : serviceMode.value();
    }
}

