/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.message.saaj;

import com.sun.istack.internal.FragmentContentHandler;
import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.istack.internal.XMLStreamException2;
import com.sun.xml.internal.bind.api.Bridge;
import com.sun.xml.internal.bind.unmarshaller.DOMScanner;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentEx;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Header;
import com.sun.xml.internal.ws.api.message.HeaderList;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.MessageHeaders;
import com.sun.xml.internal.ws.message.AttachmentUnmarshallerImpl;
import com.sun.xml.internal.ws.message.saaj.SAAJHeader;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import com.sun.xml.internal.ws.streaming.DOMStreamReader;
import com.sun.xml.internal.ws.util.ASCIIUtility;
import com.sun.xml.internal.ws.util.DOMUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAAJMessage
extends Message {
    private boolean parsedMessage;
    private boolean accessedMessage;
    private final SOAPMessage sm;
    private MessageHeaders headers;
    private List<Element> bodyParts;
    private Element payload;
    private String payloadLocalName;
    private String payloadNamespace;
    private SOAPVersion soapVersion;
    private NamedNodeMap bodyAttrs;
    private NamedNodeMap headerAttrs;
    private NamedNodeMap envelopeAttrs;
    private static final AttributesImpl EMPTY_ATTS = new AttributesImpl();
    private static final LocatorImpl NULL_LOCATOR = new LocatorImpl();
    private XMLStreamReader soapBodyFirstChildReader;
    private SOAPElement soapBodyFirstChild;

    public SAAJMessage(SOAPMessage sOAPMessage) {
        this.sm = sOAPMessage;
    }

    private SAAJMessage(MessageHeaders messageHeaders, AttachmentSet attachmentSet, SOAPMessage sOAPMessage, SOAPVersion sOAPVersion) {
        this.sm = sOAPMessage;
        this.parse();
        if (messageHeaders == null) {
            messageHeaders = new HeaderList(sOAPVersion);
        }
        this.headers = messageHeaders;
        this.attachmentSet = attachmentSet;
    }

    private void parse() {
        if (!this.parsedMessage) {
            try {
                SOAPHeader sOAPHeader;
                this.access();
                if (this.headers == null) {
                    this.headers = new HeaderList(this.getSOAPVersion());
                }
                if ((sOAPHeader = this.sm.getSOAPHeader()) != null) {
                    this.headerAttrs = sOAPHeader.getAttributes();
                    Iterator iterator = sOAPHeader.examineAllHeaderElements();
                    while (iterator.hasNext()) {
                        this.headers.add(new SAAJHeader((SOAPHeaderElement)iterator.next()));
                    }
                }
                this.attachmentSet = new SAAJAttachmentSet(this.sm);
                this.parsedMessage = true;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
    }

    protected void access() {
        if (!this.accessedMessage) {
            try {
                this.envelopeAttrs = this.sm.getSOAPPart().getEnvelope().getAttributes();
                SOAPBody sOAPBody = this.sm.getSOAPBody();
                this.bodyAttrs = sOAPBody.getAttributes();
                this.soapVersion = SOAPVersion.fromNsUri(sOAPBody.getNamespaceURI());
                this.bodyParts = DOMUtil.getChildElements(sOAPBody);
                Element element = this.payload = this.bodyParts.size() > 0 ? this.bodyParts.get(0) : null;
                if (this.payload != null) {
                    this.payloadLocalName = this.payload.getLocalName();
                    this.payloadNamespace = this.payload.getNamespaceURI();
                }
                this.accessedMessage = true;
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }
    }

    @Override
    public boolean hasHeaders() {
        this.parse();
        return this.headers.hasHeaders();
    }

    @Override
    @NotNull
    public MessageHeaders getHeaders() {
        this.parse();
        return this.headers;
    }

    @Override
    @NotNull
    public AttachmentSet getAttachments() {
        if (this.attachmentSet == null) {
            this.attachmentSet = new SAAJAttachmentSet(this.sm);
        }
        return this.attachmentSet;
    }

    @Override
    protected boolean hasAttachments() {
        return !this.getAttachments().isEmpty();
    }

    @Override
    @Nullable
    public String getPayloadLocalPart() {
        this.soapBodyFirstChild();
        return this.payloadLocalName;
    }

    @Override
    public String getPayloadNamespaceURI() {
        this.soapBodyFirstChild();
        return this.payloadNamespace;
    }

    @Override
    public boolean hasPayload() {
        return this.soapBodyFirstChild() != null;
    }

    private void addAttributes(Element element, NamedNodeMap namedNodeMap) {
        if (namedNodeMap == null) {
            return;
        }
        String string = element.getPrefix();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getLocalName())) {
                if (string == null && attr.getLocalName().equals("xmlns") || string != null && "xmlns".equals(attr.getPrefix()) && string.equals(attr.getLocalName())) continue;
                element.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
                continue;
            }
            element.setAttributeNS(attr.getNamespaceURI(), attr.getName(), attr.getValue());
        }
    }

    @Override
    public Source readEnvelopeAsSource() {
        try {
            if (!this.parsedMessage) {
                SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
                return new DOMSource(sOAPEnvelope);
            }
            SOAPMessage sOAPMessage = this.soapVersion.getMessageFactory().createMessage();
            this.addAttributes(sOAPMessage.getSOAPPart().getEnvelope(), this.envelopeAttrs);
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            this.addAttributes(sOAPBody, this.bodyAttrs);
            for (Element object : this.bodyParts) {
                Node node = sOAPBody.getOwnerDocument().importNode(object, true);
                sOAPBody.appendChild(node);
            }
            this.addAttributes(sOAPMessage.getSOAPHeader(), this.headerAttrs);
            for (Header header : this.headers.asList()) {
                header.writeTo(sOAPMessage);
            }
            SOAPEnvelope sOAPEnvelope = sOAPMessage.getSOAPPart().getEnvelope();
            return new DOMSource(sOAPEnvelope);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public SOAPMessage readAsSOAPMessage() throws SOAPException {
        Object object;
        if (!this.parsedMessage) {
            return this.sm;
        }
        SOAPMessage sOAPMessage = this.soapVersion.getMessageFactory().createMessage();
        this.addAttributes(sOAPMessage.getSOAPPart().getEnvelope(), this.envelopeAttrs);
        SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
        this.addAttributes(sOAPBody, this.bodyAttrs);
        for (Element object2 : this.bodyParts) {
            object = sOAPBody.getOwnerDocument().importNode(object2, true);
            sOAPBody.appendChild((Node)object);
        }
        this.addAttributes(sOAPMessage.getSOAPHeader(), this.headerAttrs);
        for (Header header : this.headers.asList()) {
            header.writeTo(sOAPMessage);
        }
        for (Attachment attachment : this.getAttachments()) {
            object = sOAPMessage.createAttachmentPart();
            ((AttachmentPart)object).setDataHandler(attachment.asDataHandler());
            ((AttachmentPart)object).setContentId('<' + attachment.getContentId() + '>');
            this.addCustomMimeHeaders(attachment, (AttachmentPart)object);
            sOAPMessage.addAttachmentPart((AttachmentPart)object);
        }
        sOAPMessage.saveChanges();
        return sOAPMessage;
    }

    private void addCustomMimeHeaders(Attachment attachment, AttachmentPart attachmentPart) {
        if (attachment instanceof AttachmentEx) {
            Iterator<AttachmentEx.MimeHeader> iterator = ((AttachmentEx)attachment).getMimeHeaders();
            while (iterator.hasNext()) {
                AttachmentEx.MimeHeader mimeHeader = iterator.next();
                String string = mimeHeader.getName();
                if ("Content-Type".equalsIgnoreCase(string) || "Content-Id".equalsIgnoreCase(string)) continue;
                attachmentPart.addMimeHeader(string, mimeHeader.getValue());
            }
        }
    }

    @Override
    public Source readPayloadAsSource() {
        this.access();
        return this.payload != null ? new DOMSource(this.payload) : null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Unmarshaller unmarshaller) throws JAXBException {
        this.access();
        if (this.payload != null) {
            if (this.hasAttachments()) {
                unmarshaller.setAttachmentUnmarshaller(new AttachmentUnmarshallerImpl(this.getAttachments()));
            }
            return (T)unmarshaller.unmarshal(this.payload);
        }
        return null;
    }

    @Override
    public <T> T readPayloadAsJAXB(Bridge<T> bridge) throws JAXBException {
        this.access();
        if (this.payload != null) {
            return bridge.unmarshal(this.payload, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        }
        return null;
    }

    @Override
    public <T> T readPayloadAsJAXB(XMLBridge<T> xMLBridge) throws JAXBException {
        this.access();
        if (this.payload != null) {
            return xMLBridge.unmarshal(this.payload, (AttachmentUnmarshaller)(this.hasAttachments() ? new AttachmentUnmarshallerImpl(this.getAttachments()) : null));
        }
        return null;
    }

    @Override
    public XMLStreamReader readPayload() throws XMLStreamException {
        return this.soapBodyFirstChildReader();
    }

    @Override
    public void writePayloadTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        this.access();
        try {
            for (Element element : this.bodyParts) {
                DOMUtil.serializeNode(element, xMLStreamWriter);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebServiceException(xMLStreamException);
        }
    }

    @Override
    public void writeTo(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        try {
            xMLStreamWriter.writeStartDocument();
            if (!this.parsedMessage) {
                DOMUtil.serializeNode(this.sm.getSOAPPart().getEnvelope(), xMLStreamWriter);
            } else {
                SOAPEnvelope sOAPEnvelope = this.sm.getSOAPPart().getEnvelope();
                DOMUtil.writeTagWithAttributes(sOAPEnvelope, xMLStreamWriter);
                if (this.hasHeaders()) {
                    if (sOAPEnvelope.getHeader() != null) {
                        DOMUtil.writeTagWithAttributes(sOAPEnvelope.getHeader(), xMLStreamWriter);
                    } else {
                        xMLStreamWriter.writeStartElement(sOAPEnvelope.getPrefix(), "Header", sOAPEnvelope.getNamespaceURI());
                    }
                    for (Header header : this.headers.asList()) {
                        header.writeTo(xMLStreamWriter);
                    }
                    xMLStreamWriter.writeEndElement();
                }
                DOMUtil.serializeNode(this.sm.getSOAPBody(), xMLStreamWriter);
                xMLStreamWriter.writeEndElement();
            }
            xMLStreamWriter.writeEndDocument();
            xMLStreamWriter.flush();
        }
        catch (SOAPException sOAPException) {
            throw new XMLStreamException2(sOAPException);
        }
    }

    @Override
    public void writeTo(ContentHandler contentHandler, ErrorHandler errorHandler) throws SAXException {
        String string = this.soapVersion.nsUri;
        if (!this.parsedMessage) {
            DOMScanner dOMScanner = new DOMScanner();
            dOMScanner.setContentHandler(contentHandler);
            dOMScanner.scan(this.sm.getSOAPPart());
        } else {
            contentHandler.setDocumentLocator(NULL_LOCATOR);
            contentHandler.startDocument();
            contentHandler.startPrefixMapping("S", string);
            this.startPrefixMapping(contentHandler, this.envelopeAttrs, "S");
            contentHandler.startElement(string, "Envelope", "S:Envelope", this.getAttributes(this.envelopeAttrs));
            if (this.hasHeaders()) {
                this.startPrefixMapping(contentHandler, this.headerAttrs, "S");
                contentHandler.startElement(string, "Header", "S:Header", this.getAttributes(this.headerAttrs));
                MessageHeaders messageHeaders = this.getHeaders();
                for (Header header : messageHeaders.asList()) {
                    header.writeTo(contentHandler, errorHandler);
                }
                this.endPrefixMapping(contentHandler, this.headerAttrs, "S");
                contentHandler.endElement(string, "Header", "S:Header");
            }
            this.startPrefixMapping(contentHandler, this.bodyAttrs, "S");
            contentHandler.startElement(string, "Body", "S:Body", this.getAttributes(this.bodyAttrs));
            this.writePayloadTo(contentHandler, errorHandler, true);
            this.endPrefixMapping(contentHandler, this.bodyAttrs, "S");
            contentHandler.endElement(string, "Body", "S:Body");
            this.endPrefixMapping(contentHandler, this.envelopeAttrs, "S");
            contentHandler.endElement(string, "Envelope", "S:Envelope");
        }
    }

    private AttributesImpl getAttributes(NamedNodeMap namedNodeMap) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (namedNodeMap == null) {
            return EMPTY_ATTS;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if ("xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getLocalName())) continue;
            attributesImpl.addAttribute(SAAJMessage.fixNull(attr.getNamespaceURI()), attr.getLocalName(), attr.getName(), attr.getSchemaTypeInfo().getTypeName(), attr.getValue());
        }
        return attributesImpl;
    }

    private void startPrefixMapping(ContentHandler contentHandler, NamedNodeMap namedNodeMap, String string) throws SAXException {
        if (namedNodeMap == null) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!"xmlns".equals(attr.getPrefix()) && !"xmlns".equals(attr.getLocalName()) || SAAJMessage.fixNull(attr.getPrefix()).equals(string)) continue;
            contentHandler.startPrefixMapping(SAAJMessage.fixNull(attr.getPrefix()), attr.getNamespaceURI());
        }
    }

    private void endPrefixMapping(ContentHandler contentHandler, NamedNodeMap namedNodeMap, String string) throws SAXException {
        if (namedNodeMap == null) {
            return;
        }
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            if (!"xmlns".equals(attr.getPrefix()) && !"xmlns".equals(attr.getLocalName()) || SAAJMessage.fixNull(attr.getPrefix()).equals(string)) continue;
            contentHandler.endPrefixMapping(SAAJMessage.fixNull(attr.getPrefix()));
        }
    }

    private static String fixNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    private void writePayloadTo(ContentHandler contentHandler, ErrorHandler errorHandler, boolean bl) throws SAXException {
        if (bl) {
            contentHandler = new FragmentContentHandler(contentHandler);
        }
        DOMScanner dOMScanner = new DOMScanner();
        dOMScanner.setContentHandler(contentHandler);
        dOMScanner.scan(this.payload);
    }

    @Override
    public Message copy() {
        try {
            if (!this.parsedMessage) {
                return new SAAJMessage(this.readAsSOAPMessage());
            }
            SOAPMessage sOAPMessage = this.soapVersion.getMessageFactory().createMessage();
            SOAPBody sOAPBody = sOAPMessage.getSOAPPart().getEnvelope().getBody();
            for (Element element : this.bodyParts) {
                Node node = sOAPBody.getOwnerDocument().importNode(element, true);
                sOAPBody.appendChild(node);
            }
            this.addAttributes(sOAPBody, this.bodyAttrs);
            return new SAAJMessage(this.getHeaders(), this.getAttachments(), sOAPMessage, this.soapVersion);
        }
        catch (SOAPException sOAPException) {
            throw new WebServiceException(sOAPException);
        }
    }

    @Override
    public SOAPVersion getSOAPVersion() {
        return this.soapVersion;
    }

    protected XMLStreamReader getXMLStreamReader(SOAPElement sOAPElement) {
        return null;
    }

    protected XMLStreamReader createXMLStreamReader(SOAPElement sOAPElement) {
        DOMStreamReader dOMStreamReader = new DOMStreamReader();
        dOMStreamReader.setCurrentNode(sOAPElement);
        return dOMStreamReader;
    }

    protected XMLStreamReader soapBodyFirstChildReader() {
        if (this.soapBodyFirstChildReader != null) {
            return this.soapBodyFirstChildReader;
        }
        this.soapBodyFirstChild();
        if (this.soapBodyFirstChild != null) {
            this.soapBodyFirstChildReader = this.getXMLStreamReader(this.soapBodyFirstChild);
            if (this.soapBodyFirstChildReader == null) {
                this.soapBodyFirstChildReader = this.createXMLStreamReader(this.soapBodyFirstChild);
            }
            if (this.soapBodyFirstChildReader.getEventType() == 7) {
                try {
                    while (this.soapBodyFirstChildReader.getEventType() != 1) {
                        this.soapBodyFirstChildReader.next();
                    }
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new RuntimeException(xMLStreamException);
                }
            }
            return this.soapBodyFirstChildReader;
        }
        this.payloadLocalName = null;
        this.payloadNamespace = null;
        return null;
    }

    SOAPElement soapBodyFirstChild() {
        if (this.soapBodyFirstChild != null) {
            return this.soapBodyFirstChild;
        }
        try {
            Object object;
            boolean bl = false;
            for (object = this.sm.getSOAPBody().getFirstChild(); object != null && !bl; object = object.getNextSibling()) {
                if (object.getNodeType() != 1) continue;
                bl = true;
                if (!(object instanceof SOAPElement)) continue;
                this.soapBodyFirstChild = (SOAPElement)object;
                this.payloadLocalName = this.soapBodyFirstChild.getLocalName();
                this.payloadNamespace = this.soapBodyFirstChild.getNamespaceURI();
                return this.soapBodyFirstChild;
            }
            if (bl) {
                object = this.sm.getSOAPBody().getChildElements();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof SOAPElement)) continue;
                    this.soapBodyFirstChild = (SOAPElement)e;
                    this.payloadLocalName = this.soapBodyFirstChild.getLocalName();
                    this.payloadNamespace = this.soapBodyFirstChild.getNamespaceURI();
                    return this.soapBodyFirstChild;
                }
            }
        }
        catch (SOAPException sOAPException) {
            throw new RuntimeException(sOAPException);
        }
        return this.soapBodyFirstChild;
    }

    protected static class SAAJAttachment
    implements AttachmentEx {
        final AttachmentPart ap;
        String contentIdNoAngleBracket;

        public SAAJAttachment(AttachmentPart attachmentPart) {
            this.ap = attachmentPart;
        }

        @Override
        public String getContentId() {
            if (this.contentIdNoAngleBracket == null) {
                this.contentIdNoAngleBracket = this.ap.getContentId();
                if (this.contentIdNoAngleBracket != null && this.contentIdNoAngleBracket.charAt(0) == '<') {
                    this.contentIdNoAngleBracket = this.contentIdNoAngleBracket.substring(1, this.contentIdNoAngleBracket.length() - 1);
                }
            }
            return this.contentIdNoAngleBracket;
        }

        @Override
        public String getContentType() {
            return this.ap.getContentType();
        }

        @Override
        public byte[] asByteArray() {
            try {
                return this.ap.getRawContentBytes();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public DataHandler asDataHandler() {
            try {
                return this.ap.getDataHandler();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public Source asSource() {
            try {
                return new StreamSource(this.ap.getRawContent());
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public InputStream asInputStream() {
            try {
                return this.ap.getRawContent();
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            try {
                ASCIIUtility.copyStream(this.ap.getRawContent(), outputStream);
            }
            catch (SOAPException sOAPException) {
                throw new WebServiceException(sOAPException);
            }
        }

        @Override
        public void writeTo(SOAPMessage sOAPMessage) {
            sOAPMessage.addAttachmentPart(this.ap);
        }

        AttachmentPart asAttachmentPart() {
            return this.ap;
        }

        @Override
        public Iterator<AttachmentEx.MimeHeader> getMimeHeaders() {
            final Iterator iterator = this.ap.getAllMimeHeaders();
            return new Iterator<AttachmentEx.MimeHeader>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public AttachmentEx.MimeHeader next() {
                    final MimeHeader mimeHeader = (MimeHeader)iterator.next();
                    return new AttachmentEx.MimeHeader(){

                        @Override
                        public String getName() {
                            return mimeHeader.getName();
                        }

                        @Override
                        public String getValue() {
                            return mimeHeader.getValue();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    protected static class SAAJAttachmentSet
    implements AttachmentSet {
        private Map<String, Attachment> attMap;
        private Iterator attIter;

        public SAAJAttachmentSet(SOAPMessage sOAPMessage) {
            this.attIter = sOAPMessage.getAttachments();
        }

        @Override
        public Attachment get(String string) {
            if (this.attMap == null) {
                if (!this.attIter.hasNext()) {
                    return null;
                }
                this.attMap = this.createAttachmentMap();
            }
            if (string.charAt(0) != '<') {
                return this.attMap.get('<' + string + '>');
            }
            return this.attMap.get(string);
        }

        @Override
        public boolean isEmpty() {
            if (this.attMap != null) {
                return this.attMap.isEmpty();
            }
            return !this.attIter.hasNext();
        }

        @Override
        public Iterator<Attachment> iterator() {
            if (this.attMap == null) {
                this.attMap = this.createAttachmentMap();
            }
            return this.attMap.values().iterator();
        }

        private Map<String, Attachment> createAttachmentMap() {
            HashMap<String, Attachment> hashMap = new HashMap<String, Attachment>();
            while (this.attIter.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)this.attIter.next();
                hashMap.put(attachmentPart.getContentId(), new SAAJAttachment(attachmentPart));
            }
            return hashMap;
        }

        @Override
        public void add(Attachment attachment) {
            this.attMap.put('<' + attachment.getContentId() + '>', attachment);
        }
    }
}

