/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream.buffer.stax;

import com.sun.xml.internal.org.jvnet.staxex.NamespaceContextEx;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public final class NamespaceContexHelper
implements NamespaceContextEx {
    private static int DEFAULT_SIZE = 8;
    private String[] prefixes = new String[DEFAULT_SIZE];
    private String[] namespaceURIs = new String[DEFAULT_SIZE];
    private int namespacePosition;
    private int[] contexts = new int[DEFAULT_SIZE];
    private int contextPosition;

    public NamespaceContexHelper() {
        this.prefixes[0] = "xml";
        this.namespaceURIs[0] = "http://www.w3.org/XML/1998/namespace";
        this.prefixes[1] = "xmlns";
        this.namespaceURIs[1] = "http://www.w3.org/2000/xmlns/";
        this.namespacePosition = 2;
    }

    @Override
    public String getNamespaceURI(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        string = string.intern();
        for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.prefixes[i];
            if (string2 != string) continue;
            return this.namespaceURIs[i];
        }
        return "";
    }

    @Override
    public String getPrefix(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.namespaceURIs[i];
            if (string2 != string && !string2.equals(string)) continue;
            String string3 = this.prefixes[i];
            ++i;
            while (i < this.namespacePosition) {
                if (string3 == this.prefixes[i]) {
                    return null;
                }
                ++i;
            }
            return string3;
        }
        return null;
    }

    @Override
    public Iterator getPrefixes(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: for (int i = this.namespacePosition - 1; i >= 0; --i) {
            String string2 = this.namespaceURIs[i];
            if (string2 != string && !string2.equals(string)) continue;
            String string3 = this.prefixes[i];
            for (int j = i + 1; j < this.namespacePosition; ++j) {
                if (string3 == this.prefixes[j]) continue block0;
            }
            arrayList.add(string3);
        }
        return arrayList.iterator();
    }

    @Override
    public Iterator<NamespaceContextEx.Binding> iterator() {
        if (this.namespacePosition == 2) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList<NamespaceBindingImpl> arrayList = new ArrayList<NamespaceBindingImpl>(this.namespacePosition);
        for (int i = this.namespacePosition - 1; i >= 2; --i) {
            String string = this.prefixes[i];
            for (int j = i + 1; j < this.namespacePosition && string != this.prefixes[j]; ++j) {
                arrayList.add(new NamespaceBindingImpl(i));
            }
        }
        return arrayList.iterator();
    }

    public void declareDefaultNamespace(String string) {
        this.declareNamespace("", string);
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if ((string = string.intern()) == "xml" || string == "xmlns") {
            return;
        }
        if (string2 != null) {
            string2 = string2.intern();
        }
        if (this.namespacePosition == this.namespaceURIs.length) {
            this.resizeNamespaces();
        }
        this.prefixes[this.namespacePosition] = string;
        this.namespaceURIs[this.namespacePosition++] = string2;
    }

    private void resizeNamespaces() {
        int n = this.namespaceURIs.length * 3 / 2 + 1;
        String[] stringArray = new String[n];
        System.arraycopy(this.prefixes, 0, stringArray, 0, this.prefixes.length);
        this.prefixes = stringArray;
        String[] stringArray2 = new String[n];
        System.arraycopy(this.namespaceURIs, 0, stringArray2, 0, this.namespaceURIs.length);
        this.namespaceURIs = stringArray2;
    }

    public void pushContext() {
        if (this.contextPosition == this.contexts.length) {
            this.resizeContexts();
        }
        this.contexts[this.contextPosition++] = this.namespacePosition;
    }

    private void resizeContexts() {
        int[] nArray = new int[this.contexts.length * 3 / 2 + 1];
        System.arraycopy(this.contexts, 0, nArray, 0, this.contexts.length);
        this.contexts = nArray;
    }

    public void popContext() {
        if (this.contextPosition > 0) {
            this.namespacePosition = this.contexts[--this.contextPosition];
        }
    }

    public void resetContexts() {
        this.namespacePosition = 2;
    }

    private final class NamespaceBindingImpl
    implements NamespaceContextEx.Binding {
        int index;

        NamespaceBindingImpl(int n) {
            this.index = n;
        }

        @Override
        public String getPrefix() {
            return NamespaceContexHelper.this.prefixes[this.index];
        }

        @Override
        public String getNamespaceURI() {
            return NamespaceContexHelper.this.namespaceURIs[this.index];
        }
    }
}

