/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.dom;

import com.sun.org.apache.xalan.internal.xsltc.runtime.BasisLibrary;
import com.sun.org.apache.xml.internal.dtm.DTMAxisIterator;
import com.sun.org.apache.xml.internal.dtm.DTMFilter;
import com.sun.org.apache.xml.internal.dtm.ref.DTMAxisIteratorBase;

public final class FilterIterator
extends DTMAxisIteratorBase {
    private DTMAxisIterator _source;
    private final DTMFilter _filter;
    private final boolean _isReverse;

    public FilterIterator(DTMAxisIterator dTMAxisIterator, DTMFilter dTMFilter) {
        this._source = dTMAxisIterator;
        this._filter = dTMFilter;
        this._isReverse = dTMAxisIterator.isReverse();
    }

    @Override
    public boolean isReverse() {
        return this._isReverse;
    }

    @Override
    public void setRestartable(boolean bl) {
        this._isRestartable = bl;
        this._source.setRestartable(bl);
    }

    @Override
    public DTMAxisIterator cloneIterator() {
        try {
            FilterIterator filterIterator = (FilterIterator)super.clone();
            filterIterator._source = this._source.cloneIterator();
            filterIterator._isRestartable = false;
            return filterIterator.reset();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            BasisLibrary.runTimeError("ITERATOR_CLONE_ERR", cloneNotSupportedException.toString());
            return null;
        }
    }

    @Override
    public DTMAxisIterator reset() {
        this._source.reset();
        return this.resetPosition();
    }

    @Override
    public int next() {
        int n;
        while ((n = this._source.next()) != -1) {
            if (this._filter.acceptNode(n, -1) != 1) continue;
            return this.returnNode(n);
        }
        return -1;
    }

    @Override
    public DTMAxisIterator setStartNode(int n) {
        if (this._isRestartable) {
            this._startNode = n;
            this._source.setStartNode(this._startNode);
            return this.resetPosition();
        }
        return this;
    }

    @Override
    public void setMark() {
        this._source.setMark();
    }

    @Override
    public void gotoMark() {
        this._source.gotoMark();
    }
}

