﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using TaleWorlds.CampaignSystem;
using TaleWorlds.Core;
using TaleWorlds.Engine;
using TaleWorlds.MountAndBlade;

namespace FemaleTroops
{
    public class Core : MBSubModuleBase
    {
        private static readonly PropertyInfo hairCoverTypeProperty = typeof(ArmorComponent).GetProperty("HairCoverType");
        private static readonly PropertyInfo beardCoverTypeProperty = typeof(ArmorComponent).GetProperty("BeardCoverType");

        public override void OnGameInitializationFinished(Game game)
        {
            base.OnGameInitializationFinished(game);
            ApplyToGame(game);
        }

        private void ApplyToGame(Game g)
        {
            var config = Config.LoadFromFile();
            var source = g.ObjectManager
                .GetObjectTypeList<CharacterObject>()
                .AsQueryable()
                .Where(c => !c.IsPlayerCharacter);

            // var cultureGroups = string.Join(", ", source.Where(c => c.Culture != null).GroupBy(c => c.Culture.StringId).Select(x => x.Key).Distinct());
            // var unitGroups = string.Join(", ", source.Where(c => c.IsInfantry).Select(x => x.StringId));

            var targets = new List<CharacterObject>();
            targets.AddRange(source.Where(c => config.TargetUnits.Contains(c.StringId.ToLower())));

            if (config.TargetCultures.Length != 0)
            {
                source = source.Where(c => c.Culture != null && config.TargetCultures.Contains(c.Culture.StringId));
            }

            if (config.DoHeroes)
            {
                targets.AddRange(source.Where(c => c.IsHero));
            }
            //if (config.DoCompanions)
            //{
            //    targets.AddRange(source.Where(c => c....???));
            //}
            if (config.DoArchers)
            {
                targets.AddRange(source.Where(c => c.IsArcher));
            }
            if (config.DoSoldiers)
            {
                targets.AddRange(source.Where(c => c.IsSoldier));
            }
            if (config.DoCavalry)
            {
                targets.AddRange(source.Where(c => c.IsMounted));
            }

            foreach (var c in targets.DistinctBy(c => c.StringId))
            {
                c.IsFemale = !config.ToMale;
                if (config.HideHelmet)
                {
                    HideHelmet(c);
                }
            }
        }

        private void HideHelmet(BasicCharacterObject c)
        {
            var equip = c.Equipment.GetEquipmentFromSlot(EquipmentIndex.NumAllWeaponSlots);
            if (equip.IsEmpty)
            {
                return;
            }
            var item = equip.Item;

            MetaMesh _mesh = null;
            ref MetaMesh local = ref _mesh;
            MetaMesh.GetMultiMesh(item.MultiMeshName, ref local);
            _mesh.ClearMeshes();

            // show hair and beard
            hairCoverTypeProperty.SetValue(item.ArmorComponent, ArmorComponent.HairCoverTypes.None);
            beardCoverTypeProperty.SetValue(item.ArmorComponent, ArmorComponent.BeardCoverTypes.None);
        }
    }
}
