﻿# Current Directory Game Files
$CurrentPath = $PSScriptRoot

# ErrorMessage Reset
$ErrorMessage = $null

# Check if directory Game Found
if (($CurrentPath -match "Mount & Blade II Bannerlord") -and ($CurrentPath -match "Modules"))
    {
    cls
    "###########################"
    "# MODULE UNBLOCK DDL v1.1 #"
    "###########################"
    ""
    "File being checked. Please wait..."


    $AllFolders = Get-ChildItem "$PSSCriptRoot" -directory -recurse | Where { (Get-ChildItem $_.fullName).count -ge 1 }
    $FilesBlocked = @()
    foreach ($Folder in $AllFolders)
        {
        $CurrentDirectory = $Folder.Fullname
        try
            {
            $FilesBlocked += @((Get-Item $CurrentDirectory\* -Stream zone* -ErrorAction Stop).FileName)
            }
        catch
            {
            $ErrorMessage += @($_.Exception.Message)
            }
        }

    if ($FilesBlocked -match "[A-Z]")
        {
        try
            {
            foreach ($File in $FilesBlocked)
                {
                if ($File -match "[A-Z]")
                    {
                    Unblock-File $File
                    }
                }
            }
        catch
            {
            $ErrorMessage += @($_.Exception.Message)
            }
        }

    else
        {
        cls
        "###########################"
        "# MODULE UNBLOCK DDL v1.1 #"
        "###########################"
        ""
        "No files currently locked. Everything ok"
        ""
        pause
        exit
        }

    if ($ErrorMessage -match "[A-Z]")
        {
        cls
        "###########################"
        "# MODULE UNBLOCK DDL v1.1 #"
        "###########################"
        ""
        "Impossible unblock this dll(s) file(s) :"
        $ErrorMessage
        ""
        pause
        exit
        }

    else
        {
        cls
        "###########################"
        "# MODULE UNBLOCK DDL v1.1 #"
        "###########################"
        ""
        "Scrit successfully unblocked the files below : "
        $FilesBlocked
        ""
        pause
        exit
        }

    }

else
    {
    cls
    "###########################"
    "# MODULE UNBLOCK DDL v1.1 #"
    "###########################"
    ""
    "This script was not executed in the game directory. Please place me in the 'Mount & Blade II Bannerlord\Module' directory"
    ""
    pause
    exit
    }
