var Util = (function () {
  'use strict';

  return {
    openUrl: openUrl,
    trackPage: trackPage,
    trackDownload: trackDownload,
    trackSettingChange: trackSettingChange
  };

  function openUrl(url) {
    window.cep.util.openURLInDefaultBrowser(url);
  }

  function trackPage(path) {
    ga('set', 'page', path);
    ga('send', 'pageview');
  }

  function trackDownload(id) {
    var action = Settings.shouldClip() ? 'download-should-clip' : 'download-no-clip';
    ga('send', 'event', {
      'eventCategory': 'download',
      'eventAction': action,
      'eventLabel': id
    });
  }

  function trackSettingChange(label) {
    ga('send', 'event', {
      'eventCategory': 'downloadSizeSetting',
      'eventAction': 'change',
      'eventLabel': label
    });
  }

}());