var Tabs = (function () {
  'use strict';

  var lastActiveTab = 'recent';

  return {
    init: init,
    hide: hide,
    openLastTab: openLastTab,
    openTabByName: openTabByName
  };

  function init() {
    $('.js-tab').on('click', switchTabs);
    Recent.show();
  }

  function hide() {
    reset();
    $('.js-tabs').addClass('hidden');
  }

  function show() {
    reset();
    Search.reset();
    $('.js-tabs').removeClass('hidden');
  }

  function reset() {
    $('.js-photos').html('');
    $('.js-tab').removeClass('ps-button--active');
    Popular.hide();
  }

  function switchTabs(event) {
    var tabButton = $(this);
    openTab(tabButton);
  }

  function openLastTab() {
    openTabByName(lastActiveTab);
  }

  function openTabByName(name) {
    var tabButton = $('[data-type="' + name + '"]');
    openTab(tabButton);
  }

  function openTab(tabButton) {
    show();
    window.scrollTo(0, 0);
    tabButton.addClass('ps-button--active');
    var type = tabButton.attr('data-type');
    lastActiveTab = type;

    if (type === 'recent') {
      Recent.show();
    } else if (type === 'popular') {
      Popular.show();
    } else if (type === 'likes') {
      Likes.show();
    }
  }

}());