var PopularSearches = (function () {
  'use strict';

  var POPULAR_SEARCHES = [
    'nature', 'landscape', 'pet', 'sunset', 'animal', 'party', 'farm', 'technology', 'people', 'city', 'business', 'art', 'vintage', 'fashion', 'flowers', 'black-and-white', 'car', 'abstract', 'beach', 'computer', 'smartphone', 'sport', 'universe', 'lake', 'sky', 'sea', 'desert', 'food', 'love', 'color: red', 'color: green', 'color: blue', 'color: yellow'
  ];
  var popularSearches = $('.js-popular-searches');

  return {
    show: show,
    hide: hide
  };

  function show() {
    popularSearches.removeClass('hidden');
    showPopularSearches();
  }

  function hide() {
    popularSearches.addClass('hidden');
  }

  function showPopularSearches() {
    if (popularSearches.find('a').length) {
      return;
    }

    shuffle(POPULAR_SEARCHES);
    var elements = new Array(10);

    for (var i = 0; i < 10; i++) {
      var element = $(document.createElement('a'));
      element.text(POPULAR_SEARCHES[i]);
      element.attr('onclick', 'Search.search("' + POPULAR_SEARCHES[i] + '")');
      elements[i] = element;
    }
    popularSearches.append(elements);
  }

  function shuffle(array) {
    var currentIndex = array.length,
      temporaryValue,
      randomIndex;

    // while there remain elements to shuffle
    while (0 !== currentIndex) {

      // pick a remaining element
      randomIndex = Math.floor(Math.random() * currentIndex);
      currentIndex -= 1;

      // swap it with the current element
      temporaryValue = array[currentIndex];
      array[currentIndex] = array[randomIndex];
      array[randomIndex] = temporaryValue;
    }

    return array;
  }


}());