var PhotoApi = (function () {
  'use strict';

  var PER_PAGE = 6;

  return {
    get: get
  };

  function get(url) {
    LoadingBar.show();
    var url = setUrlParams(url);
    $.ajax({
      url: url,
      type: 'GET',
      dataType: 'json',
      beforeSend: Authorization.setRequestHeaders,
      success: function(data) {
        var isFirstPage = (data.page === 1);
        PhotoView.insert(data.photos, data.next_page, isFirstPage);
        LoadingBar.hide();
      },
      error: function(data) {
        if (data.status === 402) {
          BuyPro.show();
        } else if (data.status === 401) {
          Authorization.logout();
        }
      }
    });
  }

  function setUrlParams(url) {
    if (url.indexOf('page=') > -1) {
      return url;
    }
    var seperator = url.indexOf('?') > -1 ? '&' : '?';
    return API_BASE_URL + url + seperator + 'per_page=' + PER_PAGE + '&page=1';
  }

}());