var Likes = (function () {
  'use strict';

  return {
    show: show,
    toggleLike: toggleLike,
  };

  function show() {
    Util.trackPage('likes');
    PhotoApi.get('likes');
  }

  function toggleLike(photoId, isLiked) {
    if (!Authorization.isLoggedIn()) {
      Tabs.openTabByName('likes');
      return;
    }

    if (isLiked) {
      doRequest('unlike', photoId);
    } else {
      doRequest('like', photoId);
    }
  }

  function doRequest(action, photoId) {
    $.ajax({
      type: 'POST',
      dataType: 'json',
      url: API_BASE_URL + action + '?photo_id=' + photoId,
      beforeSend: Authorization.setRequestHeaders
    });
  }

}());