function PSSelectEvent(firstName) 
{
	this.onActiveSelection = null;
	this.onInActiveSelection = null;
}

PSSelectEvent.prototype.dispatchEvents = function(result)
{
	if(result == "true")
		this.onActiveSelection();
	else
		this.onInActiveSelection();
}

PSSelectEvent.prototype.runJSX = function(inst) 
{
	var extScript = "$._ext_ISSELECTIONACTIVE.run()";
	evalScript(extScript,function(result)
	{
		inst.dispatchEvents(result);
	});
	
	return true;
}

PSSelectEvent.prototype.process = function(funcName,inst)
{
    return funcName(inst);
}

PSSelectEvent.prototype.start = function(onActiveSelection,onInActiveSelection)
{
	this.onActiveSelection = onActiveSelection;
	this.onInActiveSelection = onInActiveSelection;
	this.startPoll(this.runJSX,this);
}

PSSelectEvent.prototype.startPoll = function(funcName,inst)
{
  var i = 0, limit = 100000, busy = false;
  var processor = setInterval(function()
  {
    if(!busy)
    {
      busy = true;
      
      if( !inst.process(funcName,inst) )
      {
    	  clearInterval(processor);
      }
      
      if(++i == limit)
      {
        clearInterval(processor);
      }
      
      busy = false;
    }
    
  }, 100);
}
