﻿
function onLoaded() {
    var csInterface = new CSInterface();

    var event = new CSEvent("com.adobe.PhotoshopPersistent", "APPLICATION");
    event.extensionId = "StarsTail";
    csInterface.dispatchEvent(event);

    
    var appName = csInterface.hostEnvironment.appName;
    
    if(appName != "FLPR"){
    	loadJSX();
    }    
    
    var appNames = ["PHXS"];
    for (var i = 0; i < appNames.length; i++) {
        var name = appNames[i];
        if (appName.indexOf(name) >= 0) {
           var btn = document.getElementById("btn_" + name);
           if (btn)
                btn.disabled = false;
        }
    }


    updateThemeWithAppSkinInfo(csInterface.hostEnvironment.appSkinInfo);
    // Update the color of the panel when the theme color of the product changed.
    csInterface.addEventListener(CSInterface.THEME_COLOR_CHANGED_EVENT, onAppThemeColorChanged);
}


/**
 * Update the theme with the AppSkinInfo retrieved from the host product.
 */
function updateThemeWithAppSkinInfo(appSkinInfo) {
	
    //Update the background color of the panel
    var panelBackgroundColor = appSkinInfo.panelBackgroundColor.color;
    document.body.bgColor = toHex(panelBackgroundColor);
        
    var styleId = "ppstyle";
    
    var csInterface = new CSInterface();
	var appName = csInterface.hostEnvironment.appName;
    
    if(appName == "PHXS"){
	    addRule(styleId, "button, select, input[type=button], input[type=submit]", "border-radius:3px;");
	}
	if(appName == "PHXS" || appName == "PPRO" || appName == "PRLD") {
		////////////////////////////////////////////////////////////////////////////////////////////////
		// NOTE: Below theme related code are only suitable for Photoshop.                            //
		// If you want to achieve same effect on other products please make your own changes here.    //
		////////////////////////////////////////////////////////////////////////////////////////////////
		
	    
	    var gradientBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 40) + " , " + toHex(panelBackgroundColor, 10) + ");";
	    var gradientDisabledBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, 15) + " , " + toHex(panelBackgroundColor, 5) + ");";
	    var boxShadow = "-webkit-box-shadow: inset 0 1px 0 rgba(255, 255, 255, 0.4), 0 1px 1px rgba(0, 0, 0, 0.2);";
	    var boxActiveShadow = "-webkit-box-shadow: inset 0 1px 4px rgba(0, 0, 0, 0.6);";
	    
	    var isPanelThemeLight = panelBackgroundColor.red > 127;
	    var fontColor, disabledFontColor;
	    var borderColor;
	    var inputBackgroundColor;
	    var gradientHighlightBg;
	    if(isPanelThemeLight) {
	    	fontColor = "#000000;";
	    	disabledFontColor = "color:" + toHex(panelBackgroundColor, -70) + ";";
	    	borderColor = "border-color: " + toHex(panelBackgroundColor, -90) + ";";
	    	inputBackgroundColor = toHex(panelBackgroundColor, 54) + ";";
	    	gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -40) + " , " + toHex(panelBackgroundColor,-50) + ");";
	    } else {
	    	fontColor = "#ffffff;";
	    	disabledFontColor = "color:" + toHex(panelBackgroundColor, 100) + ";";
	    	borderColor = "border-color: " + toHex(panelBackgroundColor, -45) + ";";
	    	inputBackgroundColor = toHex(panelBackgroundColor, -20) + ";";
	    	gradientHighlightBg = "background-image: -webkit-linear-gradient(top, " + toHex(panelBackgroundColor, -20) + " , " + toHex(panelBackgroundColor, -30) + ");";
	    }
	    
	
	    //Update the default text style with pp values
	    
	    addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + fontColor + "; background-color:" + toHex(panelBackgroundColor) + ";");
	    addRule(styleId, "button, select, input[type=text], input[type=button], input[type=submit]", borderColor);    
	    addRule(styleId, "button, select, input[type=button], input[type=submit]", gradientBg);    
	    addRule(styleId, "button, select, input[type=button], input[type=submit]", boxShadow);
	    addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", gradientHighlightBg);
	    addRule(styleId, "button:enabled:active, input[type=button]:enabled:active, input[type=submit]:enabled:active", boxActiveShadow);
	    addRule(styleId, "[disabled]", gradientDisabledBg);
	    addRule(styleId, "[disabled]", disabledFontColor);
	    addRule(styleId, "input[type=text]", "padding:1px 3px;");
	    addRule(styleId, "input[type=text]", "background-color: " + inputBackgroundColor) + ";";
	    addRule(styleId, "input[type=text]:focus", "background-color: #ffffff;");
	    addRule(styleId, "input[type=text]:focus", "color: #000000;");
	    
	} else {
		// For AI, ID and FL use old implementation	
		addRule(styleId, ".default", "font-size:" + appSkinInfo.baseFontSize + "px" + "; color:" + reverseColor(panelBackgroundColor) + "; background-color:" + toHex(panelBackgroundColor, 20));
	    addRule(styleId, "button", "border-color: " + toHex(panelBgColor, -50));
	}
}

function addRule(stylesheetId, selector, rule) {
    var stylesheet = document.getElementById(stylesheetId);
    
    if (stylesheet) {
        stylesheet = stylesheet.sheet;
           if( stylesheet.addRule ){
               stylesheet.addRule(selector, rule);
           } else if( stylesheet.insertRule ){
               stylesheet.insertRule(selector + ' { ' + rule + ' }', stylesheet.cssRules.length);
           }
    }
}


function reverseColor(color, delta) {
    return toHex({red:Math.abs(255-color.red), green:Math.abs(255-color.green), blue:Math.abs(255-color.blue)}, delta);
}

/**
 * Convert the Color object to string in hexadecimal format;
 */
function toHex(color, delta) {
    function computeValue(value, delta) {
        var computedValue = !isNaN(delta) ? value + delta : value;
        if (computedValue < 0) {
            computedValue = 0;
        } else if (computedValue > 255) {
            computedValue = 255;
        }

        computedValue = computedValue.toString(16);
        return computedValue.length == 1 ? "0" + computedValue : computedValue;
    }

    var hex = "";
    if (color) {
        with (color) {
             hex = computeValue(red, delta) + computeValue(green, delta) + computeValue(blue, delta);
        };
    }
    return "#" + hex;
}

function onAppThemeColorChanged(event) {
    // Should get a latest HostEnvironment object from application.
    var skinInfo = JSON.parse(window.__adobe_cep__.getHostEnvironment()).appSkinInfo;
    // Gets the style information such as color info from the skinInfo, 
    // and redraw all UI controls of your extension according to the style info.
    updateThemeWithAppSkinInfo(skinInfo);
} 



    
/**
 * Load JSX file into the scripting context of the product. All the jsx files in 
 * folder [ExtensionRoot]/jsx will be loaded. 
 */
function loadJSX() {
    var csInterface = new CSInterface();
    var extensionRoot = csInterface.getSystemPath(SystemPath.EXTENSION) + "/jsx/";
    csInterface.evalScript('$._ext.evalFiles("' + extensionRoot + '")');
}

function evalScript(script, callback) {
    new CSInterface().evalScript(script, callback);
}

function onClickButton(ppid) {
    if(ppid == "FLPR"){
    	var jsfl = 'fl.createDocument(); fl.getDocumentDOM().addNewText({left:100, top:100, right:300, bottom:300} , "Hello Flash!" ); ';
    	evalScript(jsfl);
    } else {
    	var extScript = "$._ext_" + ppid + ".run()";
		evalScript(extScript);
	}
}








function checkedRadioBtn(sGroupName)
{   
    var group = document.getElementsByName(sGroupName);
    
    for ( var i = 0; i < group.length; i++) {
        if (group.item(i).checked) {
            return group.item(i).id;
        } else if (group[0].type !== 'radio') {
            return null;
        }
    }
}


 $(function() { 
		$( "button" ).button(); 

		$( "#headL" ).val( 40 );
		$( "#tailL" ).val( 40 );
		$( "#headB" ).val( 0.1 );
		$( "#tailB" ).val( 3 );
		$( "#amount-bigger" ).val( -1 );
		$( "#amount-moveX" ).val( 0.5 );
		$( "#amount-moveY" ).val( 0.7 );
		$( "#amount-sphrX" ).val( 1 );
		$( "#amount-sphrY" ).val( 0.2 );
		$( "#amount-scaleX" ).val( 0.15 );
		$( "#amount-scaleY" ).val( 0.15 );
		$( "#amount-rotate" ).val( 0.12 );
		$( "#anchorX" ).val( 150 );
		$( "#anchorY" ).val( 100 );

		$( "#amount-moveX1" ).val( 0 );
		$( "#amount-moveY1" ).val( 0 );
		$( "#amount-scaleX1" ).val( 0 );
		$( "#amount-scaleY1" ).val( 0 );
		$( "#amount-rotate1" ).val( 5 );
/*
		$( "#anchorX1" ).val( 150 );
		$( "#anchorY1" ).val( 100 );
*/
		$( "#amount-featherF" ).val( 0 );
		$( "#amount-featherT" ).val( 5 );
		$( "#amount-stkW" ).val( 1 );
		$( "#amount-stkO" ).val( 100 );

		$( "#replace" ).button({
		  icons: {
			primary: "ui-icon-arrowthickstop-1-s"
		  },
		  text: false
		});
		$( "#plus" ).button({
		  icons: {
			primary: "ui-icon-circle-plus"
		  },
		  text: false
		});
		$( "#minus" ).button({
		  icons: {
			primary: "ui-icon-circle-minus"
		  },
		  text: false
		});
		$( "#intersect" ).button({
		  icons: {
			primary: "ui-icon-circle-close"
		  },
		  text: false
		});
		$( "#ovrl" ).button({
		  icons: {
			primary: "ui-icon-circle-triangle-s"
		  },
		  text: false
		});
		$( "#slct" ).button({
		  icons: {
			primary: "ui-icon-grip-dotted-horizontal"
		  },
		  text: false
		});
		$( "#alpa" ).button({
		  icons: {
			primary: "ui-icon-search"
		  },
		  text: false
		});
    
	    $( "#radio" ).buttonset(); 
	    $( "#radio2" ).buttonset(); 
	    $( "#radio4" ).buttonset(); 
	    $( "#radio5" ).buttonset(); 
	    $( "#checkbox" ).buttonset();
	    $( "#checkbox1" ).buttonset();
	    $( document ).tooltip();
	    $( "#tabsHorz" ).tabs();
		$( "#tabsHorz" ).width(280);//291
		$( "#tabsHorz" ).height(383);//410

/*		
		$("#headL").attr("disabled",true);
		$("#tailL").attr("disabled",true);
	    $( "#fade" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(0).checked == false )  {
				$("#headL").attr("disabled",true);
				$("#tailL").attr("disabled",true);
	    	} else {
				$("#headL").attr("disabled",false);
				$("#tailL").attr("disabled",false);
	    	}
	    });

		$("#headB").attr("disabled",true);
		$("#tailB").attr("disabled",true);
	    $( "#blur" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(1).checked == false )  {
				$("#headB").attr("disabled",true);
				$("#tailB").attr("disabled",true);
	    	} else {
				$("#headB").attr("disabled",false);
				$("#tailB").attr("disabled",false);
	    	}
	    });

		$("#amount-bigger").attr("disabled",true);
	    $( "#bigger" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(2).checked == false )  {
				$("#amount-bigger").attr("disabled",true);
	    	} else {
				$("#amount-bigger").attr("disabled",false);
	    	}
	    });
		
		$("#amount-moveX").attr("disabled",true);
		$("#amount-moveY").attr("disabled",true);
	    $( "#move" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(3).checked == false )  {
				$("#amount-moveX").attr("disabled",true);
				$("#amount-moveY").attr("disabled",true);
	    	} else {
				$("#amount-moveX").attr("disabled",false);
				$("#amount-moveY").attr("disabled",false);
	    	}
	    });

		$("#amount-sphrX").attr("disabled",true);
		$("#amount-sphrY").attr("disabled",true);
	    $( "#sphr" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(4).checked == false )  {
				$("#amount-sphrX").attr("disabled",true);
				$("#amount-sphrY").attr("disabled",true);
	    	} else {
				$("#amount-sphrX").attr("disabled",false);
				$("#amount-sphrY").attr("disabled",false);
	    	}
	    });

		$("#amount-scaleX").attr("disabled",true);
		$("#amount-scaleY").attr("disabled",true);
	    $( "#scale" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(5).checked == false )  {
				$("#amount-scaleX").attr("disabled",true);
				$("#amount-scaleY").attr("disabled",true);
				if( document.getElementsByName("checkbox").item(6).checked == false ){
					$("#anchorX").attr("disabled",true);
					$("#anchorY").attr("disabled",true);
				}
	    	} else {
				$("#amount-scaleX").attr("disabled",false);
				$("#amount-scaleY").attr("disabled",false);
				$("#anchorX").attr("disabled",false);
				$("#anchorY").attr("disabled",false);
	    	}
	    });
		
		$("#amount-rotate").attr("disabled",true);
		$("#anchorX").attr("disabled",true);
		$("#anchorY").attr("disabled",true);
	    $( "#rotate" ).click(function() {
	    	if ( document.getElementsByName("checkbox").item(6).checked == false )  {
				$("#amount-rotate").attr("disabled",true);
				if( document.getElementsByName("checkbox").item(5).checked == false ){
					$("#anchorX").attr("disabled",true);
					$("#anchorY").attr("disabled",true);
				}
	    	} else {
				$("#amount-rotate").attr("disabled",false);
				$("#anchorX").attr("disabled",false);
				$("#anchorY").attr("disabled",false);
	    	}
	    });
*/


	    $( "#buttonAvg" ).click(function(){
			var getSelectedRadio = checkedRadioBtn("radio"); 
			switch(getSelectedRadio)
			{
				case "good":
					var PSfunction = "ext_AVGgood()";
					break;
				case "normal":
					var PSfunction = "ext_AVGnormal()";
					break;
				case "fast":
					var PSfunction = "ext_AVGfast()";
					break;
				default :
					break;
				}
			evalScript( PSfunction  );
	    });
	    $( "#buttonPush" ).click(function(){
			var getSelectedRadio = checkedRadioBtn("radio4"); 
			switch(getSelectedRadio)
			{
				case "rect1":
					var PSfunction = "ext_DrRectangle()";
					break;
				case "arc1":
					var PSfunction = "ext_DrArc()";
					break;
				case "swave":
					var PSfunction = "ext_DrCurve()";
					break;
				default :
					break;
				}
			evalScript( PSfunction  );
	    });
	    $( "#buttonScale" ).click(function(){
			var getSelectedRadio = checkedRadioBtn("radio5");
			var Xval = -255;
			var Yval = -255;
			Xval = $( "#anchorX1" ).val();
			if(!Xval){Xval = -255;}	//no input
			Yval = $( "#anchorY1" ).val();
			if(!Yval){Yval = -255;}	//no input
			var PSfunction = "ext_DrRectangleC('" + getSelectedRadio + "','" + Xval + "','" + Yval + "')";
			evalScript( PSfunction );
	    });
	    $( "#buttonManual" ).click(function(){
			var offsetX = -255;	//no enable
			var offsetY = -255;	//no enable
			var scaleValX = -255;	//no enable
			var scaleValY = -255;	//no enable
			var rotateVal = -255;	//no enable
			var Xval = -255;
			var Yval = -255;
			var checkItem = 0x00;

			var cgroup = document.getElementsByName("checkbox1");
        	if (cgroup.item(0).checked) 
        	{
				checkItem = checkItem|0x01;
				offsetX = $( "#amount-moveX1" ).val();
				if(!offsetX){offsetX = -255;checkItem = checkItem&0xFE;}	//no input
				offsetY = $( "#amount-moveY1" ).val();
				if(!offsetY){offsetY = -255;checkItem = checkItem&0xFE;}	//no input
        	}
        	if (cgroup.item(1).checked) 
        	{
				checkItem = checkItem|0x02;
				scaleValX = $( "#amount-scaleX1" ).val();
				if(!scaleValX){scaleValX = -255;checkItem = checkItem&0xFD;}	//no input
				scaleValY = $( "#amount-scaleY1" ).val();
				if(!scaleValY){scaleValY = -255;checkItem = checkItem&0xFD;}	//no input
        	}

        	if (cgroup.item(2).checked) 
        	{
				checkItem = checkItem|0x04;
				rotateVal = $( "#amount-rotate1" ).val();
				if(!rotateVal){rotateVal = -255;checkItem = checkItem&0xFB;}	//no input
				Xval = $( "#anchorX1" ).val();
				if(!Xval){Xval = -255;}	//no input
				Yval = $( "#anchorY1" ).val();
				if(!Yval){Yval = -255;}	//no input
        	}
			
			var PSfunction = "ext_DrManual(" + checkItem + "," + Xval + "," + Yval + "," + offsetX + "," + offsetY + "," + scaleValX + "," + scaleValY + "," + rotateVal + ")";
			evalScript( PSfunction  );
	    });
	    $( "#btn_featherMasks" ).click(function(){
			var FvalF = 0;
			var FvalT = 0;
			FvalF = $( "#amount-featherF" ).val();
			if(!FvalF){FvalF = 0;}
			FvalT = $( "#amount-featherT" ).val();
			if(!FvalT){FvalT = 0;}
			var PSfunction = "ext_FeatherMasks('" + FvalF + "','" + FvalT + "')";
			evalScript( PSfunction );
	    });

	    $( "#btn_strokeMasks" ).click(function(){
			var SvalW = 0;
			var SvalO = 0;
			SvalW = $( "#amount-stkW" ).val();
			if(!SvalW){SvalW = 0;}
			SvalO = $( "#amount-stkO" ).val();
			if(!SvalO){SvalO = 0;}
			var PSfunction = "ext_StrokeMasks('" + SvalW + "','" + SvalO + "')";
			evalScript( PSfunction );
	    });

	    $( "#buttonMax" ).click(function(){
			var headVal = -255;	//no enable
			var tailVal = -255;	//no enable
			var headBVal = -255;	//no enable
			var tailBVal = -255;	//no enable
			var maxVal = -255;	//no enable
			var offsetX = -255;	//no enable
			var offsetY = -255;	//no enable
			var sphrX = -255;	//no enable
			var sphrY = -255;	//no enable
			var scaleValX = -255;	//no enable
			var scaleValY = -255;	//no enable
			var rotateVal = -255;	//no enable
			var Xval = 0;
			var Yval = 0;

			var cgroup = document.getElementsByName("checkbox");
        	if (cgroup.item(0).checked) 
        	{
				headVal = $( "#headL" ).val();
				tailVal = $( "#tailL" ).val();
        	}
        	if (cgroup.item(1).checked) 
        	{
				headBVal = $( "#headB" ).val();
				tailBVal = $( "#tailB" ).val();
        	}

        	if (cgroup.item(2).checked) 
        	{
				maxVal = $( "#amount-bigger" ).val();
        	}

        	if (cgroup.item(3).checked) 
        	{
				offsetX = $( "#amount-moveX" ).val();
				offsetY = $( "#amount-moveY" ).val();
        	}

        	if (cgroup.item(4).checked) 
        	{
				sphrX = $( "#amount-sphrX" ).val();
				sphrY = $( "#amount-sphrY" ).val();
        	}

        	if (cgroup.item(5).checked) 
        	{
				scaleValX = $( "#amount-scaleX" ).val();
				scaleValY = $( "#amount-scaleY" ).val();
				Xval = $( "#anchorX" ).val();
				if(!Xval){Xval = -255;}	//enable but no input
				Yval = $( "#anchorY" ).val();
				if(!Yval){Yval = -255;}	//enable but no input
        	}

        	if (cgroup.item(6).checked) 
        	{
				rotateVal = $( "#amount-rotate" ).val();
				Xval = $( "#anchorX" ).val();
				if(!Xval){Xval = -255;}	//no input
				Yval = $( "#anchorY" ).val();
				if(!Yval){Yval = -255;}	//no input
        	}
			
			var PSfunction = "ext_MAX(" + headVal + "," + tailVal + "," + headBVal + "," + tailBVal + "," + scaleValX + "," + scaleValY + "," + rotateVal + "," + Xval + "," + Yval + "," + maxVal + "," + offsetX + "," + offsetY + "," + sphrX + "," + sphrY + ")";
			evalScript( PSfunction  );
	    });

		$( "#slct" ).click(function(){var PSfunction = "ext_selectNone()";evalScript( PSfunction );});
		$( "#alpa" ).click(function(){var PSfunction = "ext_selRGB()";evalScript( PSfunction );});
		$( "#allCreate" ).click(function(){var PSfunction = "ext_allCreate()";evalScript( PSfunction );});
		$( "#allCreateColor" ).click(function(){var PSfunction = "ext_allCreateColor()";evalScript( PSfunction );});
		$( "#allDelete" ).click(function(){var PSfunction = "ext_allDelete()";evalScript( PSfunction );});
		$( "#btn_L1" ).click(function(){var chName = "L1";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_L2" ).click(function(){var chName = "L2";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_L3" ).click(function(){var chName = "L3";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_L4" ).click(function(){var chName = "L4";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_L5" ).click(function(){var chName = "L5";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M1" ).click(function(){var chName = "M1";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M2" ).click(function(){var chName = "M2";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M3" ).click(function(){var chName = "M3";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M4" ).click(function(){var chName = "M4";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M5" ).click(function(){var chName = "M5";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_H1" ).click(function(){var chName = "H1";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_H2" ).click(function(){var chName = "H2";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_H3" ).click(function(){var chName = "H3";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_H4" ).click(function(){var chName = "H4";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_H5" ).click(function(){var chName = "H5";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_0" ).click(function(){var chName = "Z0";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_1" ).click(function(){var chName = "Z1";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_2" ).click(function(){var chName = "Z2";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_3" ).click(function(){var chName = "Z3";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_4" ).click(function(){var chName = "Z4";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_5" ).click(function(){var chName = "M1";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_6" ).click(function(){var chName = "Z6";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_7" ).click(function(){var chName = "Z7";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_8" ).click(function(){var chName = "Z8";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_9" ).click(function(){var chName = "Z9";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_10" ).click(function(){var chName = "Z10";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_LM" ).click(function(){var chName = "LM";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_ML" ).click(function(){var chName = "ML";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_MH" ).click(function(){var chName = "MH";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_HM" ).click(function(){var chName = "HM";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_R" ).click(function(){var chName = "R";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_G" ).click(function(){var chName = "G";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_B" ).click(function(){var chName = "B";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_C" ).click(function(){var chName = "C";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_M" ).click(function(){var chName = "M";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_Y" ).click(function(){var chName = "Y";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_Sr" ).click(function(){var chName = "Sr";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_nSr" ).click(function(){var chName = "nSr";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_Wr" ).click(function(){var chName = "Wr";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});
		$( "#btn_Co" ).click(function(){var chName = "Co";var radioVal = checkedRadioBtn("radio2");var PSfunction = "ext_makeMask('" + chName + "','" + radioVal + "')";evalScript( PSfunction );});


		$( "#btn_sharpOutput" ).click(function(){var PSfunction = "ext_sharpOutput()";evalScript( PSfunction );});
		$( "#btn_DB" ).click(function(){var PSfunction = "ext_DB()";evalScript( PSfunction );});
		$( "#btn_sharpAll" ).click(function(){var PSfunction = "ext_sharpAll()";evalScript( PSfunction );});
		$( "#btn_sharpHI" ).click(function(){var PSfunction = "ext_sharpHI()";evalScript( PSfunction );});
		$( "#btn_sharpSurface" ).click(function(){var PSfunction = "ext_sharpSurface()";evalScript( PSfunction );});
		$( "#btn_sharpDetail" ).click(function(){var PSfunction = "ext_sharpDetail()";evalScript( PSfunction );});
		$( "#btn_softAll" ).click(function(){var PSfunction = "ext_softAll()";evalScript( PSfunction );});
		$( "#btn_softHI" ).click(function(){var PSfunction = "ext_softHI()";evalScript( PSfunction );});
		$( "#btn_softNoise" ).click(function(){var PSfunction = "ext_softNoise()";evalScript( PSfunction );});
		$( "#btn_softEdge" ).click(function(){var PSfunction = "ext_softEdge()";evalScript( PSfunction );});
		$( "#btn_softHP" ).click(function(){var PSfunction = "ext_softHP()";evalScript( PSfunction );});
		$( "#btn_softWhiteEdge" ).click(function(){var PSfunction = "ext_softWhiteEdge()";evalScript( PSfunction );});
		$( "#btn_findStars" ).click(function(){var PSfunction = "ext_findStars()";evalScript( PSfunction );});
		$( "#btn_darkFrame" ).click(function(){var PSfunction = "ext_darkFrame()";evalScript( PSfunction );});
		$( "#btn_CreateMsk" ).click(function(){var PSfunction = "ext_CreateMsk()";evalScript( PSfunction );});
		$( "#btn_DeleteMsk" ).click(function(){var PSfunction = "ext_DeleteMsk()";evalScript( PSfunction );});
		$( "#btn_ApplyMsk" ).click(function(){var PSfunction = "ext_ApplyMsk()";evalScript( PSfunction );});
		$( "#btn_ActionStack" ).click(function(){var PSfunction = "ext_ActionStack()";evalScript( PSfunction );});

}); 
