/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.pdown.core.boot.HttpDownBootstrap;
import org.pdown.core.boot.URLHttpDownBootstrapBuilder;
import org.pdown.core.dispatch.HttpDownCallback;
import org.pdown.core.entity.HttpDownConfigInfo;
import org.pdown.core.entity.HttpResponseInfo;
import org.pdown.core.proxy.ProxyConfig;
import org.pdown.core.proxy.ProxyType;
import org.pdown.core.util.FileUtil;
import org.pdown.core.util.OsUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.content.PDownConfigContent;
import org.pdown.gui.entity.PDownConfigInfo;
import org.pdown.gui.extension.mitm.server.PDownProxyServer;
import org.pdown.gui.extension.mitm.util.ExtensionCertUtil;
import org.pdown.gui.extension.mitm.util.ExtensionProxyUtil;
import org.pdown.gui.util.AppUtil;
import org.pdown.rest.util.PathUtil;
import org.springframework.util.StringUtils;

public class AppUtil {
    public static final String SUBJECT = "ProxyeeDown CA";
    public static final String SSL_PATH = PathUtil.ROOT_PATH + File.separator + "ssl" + File.separator;
    public static final String CERT_PATH = SSL_PATH + "ca.crt";
    public static final String PRIVATE_PATH = SSL_PATH + ".ca_pri.der";

    public static boolean checkIsInstalledCert() throws Exception {
        return FileUtil.exists((String)CERT_PATH) && FileUtil.exists((String)PRIVATE_PATH) && ExtensionCertUtil.isInstalledCert((File)new File(CERT_PATH));
    }

    public static void refreshPAC() throws IOException {
        if (((PDownConfigInfo)PDownConfigContent.getInstance().get()).getProxyMode() == 1) {
            ExtensionProxyUtil.enabledPACProxy((String)("http://127.0.0.1:" + DownApplication.INSTANCE.API_PORT + "/pac/pdown.pac?t=" + System.currentTimeMillis()));
        }
    }

    public static void startProxyServer() throws IOException {
        DownApplication.INSTANCE.PROXY_PORT = OsUtil.getFreePort((int)9999);
        PDownProxyServer.start((int)DownApplication.INSTANCE.PROXY_PORT);
    }

    public static void download(String url, String path) throws IOException {
        HttpURLConnection connection;
        URL u = new URL(url);
        ProxyConfig proxyConfig = ((PDownConfigInfo)PDownConfigContent.getInstance().get()).getProxyConfig();
        if (proxyConfig != null) {
            Proxy.Type type = proxyConfig.getProxyType() == ProxyType.HTTP ? Proxy.Type.HTTP : Proxy.Type.SOCKS;
            if (!StringUtils.isEmpty((Object)proxyConfig.getUser())) {
                1 authenticator = new /* Unavailable Anonymous Inner Class!! */;
                Authenticator.setDefault((Authenticator)authenticator);
            }
            Proxy proxy = new Proxy(type, new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort()));
            connection = (HttpURLConnection)u.openConnection(proxy);
        } else {
            connection = (HttpURLConnection)u.openConnection();
        }
        connection.setConnectTimeout(30000);
        connection.setReadTimeout(0);
        File file = new File(path);
        if (!file.exists() || file.isDirectory()) {
            FileUtil.createFileSmart((String)file.getPath());
        }
        try (InputStream input = connection.getInputStream();
             FileOutputStream output = new FileOutputStream(file);){
            int len;
            byte[] bts = new byte[8192];
            while ((len = input.read(bts)) != -1) {
                output.write(bts, 0, len);
            }
        }
    }

    public static HttpDownBootstrap fastDownload(String url, File file, HttpDownCallback callback) throws IOException {
        HttpDownBootstrap httpDownBootstrap = new URLHttpDownBootstrapBuilder(url, null, null).callback(callback).downConfig(new HttpDownConfigInfo().setFilePath(file.getParent()).setConnections(64)).response(new HttpResponseInfo().setFileName(file.getName())).proxyConfig(((PDownConfigInfo)PDownConfigContent.getInstance().get()).getProxyConfig()).build();
        httpDownBootstrap.start();
        return httpDownBootstrap;
    }
}

