/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.handler.codec.http.HttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdown.core.boot.HttpDownBootstrap;
import org.pdown.core.entity.HttpRequestInfo;
import org.pdown.core.entity.HttpResponseInfo;
import org.pdown.core.util.HttpDownUtil;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.gui.extension.ExtensionInfo;
import org.pdown.gui.extension.HookScript;
import org.pdown.gui.extension.util.ExtensionUtil;
import org.pdown.rest.content.HttpDownContent;
import org.pdown.rest.controller.HttpDownRestCallback;
import org.pdown.rest.entity.DownInfo;
import org.pdown.rest.form.HttpRequestForm;
import org.pdown.rest.form.TaskForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;

public class HttpDownAppCallback
extends HttpDownRestCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpDownAppCallback.class);

    public void onStart(HttpDownBootstrap httpDownBootstrap) {
        super.onStart(httpDownBootstrap);
        this.commonHook(httpDownBootstrap, "start", false);
    }

    public void onResume(HttpDownBootstrap httpDownBootstrap) {
        super.onResume(httpDownBootstrap);
        this.commonHook(httpDownBootstrap, "resume", false);
    }

    public void onPause(HttpDownBootstrap httpDownBootstrap) {
        super.onPause(httpDownBootstrap);
        this.commonHook(httpDownBootstrap, "pause", false);
    }

    public void onError(HttpDownBootstrap httpDownBootstrap) {
        super.onError(httpDownBootstrap);
        this.commonHook(httpDownBootstrap, "error", true);
    }

    public void onDone(HttpDownBootstrap httpDownBootstrap) {
        super.onDone(httpDownBootstrap);
        this.commonHook(httpDownBootstrap, "done", true);
    }

    private void commonHook(HttpDownBootstrap httpDownBootstrap, String event, boolean async) {
        DownInfo downInfo = this.findDownInfo(httpDownBootstrap);
        Map taskInfo = this.buildTaskInfo(downInfo);
        if (taskInfo != null) {
            List extensionInfos = ExtensionContent.get();
            for (ExtensionInfo extensionInfo : extensionInfos) {
                HookScript.Event e;
                if (!extensionInfo.getMeta().isEnabled() || extensionInfo.getHookScript() == null || StringUtils.isEmpty((Object)extensionInfo.getHookScript().getScript()) || (e = extensionInfo.getHookScript().hasEvent(event, HttpDownUtil.getUrl((HttpRequest)httpDownBootstrap.getRequest()))) == null) continue;
                try {
                    Object result = ExtensionUtil.invoke((ExtensionInfo)extensionInfo, (HookScript.Event)e, (Object)taskInfo, (boolean)async);
                    if (result == null) continue;
                    ObjectMapper objectMapper = new ObjectMapper();
                    String temp = objectMapper.writeValueAsString(result);
                    TaskForm taskForm = (TaskForm)objectMapper.readValue(temp, TaskForm.class);
                    if (taskForm.getRequest() != null) {
                        httpDownBootstrap.setRequest(HttpDownUtil.buildRequest((String)taskForm.getRequest().getMethod(), (String)taskForm.getRequest().getUrl(), (Map)taskForm.getRequest().getHeads(), (String)taskForm.getRequest().getBody()));
                    }
                    if (taskForm.getResponse() != null) {
                        httpDownBootstrap.setResponse(taskForm.getResponse());
                    }
                    if (taskForm.getData() != null) {
                        downInfo.setData(taskForm.getData());
                    }
                    HttpDownContent.getInstance().save();
                }
                catch (Exception ex) {
                    LOGGER.error("An hook exception occurred while " + event + "()", (Throwable)ex);
                }
            }
        }
    }

    private Map<String, Object> buildTaskInfo(DownInfo downInfo) {
        if (downInfo != null) {
            HashMap<String, Object> taskForm = new HashMap<String, Object>();
            taskForm.put("id", downInfo.getId());
            taskForm.put("data", this.clone((Object)downInfo.getData(), new HashMap()));
            taskForm.put("request", HttpRequestForm.parse((HttpRequestInfo)downInfo.getBootstrap().getRequest()));
            taskForm.put("response", this.clone((Object)downInfo.getBootstrap().getResponse(), (Object)new HttpResponseInfo()));
            return taskForm;
        }
        return null;
    }

    private Object clone(Object source, Object target) {
        if (source != null && target != null) {
            BeanUtils.copyProperties((Object)source, (Object)target);
            return target;
        }
        return null;
    }
}

