/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.http.controller;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.io.InputStream;
import java.net.URI;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"/"})
public class DefaultController {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullHttpResponse handle(Channel channel, FullHttpRequest request) throws Exception {
        DefaultFullHttpResponse httpResponse;
        InputStream inputStream;
        URI uri = new URI(request.uri());
        String path = uri.getPath();
        if ("/".equals(path)) {
            path = "/index.html";
        }
        if ((inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("http" + path)) != null) {
            String mime = path.substring(path.lastIndexOf(".") + 1);
            httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            this.buildHead((FullHttpResponse)httpResponse, mime);
            try {
                int len;
                byte[] bts = new byte[8192];
                while ((len = inputStream.read(bts)) != -1) {
                    httpResponse.content().writeBytes(bts, 0, len);
                }
            }
            finally {
                inputStream.close();
            }
        } else {
            httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            this.buildHead((FullHttpResponse)httpResponse, null);
        }
        return httpResponse;
    }

    private void buildHead(FullHttpResponse httpResponse, String mime) {
        if (mime != null) {
            AsciiString contentType;
            switch (mime) {
                case "txt": 
                case "text": {
                    contentType = AsciiString.cached((String)"text/plain; charset=utf-8");
                    break;
                }
                case "html": 
                case "htm": {
                    contentType = AsciiString.cached((String)"text/html; charset=utf-8");
                    break;
                }
                case "css": {
                    contentType = AsciiString.cached((String)"text/css; charset=utf-8");
                    break;
                }
                case "js": {
                    contentType = AsciiString.cached((String)"application/javascript; charset=utf-8");
                    break;
                }
                case "png": {
                    contentType = AsciiString.cached((String)"image/png");
                    break;
                }
                case "jpg": 
                case "jpeg": {
                    contentType = AsciiString.cached((String)"image/jpeg");
                    break;
                }
                case "bmp": {
                    contentType = AsciiString.cached((String)"application/x-bmp");
                    break;
                }
                case "gif": {
                    contentType = AsciiString.cached((String)"image/gif");
                    break;
                }
                case "ico": {
                    contentType = AsciiString.cached((String)"image/x-icon");
                    break;
                }
                case "ttf": {
                    contentType = AsciiString.cached((String)"font/ttf; charset=utf-8");
                    break;
                }
                case "woff": {
                    contentType = AsciiString.cached((String)"application/font-woff; charset=utf-8");
                    break;
                }
                default: {
                    contentType = HttpHeaderValues.APPLICATION_OCTET_STREAM;
                }
            }
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        }
    }
}

