/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.pdown.core.util.FileUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.content.PDownConfigContent;
import org.pdown.gui.entity.PDownConfigInfo;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.gui.extension.ExtensionInfo;
import org.pdown.gui.extension.HookScript;
import org.pdown.gui.extension.jsruntime.JavascriptEngine;
import org.pdown.gui.util.AppUtil;
import org.pdown.gui.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionUtil.class);

    public static void install(String server, String path, String files) throws Exception {
        ExtensionUtil.download((String)server, (String)path, (String)path, (String)files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(String server, String path, String files) throws Exception {
        String extDir = ExtensionContent.EXT_DIR + File.separator + path;
        String tmpPath = path + "_tmp";
        String extTmpPath = ExtensionContent.EXT_DIR + File.separator + tmpPath;
        String extBakPath = ExtensionContent.EXT_DIR + File.separator + path + "_bak";
        try {
            String configBakPath;
            ExtensionUtil.download((String)server, (String)path, (String)tmpPath, (String)files);
            ExtensionUtil.copy((File)new File(extDir), (File)new File(extBakPath));
            String configPath = extDir + File.separator + ".ext_data/.config.dat";
            if (FileUtil.exists((String)configPath)) {
                Path bakConfigPath = Paths.get(extTmpPath + File.separator + ".ext_data/.config.dat", new String[0]);
                FileUtil.createFileSmart((String)bakConfigPath.toFile().getAbsolutePath());
                Files.copy(Paths.get(configPath, new String[0]), bakConfigPath, StandardCopyOption.REPLACE_EXISTING);
            }
            if (FileUtil.exists((String)(configBakPath = extDir + File.separator + ".ext_data/.config.dat" + ".bak"))) {
                Files.copy(Paths.get(configBakPath, new String[0]), Paths.get(extTmpPath + File.separator + ".ext_data/.config.dat" + ".bak", new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            try {
                FileUtil.deleteIfExists((String)extDir);
            }
            catch (Exception e) {
                ExtensionUtil.copy((File)new File(extBakPath), (File)new File(extDir));
                throw new IOException(e);
            }
            finally {
                FileUtil.deleteIfExists((String)extBakPath);
            }
            new File(extTmpPath).renameTo(new File(extDir));
        }
        finally {
            FileUtil.deleteIfExists((String)extTmpPath);
        }
    }

    private static void download(String server, String path, String writePath, String files) throws Exception {
        String extDir = ExtensionContent.EXT_DIR + File.separator + writePath;
        if (!FileUtil.exists((String)extDir)) {
            Files.createDirectories(Paths.get(extDir, new String[0]), new FileAttribute[0]);
        }
        for (String fileName : files.split(",")) {
            AppUtil.download((String)(server + path + fileName), (String)(extDir + File.separator + fileName));
        }
    }

    public static void copy(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            ExtensionUtil.copyDirectory((File)sourceLocation, (File)targetLocation);
        } else {
            ExtensionUtil.copyFile((File)sourceLocation, (File)targetLocation);
        }
    }

    private static void copyDirectory(File source, File target) throws IOException {
        if (!target.exists()) {
            target.mkdir();
        }
        for (String f : source.list()) {
            ExtensionUtil.copy((File)new File(source, f), (File)new File(target, f));
        }
    }

    private static void copyFile(File source, File target) throws IOException {
        if (target.exists()) {
            return;
        }
        try (FileInputStream in = new FileInputStream(source);
             FileOutputStream out = new FileOutputStream(target);){
            int length;
            byte[] buf = new byte[1024];
            while ((length = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, length);
            }
        }
    }

    public static String readRuntimeTemplate(ExtensionInfo extensionInfo) {
        String template = "";
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream("extension/runtime.js")));){
            template = reader.lines().collect(Collectors.joining("\n"));
            template = template.replace("${version}", ConfigUtil.getString((String)"version"));
            template = template.replace("${apiPort}", DownApplication.INSTANCE.API_PORT + "");
            template = template.replace("${frontPort}", DownApplication.INSTANCE.FRONT_PORT + "");
            template = template.replace("${uiMode}", ((PDownConfigInfo)PDownConfigContent.getInstance().get()).getUiMode() + "");
            String settingJson = "{}";
            if (extensionInfo.getMeta().getSettings() != null) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    settingJson = objectMapper.writeValueAsString((Object)extensionInfo.getMeta().getSettings());
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
            template = template.replace("${settings}", settingJson);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return template;
    }

    public static ScriptEngine buildExtensionRuntimeEngine(ExtensionInfo extensionInfo) throws ScriptException, NoSuchMethodException, FileNotFoundException {
        ScriptEngine engine = JavascriptEngine.buildEngine();
        Object runtime = engine.eval(ExtensionUtil.readRuntimeTemplate((ExtensionInfo)extensionInfo));
        engine.put("pdown", runtime);
        engine.eval(new FileReader(Paths.get(extensionInfo.getMeta().getFullPath(), extensionInfo.getHookScript().getScript()).toFile()));
        return engine;
    }

    public static Object invoke(ExtensionInfo extensionInfo, HookScript.Event event, Object param, boolean async) throws NoSuchMethodException, ScriptException, FileNotFoundException, InterruptedException {
        ScriptEngine engine = ExtensionUtil.buildExtensionRuntimeEngine((ExtensionInfo)extensionInfo);
        Invocable invocable = (Invocable)((Object)engine);
        Object result = invocable.invokeFunction(StringUtils.isEmpty((Object)event.getMethod()) ? event.getOn() : event.getMethod(), param);
        if (result == null || async) {
            return result;
        }
        Object[] ret = new Object[]{null};
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setAttribute("result", result, 100);
        boolean isPromise = (Boolean)engine.eval("!!result&&typeof result=='object'&&typeof result.then=='function'", (ScriptContext)ctx);
        if (isPromise) {
            CountDownLatch countDownLatch = new CountDownLatch(1);
            invocable.invokeMethod(result, "then", o -> {
                try {
                    ret[0] = o;
                }
                catch (Exception e) {
                    LOGGER.error("An exception occurred while resolve()", (Throwable)e);
                }
                finally {
                    countDownLatch.countDown();
                }
                return null;
            });
            invocable.invokeMethod(result, "catch", o -> {
                countDownLatch.countDown();
                return null;
            });
            countDownLatch.await();
        } else {
            ret[0] = result;
        }
        return ret[0];
    }

    public static void main(String[] args) {
        String url = "https://d.pcs.baidu.com/file/ab83d33b3f250a6ff472b8ffa17c3e5f?fid=336129479-250528-831181624029689&dstime=1541581115&rt=sh&sign=FDtAERVY-DCb740ccc5511e5e8fedcff06b081203-aILjqoJW3OEzB4%2Bu7Wnxz63PUho%3D&expires=8h&chkv=1&chkbd=0&chkpc=et&dp-logid=7206180716394015240&dp-callid=0&shareid=3786359813&r=663179228";
        String[] urlArray = url.split("\\?");
        StringBuilder params = new StringBuilder(urlArray[1]);
        String path = urlArray[0].substring(urlArray[0].lastIndexOf("/") + 1);
        params.append("&path=" + path).append("&check_blue=1").append("&clienttype=8").append("&devuid=BDIMXV2-O_9A2DB23216984690875184DCA864434E-C_0-D_Z4Y7YWL9-M_408D5C4224FB-V_D8F90423").append("&dtype=1").append("&eck=1").append("&ehps=1").append("&err_ver=1").append("&es=1").append("&esl=1").append("&method=locatedownload").append("&ver=4").append("&version=2.1.13.11").append("&version_app=6.4.0.6");
        System.out.println(params.toString());
    }
}

