/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.mitm.util;

import com.sun.jna.Pointer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdown.core.util.OsUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.extension.mitm.util.WinInet;
import org.pdown.gui.util.ExecUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionProxyUtil {
    public static void enabledPACProxy(String url) throws IOException {
        if (OsUtil.isWindows()) {
            String interName = ExtensionProxyUtil.getRemoteInterface();
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = ExtensionProxyUtil.buildOptionList((String)interName, (int)2);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 4;
            pOptions[0].Value.setType(Integer.TYPE);
            pOptions[1].dwOption = 4;
            pOptions[1].Value.pszValue = url;
            pOptions[1].Value.setType(String.class);
            ExtensionProxyUtil.refreshOptions((WinInet.INTERNET_PER_CONN_OPTION_LIST)list);
        } else if (OsUtil.isMac()) {
            String networkService = ExtensionProxyUtil.disabledProxy();
            ExecUtil.httpGet((String)("http://127.0.0.1:" + DownApplication.macToolPort + "/proxy/enabledPAC?ns=" + networkService + "&url=" + url));
        }
    }

    public static void enabledHTTPProxy(String host, int port) throws IOException {
        if (OsUtil.isWindows()) {
            String interName = ExtensionProxyUtil.getRemoteInterface();
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = ExtensionProxyUtil.buildOptionList((String)interName, (int)2);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 2;
            pOptions[0].Value.setType(Integer.TYPE);
            pOptions[1].dwOption = 2;
            pOptions[1].Value.pszValue = host + ":" + port;
            pOptions[1].Value.setType(String.class);
            ExtensionProxyUtil.refreshOptions((WinInet.INTERNET_PER_CONN_OPTION_LIST)list);
        } else if (OsUtil.isMac()) {
            String networkService = ExtensionProxyUtil.disabledProxy();
            ExecUtil.httpGet((String)("http://127.0.0.1:" + DownApplication.macToolPort + "/proxy/enabledHTTP?ns=" + networkService + "&host=" + host + "&port=" + port));
        }
    }

    public static String disabledProxy() throws IOException {
        if (OsUtil.isWindows()) {
            String interName = ExtensionProxyUtil.getRemoteInterface();
            WinInet.INTERNET_PER_CONN_OPTION_LIST list = ExtensionProxyUtil.buildOptionList((String)interName, (int)1);
            WinInet.INTERNET_PER_CONN_OPTION[] pOptions = (WinInet.INTERNET_PER_CONN_OPTION[])list.pOptions.toArray(list.dwOptionCount);
            pOptions[0].dwOption = 1;
            pOptions[0].Value.dwValue = 1;
            pOptions[0].Value.setType(Integer.TYPE);
            ExtensionProxyUtil.refreshOptions((WinInet.INTERNET_PER_CONN_OPTION_LIST)list);
        } else if (OsUtil.isMac()) {
            String networkService = ExtensionProxyUtil.getRemoteInterface();
            ExecUtil.httpGet((String)("http://127.0.0.1:" + DownApplication.macToolPort + "/proxy/disabled?ns=" + networkService));
            return networkService;
        }
        return null;
    }

    private static String getRemoteInterface() throws IOException {
        Map interfacesInfo = ExtensionProxyUtil.getInterfacesInfo();
        Socket socket = new Socket("www.baidu.com", 80);
        for (Map.Entry entry : interfacesInfo.entrySet()) {
            String result;
            if (!((List)entry.getValue()).contains(socket.getLocalAddress().getHostAddress())) continue;
            String remoteInterface = (String)entry.getKey();
            if (OsUtil.isWindows()) {
                try {
                    result = ExecUtil.exec((String[])new String[]{"rasdial"});
                    if (result == null || !Arrays.stream(result.split("\r\n")).anyMatch(line -> line.equals(remoteInterface))) continue;
                    return remoteInterface;
                }
                catch (IOException e) {
                    return null;
                }
            }
            if (!OsUtil.isMac()) continue;
            result = ExecUtil.exec((String[])new String[]{"networksetup", "-listnetworkserviceorder"});
            Pattern pattern = Pattern.compile("\\(Hardware\\sPort:\\s(.*),\\sDevice:\\s(.*)\\)");
            Matcher matcher = pattern.matcher(result);
            while (matcher.find()) {
                if (!matcher.group(2).equalsIgnoreCase(remoteInterface)) continue;
                return matcher.group(1);
            }
        }
        return null;
    }

    public static Map<String, List<String>> getInterfacesInfo() throws SocketException {
        HashMap<String, List<String>> interfacesInfo = new HashMap<String, List<String>>();
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress nextElement = addresses.nextElement();
                String name = networkInterface.getDisplayName();
                ArrayList<String> ipList = (ArrayList<String>)interfacesInfo.get(name);
                if (ipList == null) {
                    ipList = new ArrayList<String>();
                    interfacesInfo.put(name, ipList);
                }
                ipList.add(nextElement.getHostAddress());
            }
        }
        return interfacesInfo;
    }

    public static void main(String[] args) throws Exception {
        System.out.println(ExtensionProxyUtil.getRemoteInterface());
    }

    private static WinInet.INTERNET_PER_CONN_OPTION_LIST buildOptionList(String connectionName, int size) {
        WinInet.INTERNET_PER_CONN_OPTION_LIST list = new WinInet.INTERNET_PER_CONN_OPTION_LIST();
        list.dwSize = list.size();
        list.pszConnection = connectionName;
        list.dwOptionCount = size;
        list.pOptions = new WinInet.INTERNET_PER_CONN_OPTION.ByReference();
        if (null == list.pOptions) {
            return null;
        }
        return list;
    }

    private static boolean refreshOptions(WinInet.INTERNET_PER_CONN_OPTION_LIST list) {
        if (!WinInet.INSTANCE.InternetSetOption(Pointer.NULL, 75, list, list.size())) {
            return false;
        }
        if (!WinInet.INSTANCE.InternetSetOption(Pointer.NULL, 95, Pointer.NULL, 0)) {
            return false;
        }
        return WinInet.INSTANCE.InternetSetOption(Pointer.NULL, 37, Pointer.NULL, 0);
    }
}

