/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.mitm.intercept;

import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.StringUtil;
import java.net.URL;

public class CookieIntercept
extends HttpProxyIntercept {
    public void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
        String acceptValue = httpRequest.headers().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (acceptValue != null && acceptValue.contains("application/x-sniff-cookie")) {
            DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, (HttpHeaders)new DefaultHttpHeaders());
            httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
            AsciiString customHeadKey = AsciiString.cached((String)"X-Sniff-Cookie");
            String cookie = pipeline.getHttpRequest().headers().get((CharSequence)HttpHeaderNames.COOKIE);
            httpResponse.headers().set((CharSequence)customHeadKey, (Object)(cookie == null ? "" : cookie));
            httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, (Object)customHeadKey);
            String origin = httpRequest.headers().get((CharSequence)HttpHeaderNames.ORIGIN);
            if (StringUtil.isNullOrEmpty((String)origin)) {
                String referer = httpRequest.headers().get((CharSequence)HttpHeaderNames.REFERER);
                URL url = new URL(referer);
                origin = url.getHost();
            }
            httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, (Object)origin);
            httpResponse.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, (Object)true);
            clientChannel.writeAndFlush((Object)httpResponse);
            clientChannel.writeAndFlush((Object)new DefaultLastHttpContent());
            clientChannel.close();
        } else {
            super.beforeRequest(clientChannel, httpRequest, pipeline);
        }
    }
}

