/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.jsruntime.polyfill.property;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import org.springframework.util.StringUtils;

public class XMLHttpRequest {
    private String method;
    private String url;
    public Function onreadystatechange;
    public int readyState = 0;
    public int status = 0;
    public String responseText;
    private Map<String, String> customRequestHeads = new LinkedHashMap();
    private Map<String, String> responseHeads = new LinkedHashMap();
    private static String DEFAULT_UA = "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/69.0.3497.100 Safari/537.36";

    public void setRequestHeader(String header, String value) {
        this.customRequestHeads.put(header, value);
    }

    public String getResponseHeader(String header) {
        return (String)this.responseHeads.get(header.toLowerCase());
    }

    public void open(String method, String url) {
        this.method = method;
        this.url = url;
    }

    public void open(String method, String url, boolean async) {
        this.open(method, url);
    }

    public void send(String data) throws IOException {
        InputStream inputStream;
        Pattern pattern;
        Matcher matcher;
        URL u = new URL(this.url);
        HttpURLConnection connection = (HttpURLConnection)u.openConnection();
        this.readystatechange(1);
        connection.setRequestMethod(this.method.toUpperCase());
        connection.setRequestProperty("User-Agent", DEFAULT_UA);
        this.customRequestHeads.entrySet().stream().forEach(entry -> connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue()));
        connection.setDoOutput(true);
        if (data != null && data.trim().length() > 0) {
            try (OutputStream outputStream = connection.getOutputStream();){
                outputStream.write(data.getBytes(Charset.forName("UTF-8")));
            }
        }
        int code = connection.getResponseCode();
        connection.getHeaderFields().entrySet().forEach(entry -> {
            if (entry.getKey() != null) {
                this.responseHeads.put(((String)entry.getKey()).toLowerCase(), ((List)entry.getValue()).stream().collect(Collectors.joining("; ")));
            }
        });
        this.readystatechange(2, code);
        String charset = "UTF-8";
        String contentType = connection.getContentType();
        if (!StringUtils.isEmpty((Object)contentType) && (matcher = (pattern = Pattern.compile("charset=(.*)$", 2)).matcher(contentType)).find()) {
            charset = matcher.group(1);
        }
        InputStream inputStream2 = inputStream = code != 200 ? connection.getErrorStream() : connection.getInputStream();
        if (this.responseHeads.entrySet().stream().anyMatch(entry -> "Content-Encoding".equalsIgnoreCase((String)entry.getKey()) && ((String)entry.getValue()).matches("^.*(?i)(gzip).*$"))) {
            inputStream = new GZIPInputStream(inputStream);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, charset));){
            this.readystatechange(3, code);
            this.responseText = reader.lines().collect(Collectors.joining("\n"));
            this.readystatechange(4, code);
        }
    }

    public static void main(String[] args) throws IOException {
        URL u = new URL("http://www.baidu.com");
        Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress("127.0.0.1", 1088));
        HttpURLConnection connection = (HttpURLConnection)u.openConnection(proxy);
        System.out.println(connection.getResponseCode());
    }

    public void send() throws IOException {
        this.send(null);
    }

    private void readystatechange(int readyState, int status) {
        this.readyState = readyState;
        this.status = status;
        if (this.onreadystatechange != null) {
            this.onreadystatechange.apply(null);
        }
    }

    private void readystatechange(int readyState) {
        this.readystatechange(readyState, this.status);
    }
}

