/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.com;

import java.awt.CheckboxMenuItem;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CheckboxMenuItemGroup
implements ItemListener {
    private Set<CheckboxMenuItem> items = new HashSet();
    private ItemListener itemListener;

    public void add(CheckboxMenuItem cbmi) {
        cbmi.addItemListener((ItemListener)this);
        cbmi.setState(false);
        this.items.add(cbmi);
    }

    public void addActionListener(ItemListener itemListener) {
        this.itemListener = itemListener;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CheckboxMenuItem checkedItem = (CheckboxMenuItem)e.getSource();
        if (e.getStateChange() == 1) {
            String selectedItemName = checkedItem.getName();
            for (CheckboxMenuItem item : this.items) {
                if (item.getName().equals(selectedItemName)) continue;
                item.setState(false);
            }
            if (this.itemListener != null) {
                this.itemListener.itemStateChanged(e);
            }
        } else {
            checkedItem.setState(true);
        }
    }

    public void selectItem(CheckboxMenuItem itemToSelect) {
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            CheckboxMenuItem item;
            item.setState((item = (CheckboxMenuItem)iterator.next()) == itemToSelect);
        }
    }

    public CheckboxMenuItem getSelectedItem() {
        for (CheckboxMenuItem item : this.items) {
            if (!item.getState()) continue;
            return item;
        }
        return null;
    }
}

