/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.http.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.nio.charset.Charset;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpHandlerUtil {
    public static void writeJson(Channel channel, Object obj) {
        channel.writeAndFlush((Object)HttpHandlerUtil.buildJson((Object)obj));
    }

    public static FullHttpResponse buildJson(Object obj) {
        return HttpHandlerUtil.buildJson((Object)obj, null);
    }

    public static FullHttpResponse buildJson(Object obj, JsonInclude.Include include) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)AsciiString.cached((String)"application/json; charset=utf-8"));
        if (obj != null) {
            try {
                ObjectMapper objectMapper = new ObjectMapper();
                if (include != null) {
                    objectMapper.setSerializationInclusion(include);
                }
                String content = objectMapper.writeValueAsString(obj);
                response.content().writeBytes(content.getBytes(Charset.forName("utf-8")));
            }
            catch (JsonProcessingException e) {
                response.setStatus(HttpResponseStatus.SERVICE_UNAVAILABLE);
            }
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }

    public static FullHttpResponse buildContent(String content, String contentType) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)AsciiString.cached((String)contentType));
        if (content != null) {
            response.content().writeBytes(content.getBytes(Charset.forName("utf-8")));
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        return response;
    }
}

