/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.http.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import org.pdown.core.boot.HttpDownBootstrap;
import org.pdown.core.dispatch.HttpDownCallback;
import org.pdown.core.util.OsUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.com.Components;
import org.pdown.gui.content.PDownConfigContent;
import org.pdown.gui.entity.PDownConfigInfo;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.gui.extension.ExtensionInfo;
import org.pdown.gui.extension.HookScript;
import org.pdown.gui.extension.mitm.server.PDownProxyServer;
import org.pdown.gui.extension.mitm.util.ExtensionCertUtil;
import org.pdown.gui.extension.mitm.util.ExtensionProxyUtil;
import org.pdown.gui.extension.util.ExtensionUtil;
import org.pdown.gui.http.util.HttpHandlerUtil;
import org.pdown.gui.util.AppUtil;
import org.pdown.gui.util.ConfigUtil;
import org.pdown.gui.util.ExecUtil;
import org.pdown.rest.form.HttpRequestForm;
import org.pdown.rest.form.TaskForm;
import org.pdown.rest.util.PathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;

@RequestMapping(value={"native"})
public class NativeController {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeController.class);
    private boolean checkFlag = true;
    private static final long WEEK = 604800000L;
    private static volatile HttpDownBootstrap updateBootstrap;

    @RequestMapping(value={"dirChooser"})
    public FullHttpResponse dirChooser(Channel channel, FullHttpRequest request) throws Exception {
        Platform.runLater(() -> {
            File file = Components.dirChooser();
            HashMap<String, Object> data = null;
            if (file != null) {
                data = new HashMap<String, Object>();
                data.put("path", file.getPath());
                data.put("canWrite", file.canWrite());
                data.put("freeSpace", file.getFreeSpace());
                data.put("totalSpace", file.getTotalSpace());
            }
            HttpHandlerUtil.writeJson((Channel)channel, data);
        });
        return null;
    }

    @RequestMapping(value={"fileChooser"})
    public FullHttpResponse handle(Channel channel, FullHttpRequest request) throws Exception {
        Platform.runLater(() -> {
            File file = Components.fileChooser();
            HashMap<String, Object> data = null;
            if (file != null) {
                data = new HashMap<String, Object>();
                data.put("name", file.getName());
                data.put("path", file.getPath());
                data.put("parent", file.getParent());
                data.put("size", file.length());
            }
            HttpHandlerUtil.writeJson((Channel)channel, data);
        });
        return null;
    }

    @RequestMapping(value={"getInitConfig"})
    public FullHttpResponse getInitConfig(Channel channel, FullHttpRequest request) throws Exception {
        int rate;
        HashMap<String, Object> data = new HashMap<String, Object>();
        PDownConfigInfo configInfo = (PDownConfigInfo)PDownConfigContent.getInstance().get();
        data.put("locale", configInfo.getLocale());
        data.put("adminServer", ConfigUtil.getString((String)"adminServer"));
        boolean needCheckUpdate = false;
        if (this.checkFlag && ((rate = configInfo.getUpdateCheckRate()) == 2 || rate == 1 && System.currentTimeMillis() - configInfo.getLastUpdateCheck() > 604800000L)) {
            needCheckUpdate = true;
            this.checkFlag = false;
            configInfo.setLastUpdateCheck(System.currentTimeMillis());
            PDownConfigContent.getInstance().save();
        }
        data.put("needCheckUpdate", needCheckUpdate);
        data.put("extFileServers", configInfo.getExtFileServers());
        data.put("version", ConfigUtil.getString((String)"version"));
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"getConfig"})
    public FullHttpResponse getConfig(Channel channel, FullHttpRequest request) throws Exception {
        return HttpHandlerUtil.buildJson((Object)PDownConfigContent.getInstance().get());
    }

    @RequestMapping(value={"setConfig"})
    public FullHttpResponse setConfig(Channel channel, FullHttpRequest request) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.enable(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        PDownConfigInfo configInfo = (PDownConfigInfo)objectMapper.readValue(request.content().toString(Charset.forName("UTF-8")), PDownConfigInfo.class);
        PDownConfigInfo beforeConfigInfo = (PDownConfigInfo)PDownConfigContent.getInstance().get();
        boolean proxyChange = beforeConfigInfo.getProxyConfig() != null && configInfo.getProxyConfig() == null || configInfo.getProxyConfig() != null && beforeConfigInfo.getProxyConfig() == null || beforeConfigInfo.getProxyConfig() != null && !beforeConfigInfo.getProxyConfig().equals((Object)configInfo.getProxyConfig()) || configInfo.getProxyConfig() != null && !configInfo.getProxyConfig().equals((Object)beforeConfigInfo.getProxyConfig());
        boolean localeChange = !configInfo.getLocale().equals(beforeConfigInfo.getLocale());
        BeanUtils.copyProperties((Object)configInfo, (Object)beforeConfigInfo);
        if (localeChange) {
            DownApplication.INSTANCE.loadPopupMenu();
            DownApplication.INSTANCE.refreshBrowserMenu();
        }
        if (proxyChange && PDownProxyServer.isStart) {
            new Thread(() -> {
                PDownProxyServer.close();
                PDownProxyServer.start((int)DownApplication.INSTANCE.PROXY_PORT);
            }).start();
        }
        PDownConfigContent.getInstance().save();
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"showFile"})
    public FullHttpResponse showFile(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        String path = (String)map.get("path");
        if (!StringUtils.isEmpty((Object)path)) {
            File file = new File(path);
            if (!file.exists() || OsUtil.isUnix()) {
                Desktop.getDesktop().open(file.getParentFile());
            } else if (OsUtil.isWindows()) {
                ExecUtil.execBlock((String[])new String[]{"explorer.exe", "/select,", file.getPath()});
            } else if (OsUtil.isMac()) {
                ExecUtil.execBlock((String[])new String[]{"open", "-R", file.getPath()});
            }
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"openUrl"})
    public FullHttpResponse openUrl(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        String url = (String)map.get("url");
        Desktop.getDesktop().browse(URI.create(URLDecoder.decode(url, "UTF-8")));
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"doUpdate"})
    public FullHttpResponse doUpdate(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        String url = (String)map.get("path");
        String path = PathUtil.ROOT_PATH + File.separator + "proxyee-down-main.jar.tmp";
        File updateTmpJar = new File(path);
        if (updateTmpJar.exists()) {
            updateTmpJar.delete();
        }
        updateBootstrap = AppUtil.fastDownload((String)url, (File)updateTmpJar, (HttpDownCallback)new /* Unavailable Anonymous Inner Class!! */);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"getUpdateProgress"})
    public FullHttpResponse getUpdateProgress(Channel channel, FullHttpRequest request) throws Exception {
        HashMap<String, Number> data = new HashMap<String, Number>();
        if (updateBootstrap != null) {
            data.put("status", updateBootstrap.getTaskInfo().getStatus());
            data.put("totalSize", updateBootstrap.getResponse().getTotalSize());
            data.put("downSize", updateBootstrap.getTaskInfo().getDownSize());
            data.put("speed", updateBootstrap.getTaskInfo().getSpeed());
        } else {
            data.put("status", 0);
        }
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"doRestart"})
    public FullHttpResponse doRestart(Channel channel, FullHttpRequest request) throws Exception {
        System.out.println("proxyee-down-exit");
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"getExtensions"})
    public FullHttpResponse getExtensions(Channel channel, FullHttpRequest request) throws Exception {
        ExtensionContent.load();
        return HttpHandlerUtil.buildJson((Object)ExtensionContent.get());
    }

    @RequestMapping(value={"installExtension"})
    public FullHttpResponse installExtension(Channel channel, FullHttpRequest request) throws Exception {
        return this.extensionCommon(request, false);
    }

    @RequestMapping(value={"updateExtension"})
    public FullHttpResponse updateExtension(Channel channel, FullHttpRequest request) throws Exception {
        return this.extensionCommon(request, true);
    }

    @RequestMapping(value={"installLocalExtension"})
    public FullHttpResponse installLocalExtension(Channel channel, FullHttpRequest request) throws Exception {
        HashMap<String, ExtensionInfo> data = new HashMap<String, ExtensionInfo>();
        Map map = this.getJSONParams(request);
        String path = (String)map.get("path");
        ExtensionInfo loadExt = ExtensionContent.refresh((String)path, (boolean)true);
        if (loadExt == null) {
            return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
        }
        data.put("data", loadExt);
        AppUtil.refreshPAC();
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"uninstallExtension"})
    public FullHttpResponse uninstallExtension(Channel channel, FullHttpRequest request) throws Exception {
        HashMap data = new HashMap();
        Map map = this.getJSONParams(request);
        String path = (String)map.get("path");
        boolean local = map.get("local") != null ? (Boolean)map.get("local") : false;
        ExtensionContent.remove((String)path, (boolean)local);
        AppUtil.refreshPAC();
        return HttpHandlerUtil.buildJson(data);
    }

    private FullHttpResponse extensionCommon(FullHttpRequest request, boolean isUpdate) throws Exception {
        Map map = this.getJSONParams(request);
        String server = (String)map.get("server");
        String path = (String)map.get("path");
        String files = (String)map.get("files");
        if (isUpdate) {
            ExtensionUtil.update((String)server, (String)path, (String)files);
        } else {
            ExtensionUtil.install((String)server, (String)path, (String)files);
        }
        ExtensionContent.refresh((String)path);
        AppUtil.refreshPAC();
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"toggleExtension"})
    public FullHttpResponse toggleExtension(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        String path = (String)map.get("path");
        boolean enabled = (Boolean)map.get("enabled");
        boolean local = map.get("local") != null ? (Boolean)map.get("local") : false;
        ExtensionInfo extensionInfo = ExtensionContent.get().stream().filter(e -> e.getMeta().getPath().equals(path)).findFirst().get();
        extensionInfo.getMeta().setEnabled(enabled).save();
        ExtensionContent.refresh((String)extensionInfo.getMeta().getFullPath(), (boolean)local);
        AppUtil.refreshPAC();
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"getProxyMode"})
    public FullHttpResponse getProxyMode(Channel channel, FullHttpRequest request) throws Exception {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("mode", ((PDownConfigInfo)PDownConfigContent.getInstance().get()).getProxyMode());
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"changeProxyMode"})
    public FullHttpResponse changeProxyMode(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        int mode = (Integer)map.get("mode");
        ((PDownConfigInfo)PDownConfigContent.getInstance().get()).setProxyMode(mode);
        if (mode == 1) {
            AppUtil.refreshPAC();
        } else {
            ExtensionProxyUtil.disabledProxy();
        }
        PDownConfigContent.getInstance().save();
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"checkCert"})
    public FullHttpResponse checkCert(Channel channel, FullHttpRequest request) throws Exception {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("status", AppUtil.checkIsInstalledCert());
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"installCert"})
    public FullHttpResponse installCert(Channel channel, FullHttpRequest request) throws Exception {
        boolean status;
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        if (OsUtil.isUnix() || OsUtil.isWindowsXP()) {
            if (!AppUtil.checkIsInstalledCert()) {
                ExtensionCertUtil.buildCert((String)AppUtil.SSL_PATH, (String)"ProxyeeDown CA");
            }
            Desktop.getDesktop().open(new File(AppUtil.SSL_PATH));
            status = true;
        } else if (!AppUtil.checkIsInstalledCert()) {
            if (ExtensionCertUtil.existsCert((String)"ProxyeeDown CA")) {
                ExtensionCertUtil.uninstallCert((String)"ProxyeeDown CA");
            }
            ExtensionCertUtil.buildCert((String)AppUtil.SSL_PATH, (String)"ProxyeeDown CA");
            ExtensionCertUtil.installCert((File)new File(AppUtil.CERT_PATH));
            status = AppUtil.checkIsInstalledCert();
        } else {
            status = true;
        }
        data.put("status", status);
        if (status && !PDownProxyServer.isStart) {
            new Thread(() -> {
                try {
                    AppUtil.startProxyServer();
                }
                catch (IOException e) {
                    LOGGER.error("Start proxy server error", (Throwable)e);
                }
            }).start();
        }
        return HttpHandlerUtil.buildJson(data);
    }

    @RequestMapping(value={"copy"})
    public FullHttpResponse copy(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = null;
        if ("text".equalsIgnoreCase((String)map.get("type"))) {
            selection = new StringSelection((String)map.get("data"));
        }
        clipboard.setContents(selection, null);
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"updateExtensionSetting"})
    public FullHttpResponse updateExtensionSetting(Channel channel, FullHttpRequest request) throws Exception {
        Map map = this.getJSONParams(request);
        String path = (String)map.get("path");
        Map setting = (Map)map.get("setting");
        ExtensionInfo extensionInfo = ExtensionContent.get().stream().filter(e -> e.getMeta().getPath().equals(path)).findFirst().get();
        extensionInfo.getMeta().setSettings(setting).save();
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    @RequestMapping(value={"onResolve"})
    public FullHttpResponse onResolve(Channel channel, FullHttpRequest request) throws Exception {
        HttpRequestForm taskRequest = (HttpRequestForm)this.getJSONParams(request, HttpRequestForm.class);
        List extensionInfos = ExtensionContent.get();
        for (ExtensionInfo extensionInfo : extensionInfos) {
            HookScript.Event event;
            if (!extensionInfo.getMeta().isEnabled() || extensionInfo.getHookScript() == null || StringUtils.isEmpty((Object)extensionInfo.getHookScript().getScript()) || (event = extensionInfo.getHookScript().hasEvent("resolve", taskRequest.getUrl())) == null) continue;
            try {
                Object result = ExtensionUtil.invoke((ExtensionInfo)extensionInfo, (HookScript.Event)event, (Object)taskRequest, (boolean)false);
                if (result == null) continue;
                ObjectMapper objectMapper = new ObjectMapper();
                String temp = objectMapper.writeValueAsString(result);
                TaskForm taskForm = (TaskForm)objectMapper.readValue(temp, TaskForm.class);
                return HttpHandlerUtil.buildJson((Object)taskForm, (JsonInclude.Include)JsonInclude.Include.NON_DEFAULT);
            }
            catch (Exception e) {
                LOGGER.error("An exception occurred while resolve()", (Throwable)e);
            }
        }
        return new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
    }

    private Map<String, Object> getJSONParams(FullHttpRequest request) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (Map)objectMapper.readValue(request.content().toString(Charset.forName("UTF-8")), Map.class);
    }

    private <T> T getJSONParams(FullHttpRequest request, Class<T> clazz) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        return (T)objectMapper.readValue(request.content().toString(Charset.forName("UTF-8")), clazz);
    }
}

