/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.http;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.pdown.gui.http.controller.DefaultController;
import org.pdown.gui.http.controller.NativeController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;

public class EmbedHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmbedHttpServer.class);
    private int port;
    private DefaultController defaultController;
    private List<Object> controllerList;

    public EmbedHttpServer(int port) {
        this.port = port;
        this.defaultController = new DefaultController();
        this.controllerList = new ArrayList();
    }

    public FullHttpResponse invoke(String uri, Channel channel, FullHttpRequest request) throws Exception {
        if (this.controllerList != null) {
            for (Object obj : this.controllerList) {
                Class<?> clazz = obj.getClass();
                RequestMapping mapping = clazz.getAnnotation(RequestMapping.class);
                if (mapping == null) continue;
                String mappingUri = this.fixUri(mapping.value()[0]);
                for (Method actionMethod : clazz.getMethods()) {
                    RequestMapping subMapping = actionMethod.getAnnotation(RequestMapping.class);
                    if (subMapping == null) continue;
                    String subMappingUri = this.fixUri(subMapping.value()[0]);
                    if (!uri.equalsIgnoreCase(mappingUri + subMappingUri)) continue;
                    return (FullHttpResponse)actionMethod.invoke(obj, channel, request);
                }
            }
        }
        return this.defaultController.handle(channel, request);
    }

    private String fixUri(String uri) {
        StringBuilder builder = new StringBuilder(uri);
        if (builder.indexOf("/") != 0) {
            builder.insert(0, "/");
        }
        if (builder.lastIndexOf("/") == builder.length() - 1) {
            builder.delete(builder.length() - 1, builder.length());
        }
        return builder.toString();
    }

    public void start() {
        this.start(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(GenericFutureListener startedListener) {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(2);
        NioEventLoopGroup workGroup = new NioEventLoopGroup(2);
        try {
            ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)bossGroup, (EventLoopGroup)workGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new /* Unavailable Anonymous Inner Class!! */);
            ChannelFuture f = bootstrap.bind("127.0.0.1", this.port).sync();
            if (startedListener != null) {
                f.addListener(startedListener);
            }
            f.channel().closeFuture().sync();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            bossGroup.shutdownGracefully();
            workGroup.shutdownGracefully();
        }
    }

    public EmbedHttpServer addController(Object obj) {
        this.controllerList.add(obj);
        return this;
    }

    public static void main(String[] args) {
        new EmbedHttpServer(8998).addController((Object)new NativeController()).start();
    }

    static /* synthetic */ Logger access$000() {
        return LOGGER;
    }
}

