/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.mitm.util;

import com.github.monkeywie.proxyee.crt.CertUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pdown.core.util.FileUtil;
import org.pdown.core.util.OsUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.util.ExecUtil;
import sun.security.x509.X500Name;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionCertUtil {
    public static void buildCert(String path, String subjectName) throws Exception {
        KeyPair keyPair = CertUtil.genKeyPair();
        File priKeyFile = FileUtil.createFile((String)(path + File.separator + ".ca_pri.der"), (boolean)true);
        File caCertFile = FileUtil.createFile((String)(path + File.separator + "ca.crt"), (boolean)false);
        Files.write(Paths.get(priKeyFile.toURI()), keyPair.getPrivate().getEncoded(), new OpenOption[0]);
        Files.write(Paths.get(caCertFile.toURI()), CertUtil.genCACert((String)("C=CN, ST=GD, L=SZ, O=lee, OU=study, CN=" + subjectName), (Date)new Date(), (Date)new Date(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(3650L)), (KeyPair)keyPair).getEncoded(), new OpenOption[0]);
    }

    public static void installCert(File file) throws IOException {
        String path = file.getPath();
        if (OsUtil.isWindows()) {
            ExecUtil.execBlock((String[])new String[]{"certutil", "-addstore", "-user", "root", path});
        } else if (OsUtil.isMac()) {
            ExecUtil.httpGet((String)("http://127.0.0.1:" + DownApplication.macToolPort + "/cert/install?path=" + URLEncoder.encode(path, "utf-8")));
        }
    }

    public static boolean isInstalledCert(File file) throws Exception {
        if (!file.exists()) {
            return false;
        }
        if (OsUtil.isUnix()) {
            return true;
        }
        X509Certificate cert = CertUtil.loadCert((URI)file.toURI());
        String subjectName = ((X500Name)cert.getSubjectDN()).getCommonName();
        String sha1 = ExtensionCertUtil.getCertSHA1((X509Certificate)cert);
        return ExtensionCertUtil.findCertList((String)subjectName).toUpperCase().replaceAll("\\s", "").indexOf(":" + sha1.toUpperCase()) != -1;
    }

    public static boolean existsCert(String subjectName) throws IOException {
        if (OsUtil.isWindows() && ExtensionCertUtil.findCertList((String)subjectName).toUpperCase().indexOf("=====") != -1) {
            return true;
        }
        return OsUtil.isMac() && ExtensionCertUtil.findCertList((String)subjectName).toUpperCase().indexOf("BEGIN CERTIFICATE") != -1;
    }

    public static void uninstallCert(String subjectName) throws IOException {
        block3: {
            block2: {
                if (!OsUtil.isWindows()) break block2;
                Pattern pattern = Pattern.compile("(?i)\\(sha1\\):\\s(.*)\r?\n");
                String certList = ExtensionCertUtil.findCertList((String)subjectName);
                Matcher matcher = pattern.matcher(certList);
                while (matcher.find()) {
                    String hash = matcher.group(1).replaceAll("\\s", "");
                    ExecUtil.execBlock((String[])new String[]{"certutil", "-delstore", "-user", "root", hash});
                }
                break block3;
            }
            if (!OsUtil.isMac()) break block3;
            String certList = ExtensionCertUtil.findCertList((String)subjectName);
            Pattern pattern = Pattern.compile("(?i)SHA-1 hash:\\s(.*)\r?\n");
            Matcher matcher = pattern.matcher(certList);
            while (matcher.find()) {
                String hash = matcher.group(1);
                ExecUtil.httpGet((String)("http://127.0.0.1:" + DownApplication.macToolPort + "/cert/uninstall?hash=" + hash));
            }
        }
    }

    private static String findCertList(String subjectName) throws IOException {
        if (OsUtil.isWindows()) {
            return ExecUtil.exec((String[])new String[]{"certutil ", "-store", "-user", "root", subjectName});
        }
        if (OsUtil.isMac()) {
            return ExecUtil.exec((String[])new String[]{"security", "find-certificate", "-a", "-c", subjectName, "-p", "-Z", "/Library/Keychains/System.keychain"});
        }
        return null;
    }

    private static String getCertSHA1(X509Certificate certificate) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] der = certificate.getEncoded();
        md.update(der);
        return ExtensionCertUtil.btsToHex((byte[])md.digest());
    }

    private static String btsToHex(byte[] bts) {
        StringBuilder str = new StringBuilder();
        for (byte b : bts) {
            str.append(String.format("%2s", Integer.toHexString(b & 0xFF)).replace(" ", "0"));
        }
        return str.toString();
    }

    public static void main(String[] args) throws Exception {
        String subjectName = "ProxyeeDown CA";
        String path = "f:/test/";
        File certFile = new File(path + "ca.crt");
        if (!ExtensionCertUtil.isInstalledCert((File)certFile)) {
            if (ExtensionCertUtil.existsCert((String)subjectName)) {
                ExtensionCertUtil.uninstallCert((String)subjectName);
            }
            ExtensionCertUtil.buildCert((String)path, (String)subjectName);
            ExtensionCertUtil.installCert((File)certFile);
        }
    }
}

