/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.mitm.intercept;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.monkeywie.proxyee.intercept.HttpProxyIntercept;
import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import com.github.monkeywie.proxyee.util.HttpUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Set;
import org.pdown.core.entity.HttpRequestInfo;
import org.pdown.core.entity.HttpResponseInfo;
import org.pdown.core.util.HttpDownUtil;
import org.pdown.core.util.ProtoUtil;
import org.pdown.gui.DownApplication;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.rest.form.HttpRequestForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniffIntercept
extends HttpProxyIntercept {
    private static final Logger LOGGER = LoggerFactory.getLogger(SniffIntercept.class);
    private boolean matchFlag = false;
    private ByteBuf content;
    private boolean downFlag = false;
    private static final String[] CONTENT_TYPES = new String[]{"application/javascript", "application/x-javascript", "application/wasm", "application/x-chrome-extension", "application/xhtml+xml", "application/font-woff", "application/json", "application/x-shockwave-flash", "audio/mpeg", "audio/flac", "audio/mp3", "audio/ogg", "audio/wav", "audio/webm", "audio/x-m4a", "image/gif", "image/jpeg", "image/png", "image/apng", "image/webp", "image/x-icon", "image/bmp", "image/jpeg", "image/svg+xml", "image/tiff", "image/vnd.microsoft.icon", "image/x-png", "image/x-xbitmap", "video/webm", "video/ogg", "video/mp4", "video/mpeg", "text/css", "text/html", "text/xml", "text/calendar", "text/html", "text/plain", "text/x-sh", "text/xml", "multipart/related", "message/rfc822"};

    public void beforeRequest(Channel clientChannel, HttpRequest httpRequest, HttpProxyInterceptPipeline pipeline) throws Exception {
        Set sniffRegexs = ExtensionContent.getSniffRegexs();
        this.matchFlag = sniffRegexs == null ? false : sniffRegexs.stream().anyMatch(regex -> HttpUtil.checkUrl((HttpRequest)httpRequest, (String)regex));
        if (!this.matchFlag) {
            super.beforeRequest(clientChannel, httpRequest, pipeline);
            return;
        }
        String contentLength = httpRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        if (contentLength != null) {
            this.content = PooledByteBufAllocator.DEFAULT.buffer();
        }
        pipeline.beforeRequest(clientChannel, HttpRequestInfo.adapter((HttpRequest)httpRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeRequest(Channel clientChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (!this.matchFlag) {
            super.beforeRequest(clientChannel, httpContent, pipeline);
            return;
        }
        if (this.content != null) {
            ByteBuf temp = httpContent.content().slice();
            this.content.writeBytes(temp);
            if (httpContent instanceof LastHttpContent) {
                try {
                    byte[] contentBts = new byte[this.content.readableBytes()];
                    this.content.readBytes(contentBts);
                    ((HttpRequestInfo)pipeline.getHttpRequest()).setContent(contentBts);
                }
                finally {
                    ReferenceCountUtil.release((Object)this.content);
                }
            }
        }
        pipeline.beforeRequest(clientChannel, httpContent);
    }

    public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (!this.matchFlag) {
            super.afterResponse(clientChannel, proxyChannel, httpResponse, pipeline);
            return;
        }
        if ((httpResponse.status().code() + "").indexOf("20") == 0) {
            HttpHeaders httpResHeaders = httpResponse.headers();
            String accept = pipeline.getHttpRequest().headers().get((CharSequence)HttpHeaderNames.ACCEPT);
            String contentType = httpResHeaders.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
            String disposition = httpResHeaders.get((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION);
            if (accept != null && accept.matches("^.*text/html.*$") && (disposition != null && disposition.contains((CharSequence)HttpHeaderValues.ATTACHMENT) && disposition.contains((CharSequence)HttpHeaderValues.FILENAME) || this.isDownContentType(contentType))) {
                this.downFlag = true;
            }
            HttpRequestInfo httpRequestInfo = (HttpRequestInfo)pipeline.getHttpRequest();
            if (this.downFlag) {
                LOGGER.debug("=====================\u4e0b\u8f7d===========================\n" + pipeline.getHttpRequest().toString() + "\n------------------------------------------------" + httpResponse.toString() + "\n================================================");
                proxyChannel.close();
                httpRequestInfo.setRequestProto(new ProtoUtil.RequestProto(pipeline.getRequestProto().getHost(), pipeline.getRequestProto().getPort(), pipeline.getRequestProto().getSsl()));
                HttpRequestForm requestForm = HttpRequestForm.parse((HttpRequestInfo)httpRequestInfo);
                HttpResponseInfo responseInfo = HttpDownUtil.getHttpResponseInfo((HttpRequest)httpRequestInfo, null, null, (NioEventLoopGroup)((NioEventLoopGroup)clientChannel.eventLoop().parent()));
                httpResponse.headers().clear();
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                String js = "<script type=\"text/javascript\">window.history.go(-1)</script>";
                DefaultLastHttpContent httpContent = new DefaultLastHttpContent();
                httpContent.content().writeBytes(js.getBytes());
                httpResponse.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)httpContent.content().readableBytes());
                clientChannel.writeAndFlush((Object)httpResponse);
                clientChannel.writeAndFlush((Object)httpContent);
                clientChannel.close();
                ObjectMapper objectMapper = new ObjectMapper();
                String requestParam = URLEncoder.encode(objectMapper.writeValueAsString((Object)requestForm), "utf-8");
                String responseParam = URLEncoder.encode(objectMapper.writeValueAsString((Object)responseInfo), "utf-8");
                String uri = "/#/tasks?request=" + requestParam + "&response=" + responseParam;
                DownApplication.INSTANCE.loadUri(uri, false);
                return;
            }
            if (httpRequestInfo.content() != null) {
                httpRequestInfo.setContent(null);
            }
        }
        super.afterResponse(clientChannel, proxyChannel, httpResponse, pipeline);
    }

    public void afterResponse(Channel clientChannel, Channel proxyChannel, HttpContent httpContent, HttpProxyInterceptPipeline pipeline) throws Exception {
        if (!this.matchFlag) {
            super.afterResponse(clientChannel, proxyChannel, httpContent, pipeline);
            return;
        }
        if (this.downFlag) {
            httpContent.release();
        } else {
            pipeline.afterResponse(clientChannel, proxyChannel, httpContent);
        }
    }

    private boolean isDownContentType(String contentType) {
        if (contentType != null) {
            String contentTypeFinal = contentType.split(";")[0].trim().toLowerCase();
            return Arrays.stream(CONTENT_TYPES).noneMatch(type -> contentTypeFinal.equals(type));
        }
        return true;
    }
}

