/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension.mitm.intercept;

import com.github.monkeywie.proxyee.intercept.HttpProxyInterceptPipeline;
import com.github.monkeywie.proxyee.intercept.common.FullResponseIntercept;
import com.github.monkeywie.proxyee.util.ByteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.List;
import org.pdown.core.util.HttpDownUtil;
import org.pdown.gui.extension.ContentScript;
import org.pdown.gui.extension.ExtensionContent;
import org.pdown.gui.extension.ExtensionInfo;
import org.pdown.gui.extension.util.ExtensionUtil;

public class ScriptIntercept
extends FullResponseIntercept {
    private static final String INSERT_TOKEN = "</head>";
    private static final String INIT_TEMPLATE = ";(function (pdown) {\n  ${content}\n})(${runtime})";

    public boolean match(HttpRequest httpRequest, HttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) {
        return this.isHtml(httpRequest, httpResponse);
    }

    private String readInsertTemplate(ExtensionInfo extensionInfo) {
        String js = ExtensionUtil.readRuntimeTemplate((ExtensionInfo)extensionInfo);
        js = INIT_TEMPLATE.replace("${runtime}", js);
        js = "<script type=\"text/javascript\">\n" + js + "\n</script>";
        return js;
    }

    public void handelResponse(HttpRequest httpRequest, FullHttpResponse httpResponse, HttpProxyInterceptPipeline pipeline) {
        List extensionInfoList = ExtensionContent.get();
        if (this.isEmpty(extensionInfoList)) {
            return;
        }
        for (ExtensionInfo extensionInfo : extensionInfoList) {
            if (this.isEmpty(extensionInfo.getContentScripts())) continue;
            for (ContentScript contentScript : extensionInfo.getContentScripts()) {
                String url;
                if (!contentScript.isMatch(url = HttpDownUtil.getUrl((HttpRequest)httpRequest))) continue;
                String apiTemplate = this.readInsertTemplate(extensionInfo);
                StringBuilder scriptsBuilder = new StringBuilder();
                for (String script : contentScript.getScripts()) {
                    File scriptFile = new File(extensionInfo.getMeta().getFullPath() + File.separator + script);
                    if (!scriptFile.exists() || !scriptFile.isFile()) continue;
                    try {
                        scriptsBuilder.append(new String(Files.readAllBytes(scriptFile.toPath()), "UTF-8"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                apiTemplate = apiTemplate.replace("${content}", scriptsBuilder.toString());
                int index = ByteUtil.findText((ByteBuf)httpResponse.content(), (String)INSERT_TOKEN);
                ByteUtil.insertText((ByteBuf)httpResponse.content(), (int)(index == -1 ? 0 : index - INSERT_TOKEN.length()), (String)apiTemplate, (Charset)Charset.forName("UTF-8"));
            }
        }
    }

    private boolean isEmpty(List list) {
        return list == null || list.size() == 0;
    }
}

