/*
 * Decompiled with CFR 0.152.
 */
package org.pdown.gui.extension;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pdown.core.util.FileUtil;
import org.pdown.gui.extension.ExtensionConfig;
import org.pdown.gui.extension.ExtensionInfo;
import org.pdown.gui.extension.Meta;
import org.pdown.gui.extension.Setting;
import org.pdown.rest.util.ContentUtil;
import org.pdown.rest.util.PathUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExtensionContent {
    public static final String EXT_DIR = PathUtil.ROOT_PATH + File.separator + "extensions";
    public static final String EXT_DIR_CONFIG = EXT_DIR + File.separator + "ext.cfg";
    private static final String EXT_MANIFEST = "manifest.json";
    private static List<ExtensionInfo> EXTENSION_INFO_LIST;
    private static Set<String> PROXY_WILDCARDS;
    private static Set<String> SNIFF_REGEXS;
    private static ExtensionConfig CONFIG;

    public static void load() throws IOException {
        File file = new File(EXT_DIR);
        if (EXTENSION_INFO_LIST == null) {
            EXTENSION_INFO_LIST = new ArrayList();
        } else {
            EXTENSION_INFO_LIST.clear();
        }
        if (file.exists() && file.isDirectory()) {
            for (File extendDir : file.listFiles()) {
                ExtensionInfo extensionInfo;
                if (!extendDir.isDirectory() || (extensionInfo = ExtensionContent.parseExtensionDir((File)extendDir)) == null) continue;
                EXTENSION_INFO_LIST.add(extensionInfo);
            }
        }
        try {
            CONFIG = (ExtensionConfig)ContentUtil.get((String)EXT_DIR_CONFIG, ExtensionConfig.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (CONFIG == null) {
            CONFIG = new ExtensionConfig();
        } else if (CONFIG.getLocalExtensions() != null) {
            for (String localExtendDir : CONFIG.getLocalExtensions()) {
                ExtensionInfo extensionInfo;
                File extendDir = new File(localExtendDir);
                if (!extendDir.isDirectory() || (extensionInfo = ExtensionContent.parseExtensionDir((File)extendDir, (boolean)true)) == null) continue;
                EXTENSION_INFO_LIST.add(extensionInfo);
            }
        }
        ExtensionContent.refresh();
    }

    public static ExtensionConfig getConfig() {
        return CONFIG;
    }

    public static synchronized void saveConfig() throws IOException {
        ContentUtil.save((Object)CONFIG, (String)EXT_DIR_CONFIG);
    }

    public static synchronized ExtensionInfo refresh(String path, boolean isLocal) throws IOException {
        ExtensionInfo loadExt = ExtensionContent.parseExtensionDir((File)new File((isLocal ? "" : EXT_DIR) + path), (boolean)isLocal);
        if (loadExt != null && EXTENSION_INFO_LIST != null && path != null) {
            boolean match = false;
            for (int i = 0; i < EXTENSION_INFO_LIST.size(); ++i) {
                ExtensionInfo extensionInfo = (ExtensionInfo)EXTENSION_INFO_LIST.get(i);
                if (!loadExt.getMeta().getPath().equals(extensionInfo.getMeta().getPath()) || loadExt.getMeta().isLocal() != extensionInfo.getMeta().isLocal()) continue;
                match = true;
                EXTENSION_INFO_LIST.set(i, loadExt);
                break;
            }
            if (!match) {
                EXTENSION_INFO_LIST.add(loadExt);
                if (isLocal) {
                    if (CONFIG.getLocalExtensions() == null) {
                        CONFIG.setLocalExtensions(new ArrayList());
                    }
                    CONFIG.getLocalExtensions().add(path);
                    ExtensionContent.saveConfig();
                }
            }
            ExtensionContent.refresh();
        }
        return loadExt;
    }

    public static synchronized ExtensionInfo refresh(String path) throws IOException {
        return ExtensionContent.refresh((String)path, (boolean)false);
    }

    public static synchronized void remove(String path, boolean isLocal) throws IOException {
        if (EXTENSION_INFO_LIST != null && path != null) {
            for (int i = 0; i < EXTENSION_INFO_LIST.size(); ++i) {
                ExtensionInfo extensionInfo = (ExtensionInfo)EXTENSION_INFO_LIST.get(i);
                if (!path.equals(extensionInfo.getMeta().getPath()) || extensionInfo.getMeta().isLocal() != isLocal) continue;
                EXTENSION_INFO_LIST.remove(i);
                if (!extensionInfo.getMeta().isLocal()) {
                    FileUtil.deleteIfExists((String)extensionInfo.getMeta().getFullPath());
                    break;
                }
                if (CONFIG.getLocalExtensions() == null) break;
                CONFIG.getLocalExtensions().remove(extensionInfo.getMeta().getFullPath());
                ExtensionContent.saveConfig();
                break;
            }
            ExtensionContent.refresh();
        }
    }

    public static synchronized void refresh() {
        if (PROXY_WILDCARDS == null) {
            PROXY_WILDCARDS = new HashSet();
        } else {
            PROXY_WILDCARDS.clear();
        }
        if (SNIFF_REGEXS == null) {
            SNIFF_REGEXS = new HashSet();
        } else {
            SNIFF_REGEXS.clear();
        }
        if (EXTENSION_INFO_LIST != null) {
            for (ExtensionInfo extensionInfo : EXTENSION_INFO_LIST) {
                if (!extensionInfo.getMeta().isEnabled()) continue;
                if (extensionInfo.getProxyWildcards() != null) {
                    for (String wildcard : extensionInfo.getProxyWildcards()) {
                        PROXY_WILDCARDS.add(wildcard.trim());
                    }
                }
                if (extensionInfo.getSniffRegexs() == null) continue;
                for (String regex : extensionInfo.getSniffRegexs()) {
                    SNIFF_REGEXS.add(regex.trim());
                }
            }
        }
    }

    private static ExtensionInfo parseExtensionDir(File extendDir, boolean isLocal) {
        ExtensionInfo extensionInfo = null;
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            extensionInfo = (ExtensionInfo)objectMapper.readValue((InputStream)new FileInputStream(extendDir + File.separator + "manifest.json"), ExtensionInfo.class);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (extensionInfo != null) {
            Meta meta = Meta.load((String)extendDir.getPath());
            meta.setLocal(isLocal);
            if (extensionInfo.getSettings() != null && extensionInfo.getSettings().size() > 0) {
                if (meta.getSettings() == null) {
                    meta.setSettings(new HashMap());
                }
                if (meta.getSettings().size() == 0) {
                    for (Setting setting : extensionInfo.getSettings()) {
                        meta.getSettings().put(setting.getName(), setting.getValue());
                    }
                }
            }
            extensionInfo.setMeta(meta);
        }
        return extensionInfo;
    }

    private static ExtensionInfo parseExtensionDir(File extendDir) {
        return ExtensionContent.parseExtensionDir((File)extendDir, (boolean)false);
    }

    public static List<ExtensionInfo> get() {
        return EXTENSION_INFO_LIST;
    }

    public static Set<String> getProxyWildCards() {
        return PROXY_WILDCARDS;
    }

    public static Set<String> getSniffRegexs() {
        return SNIFF_REGEXS;
    }
}

